/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FallenLogFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private final BlockState log;
    private final int minLength;
    private final int variance;

    public FallenLogFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function, boolean doBlockNofityOnPlace, BlockState log) {
        this(function, doBlockNofityOnPlace, log, 5, 8);
    }

    public FallenLogFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function, boolean doBlockNofityOnPlace, BlockState log, int minLength, int variance) {
        super(function, doBlockNofityOnPlace);
        this.log = log;
        this.minLength = minLength;
        this.variance = variance;
    }

    protected boolean func_208519_a(Set<BlockPos> blocks, IWorldGenerationReader world, Random rand, BlockPos origin, MutableBoundingBox box) {
        int i;
        int length = rand.nextInt(this.variance) + this.minLength;
        Direction.Axis axis = rand.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z;
        Direction direction = Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)(rand.nextBoolean() ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        BlockPos below = origin.func_177977_b();
        if (!FallenLogFeature.func_214589_h((IWorldGenerationBaseReader)world, (BlockPos)below)) {
            return false;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin);
        int air = 0;
        for (i = 0; i < length; ++i) {
            pos.func_177972_a(direction);
            if (!world.func_217375_a(pos.func_177972_a(Direction.DOWN), BlockState::func_215691_g)) {
                ++air;
            }
            if (FallenLogFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177972_a(Direction.UP))) continue;
            return false;
        }
        if (air * 2 > length) {
            return false;
        }
        pos.func_189533_g((Vec3i)origin);
        for (i = 0; i < length; ++i) {
            pos.func_177972_a(direction);
            this.func_208520_a(blocks, (IWorldWriter)world, (BlockPos)pos, (BlockState)this.log.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)axis), box);
            pos.func_177972_a(Direction.DOWN);
            if (FallenLogFeature.func_214589_h((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                this.func_208520_a(blocks, (IWorldWriter)world, (BlockPos)pos, Blocks.field_150346_d.func_176223_P(), box);
            }
            pos.func_177972_a(Direction.UP);
        }
        return true;
    }
}

