/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse.world.feature;

import com.mojang.datafixers.Dynamic;
import epicsquid.traverse.blocks.ModBlocks;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FirTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private final int minHeight;
    private final BlockState log;
    private final BlockState leaves;

    public FirTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function, boolean worldGen) {
        this(function, worldGen, 15);
    }

    public FirTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function, boolean worldGen, int minHeight) {
        this(function, worldGen, minHeight, ModBlocks.FIR_LOG.func_176223_P(), ModBlocks.FIR_LEAVES.func_176223_P());
    }

    public FirTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function, boolean worldGen, int minHeight, BlockState log, BlockState leaves) {
        super(function, worldGen);
        this.minHeight = minHeight;
        this.log = log;
        this.leaves = leaves;
    }

    protected boolean func_208519_a(Set<BlockPos> blocks, IWorldGenerationReader world, Random random, BlockPos pos, MutableBoundingBox box) {
        int height = random.nextInt(15) + this.minHeight;
        int logHeight = 4 + random.nextInt(2);
        int leavesHeight = height - logHeight;
        int l = 2 + random.nextInt(2);
        boolean canGenerate = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int i1 = pos.func_177956_o(); i1 <= pos.func_177956_o() + 1 + height && canGenerate; ++i1) {
                int j1 = i1 - pos.func_177956_o() < logHeight ? 0 : l;
                BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
                for (int k1 = pos.func_177958_n() - j1; k1 <= pos.func_177958_n() + j1 && canGenerate; ++k1) {
                    for (int l1 = pos.func_177952_p() - j1; l1 <= pos.func_177952_p() + j1 && canGenerate; ++l1) {
                        if (i1 >= 0 && i1 < 256) {
                            if (FirTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)checkPos.func_181079_c(k1, i1, l1))) continue;
                            canGenerate = false;
                            continue;
                        }
                        canGenerate = false;
                    }
                }
            }
            if (!canGenerate) {
                return false;
            }
            if (FirTreeFeature.func_214589_h((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b()) && pos.func_177956_o() < 256 - height - 1) {
                this.setDirtAt(world, pos.func_177977_b(), pos);
                int i3 = random.nextInt(2);
                int j3 = 1;
                int k3 = 0;
                for (int l3 = 0; l3 <= leavesHeight; ++l3) {
                    int leavesY = pos.func_177956_o() + height - l3;
                    for (int leavesX = pos.func_177958_n() - i3; leavesX <= pos.func_177958_n() + i3; ++leavesX) {
                        int j2 = leavesX - pos.func_177958_n();
                        for (int leavesZ = pos.func_177952_p() - i3; leavesZ <= pos.func_177952_p() + i3; ++leavesZ) {
                            BlockPos leavesPos;
                            int l2 = leavesZ - pos.func_177952_p();
                            if (Math.abs(j2) == i3 && Math.abs(l2) == i3 && i3 > 0 || !FirTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)(leavesPos = new BlockPos(leavesX, leavesY, leavesZ)))) continue;
                            this.func_202278_a((IWorldWriter)world, leavesPos, this.leaves);
                        }
                    }
                    if (i3 >= j3) {
                        i3 = k3;
                        k3 = 1;
                        if (++j3 <= l) continue;
                        j3 = l;
                        continue;
                    }
                    ++i3;
                }
                int i4 = random.nextInt(3);
                for (int k4 = 0; k4 < height - i4; ++k4) {
                    if (!FirTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(k4)) && !FirTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(k4))) continue;
                    this.func_208520_a(blocks, (IWorldWriter)world, pos.func_177981_b(k4), this.log, box);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

