/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse.world.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BeachSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected int seaLevel;
    private DoubleFunction<BlockState> sand;
    protected final BlockState WATER = Blocks.field_150355_j.func_176223_P();

    public BeachSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> function, int seaLevel, DoubleFunction<BlockState> sand) {
        super(function);
        this.seaLevel = seaLevel;
        this.sand = sand;
    }

    public void buildSurface(Random rand, IChunk chunk, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int localX = x & 0xF;
        int localZ = z & 0xF;
        BlockState chosenSand = this.sand.apply(noise);
        int thickness = (int)(noise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int run = 0;
        boolean beach = false;
        boolean underwater = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(localX, 0, localZ);
        for (int y = startHeight; y >= 0; --y) {
            pos.func_181079_c(localX, y, localZ);
            BlockState chunkBlock = chunk.func_180495_p((BlockPos)pos);
            if (chunkBlock == field_215414_k && y < 255) {
                BlockState toSet = field_215414_k;
                if (chunk.func_180495_p(pos.func_177984_a()).func_196958_f()) {
                    beach = y < seaLevel + 3;
                    toSet = beach ? chosenSand : config.func_204108_a();
                } else if (chunk.func_180495_p(pos.func_177984_a()) == this.WATER || run < thickness && underwater) {
                    underwater = true;
                    if (y > seaLevel - 3) {
                        beach = true;
                        toSet = chosenSand;
                    } else {
                        toSet = config.func_204110_c();
                    }
                } else if (y > seaLevel - 3) {
                    if (beach) {
                        toSet = chosenSand;
                    } else if (run < thickness) {
                        toSet = config.func_204109_b();
                    }
                }
                chunk.func_177436_a((BlockPos)pos, toSet, false);
                ++run;
                continue;
            }
            run = 0;
            beach = false;
            underwater = false;
        }
    }
}

