/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class GeneralConfigHandler {
    public static Configuration config;
    public static boolean wellSlabs;
    public static boolean nameSign;
    public static boolean nameEntities;
    public static String headerTags;
    public static boolean villagerDropBook;
    public static boolean villagerSellsCodex;
    public static boolean recordStructureCoords;
    public static boolean addJobToName;
    public static String nitwitProfession;
    public static boolean addConcrete;
    public static boolean concreteWell;
    public static boolean enderSounds;
    public static boolean codexChestLoot;
    public static boolean versionChecker;
    public static boolean wellBoundary;
    public static boolean wellDecorations;
    public static boolean debugMessages;
    public static boolean nameGolems;
    public static String[] modNameMappingAutomatic;
    public static String[] modNameMappingClickable;
    public static String[] modProfessionMapping;
    public static int PMMerchantProfessionMap;
    public static int PMLostMinerProfessionMap;
    public static boolean TQVillageNames;
    public static String[] modStructureNames;
    public static boolean enableCartographer;
    public static boolean treasureTrades;
    public static boolean writtenBookTrade;
    public static boolean swampHutMushroomPot;
    public static String[] zombieCureCatalysts;
    public static String[] zombieCureGroups;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            GeneralConfigHandler.loadConfiguration();
        }
    }

    protected static void loadConfiguration() {
        nameSign = config.getBoolean("Name Sign", "general", true, "Villages display their name on a sign near the well. You can still discover the name by right-clicking a book onto a villager.");
        recordStructureCoords = config.getBoolean("Record Structure Coords", "general", true, "Books generated by villagers or the Codex record the structure's coordinates.");
        villagerDropBook = config.getBoolean("Villager drops book", "general", false, "Village books are dropped by the villager rather than going directly into your inventory.");
        villagerSellsCodex = config.getBoolean("Villager makes codex", "general", true, "Librarian villagers will give you a codex if you right-click them while holding emerald, iron ingots, and/or gold ingots.");
        wellBoundary = config.getBoolean("Well boundary", "general", true, "Whether to surround the well with colored blocks");
        wellSlabs = config.getBoolean("Well slabs", "general", true, "Replace the cobblestone rims of wells with stone slabs, making it easier for players and villagers to escape if they fall in.");
        wellDecorations = config.getBoolean("Allow well decorations", "Well Kill Switch", true, "Set this to false to disable all well decoration: sign, slabs, terracotta, concrete.");
        addConcrete = config.getBoolean("1.12 Blocks", "World of Color", true, "Whether to add 1.12 style Concrete, Concrete Powder, and Glazed Terracotta");
        concreteWell = config.getBoolean("Concrete Well", "World of Color", true, "Whether to decorate wells with Concrete and Glazed Terracotta instead of stained clay");
        enderSounds = config.getBoolean("Ender Eye", "Sounds", true, "Play the 1.12+ Ender Eye sound effects (This flag is handled SERVER-side only)");
        enableCartographer = config.getBoolean("Cartographer Villager", "villager professions", true, "Enable Cartographer career for Librarian villager. The higher-level trades will be Village Names trades instead of treasure maps. Ordinary Librarians will get high-level treasure trades, too.");
        treasureTrades = config.getBoolean("Treasure Trades", "villager professions", true, "High-level Librarians and Cartographers will offer enchanted books and treasures in exchange for Village Names items.");
        writtenBookTrade = config.getBoolean("Written Book Trade", "villager professions", true, "Change the vanilla Librarian trade to require a single written book instead of two identical written books");
        zombieCureCatalysts = config.getStringList("Zombie Cure Catalysts", "villager professions", new String[]{"vanilla|net.minecraft.block.BlockBed|tile.bed|-1", "vanilla|net.minecraft.block.BlockPane|tile.fenceIron|-1"}, "When performing the ritual to convert a zombie villager into a villager, having these blocks nearby (within a taxicab distance of 4) will speed up the process. Format is: group|classPath|unlocName|meta\ngroup is an arbitrary group name to which the block belongs, referenced in Zombie Cure Groups below.\nclassPath is the mod's address to the entity class.\nunlocName is the unlocalized name of the block. This is used as an extra discriminator in case class path and meta aren't enough. You can leave this blank to ignore it.\nmeta is integer meta value of the block. Enter -1 to ignore meta and count all blocks with that class path.");
        zombieCureGroups = config.getStringList("Zombie Cure Groups", "villager professions", new String[]{"vanilla|0.3|14"}, "When curing a zombie villager, all blocks of the same named group will use these stats. Format is: group|speedup|limit\ngroup is the group name assigned in Zombie Cure Catalysts above.\nspeedup is the per-block percentage point boost in conversion speed. That is: a value of 1.0 increases the conversion by about 1 percentage point per group block found. negative values will likewise reduce the conversion speed, making conversion take longer.\nlimit is the maximum number of blocks in this group that will apply the group speedup effect.");
        versionChecker = config.getBoolean("Version Checker", "miscellaneous", true, "Displays a client-side chat message if there's an update available.");
        codexChestLoot = config.getBoolean("Codex Chest Loot", "miscellaneous", true, "The Codex can appear as rare chest loot.");
        debugMessages = config.getBoolean("Debug messages", "miscellaneous", false, "Print debug messages to the console, print the class paths of entities and blocks you right-click.");
        swampHutMushroomPot = config.getBoolean("Swamp Hut Mushroom", "miscellaneous", true, "1.8+ has a bug where the clay pot in the Witch's swamp hut is empty. This flag will correctly place a red mushroom in the pot.");
        nameEntities = config.getBoolean("Entity names", "Entity Names", true, "Entities reveal their names when you right-click them, or automatically if so assigned.");
        addJobToName = config.getBoolean("Entity professions", "Entity Names", false, "An entity's name also includes its profession/title. You may need to right-click the entity to update its name plate.");
        nameGolems = config.getBoolean("Golem names", "Entity Names", true, "Right-click village Golems to learn their name.");
        nitwitProfession = config.getString("Nitwit Profession", "Entity Names", "", "The career displayed for a Nitwit");
        modNameMappingAutomatic = config.getStringList("Automatic Names", "Entity Names", new String[]{"villager-goblin|Witch|net.minecraft.entity.monster.EntityWitch|add", "alien-golem|Elder Guardian|net.minecraft.entity.monster.EntityElderGuardian|add", "alien-demon|Evolved Skeleton Boss|micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss|add", "alien-golem|Evolved Creeper Boss|micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss|add", "alien-goblin||micdoodle8.mods.galacticraft.planets.venus.entities.EntitySpiderQueen|add", "alien-goblin|Evolved Witch|stevekung.mods.moreplanets.core.entities.EntityEvolvedWitch|add", "alien-golem|Diona Creeper Boss|stevekung.mods.moreplanets.planets.diona.entities.EntityDionaCreeperBoss|add", "alien-golem|Fronos Creeper Boss|stevekung.mods.moreplanets.planets.fronos.entities.EntityFronosCreeperBossTemp|add", "alien-golem|Kapteyn B Creeper Boss|stevekung.mods.moreplanets.planets.kapteynb.entities.EntityKapteynBCreeperBoss|add", "alien-goblin|Evolved Infected Spider Boss|stevekung.mods.moreplanets.planets.nibiru.entities.EntityEvolvedInfectedSpiderBoss|add", "alien-golem|Pluto Creeper Boss|stevekung.mods.moreplanets.planets.pluto.entities.EntityPlutoCreeperBoss|add", "alien-angel|Cheese Cube Boss|stevekung.mods.moreplanets.planets.polongnius.entities.EntityCheeseCubeEyeBoss|add", "alien-demon-golem|Evolved Sirius Blaze Boss|stevekung.mods.moreplanets.planets.siriusb.entities.EntityEvolvedSiriusBlazeBoss|add", "alien-demon|Infected Crystallized Slime Boss|stevekung.mods.moreplanets.module.planets.diona.entity.EntityInfectedCrystallizeSlimeBoss|add", "alien-angel|Cheese Cube Boss|stevekung.mods.moreplanets.module.planets.chalos.entity.EntityCheeseCubeEyeBoss|add", "alien-demon-angel|Evolved Boss Ghast|galaxyspace.galaxies.milkyway.SolarSystem.moons.io.entities.EntityBossGhast|add", "alien-demon-golem|Evolved Boss Blaze|galaxyspace.galaxies.milkyway.SolarSystem.planets.ceres.entities.EntityBossBlaze|add", "villager|Summoner|net.daveyx0.primitivemobs.entity.monster.EntityDSummoner|add", "villager-golem||twilightforest.entity.EntityTFArmoredGiant|add", "villager-golem||twilightforest.entity.EntityTFGiantMiner|add", "dragon|Naga|twilightforest.entity.boss.EntityTFNaga|add", "dragon|Hydra|twilightforest.entity.boss.EntityTFHydra|add", "demon-golem|Knight Phantom|twilightforest.entity.boss.EntityTFKnightPhantom|add", "demon|Twilight Lich|twilightforest.entity.boss.EntityTFLich|add", "goblin|Minoshroom|twilightforest.entity.boss.EntityTFMinoshroom|add", "angel|Snow Queen|twilightforest.entity.boss.EntityTFSnowQueen|add", "demon-angel|Ur-ghast|twilightforest.entity.boss.EntityTFUrGhast|add", "goblin-golem|Alpha Yeti|twilightforest.entity.boss.EntityTFYetiAlpha|add", "villager-demon||com.emoniph.witchery.entity.EntityVampire|add", "villager|Witch Hunter|com.emoniph.witchery.entity.EntityWitchHunter|add", "demon|Horned Huntsman|com.emoniph.witchery.entity.EntityHornedHuntsman|add", "demon|Lord of Torment|com.emoniph.witchery.entity.EntityLordOfTorment|add"}, "List of entities that will generate a name automatically when they appear. Useful for aggressive or boss mobs.\nFormat is: nameType|profession|classPath|addOrRemove\nnameType is the name pool for the entity, or a hyphenated series of pools like \"angel-golem\".\nprofession is displayed if that config flag is enabled. It can be left blank for no profession.\nclassPath is the mod's address to the entity class.\nnameType options:\nvillager, dragon, golem, alien, angel, demon, goblin, custom\naddOrRemove - type \"add\" to automatically add names tags to ALL COPIES of this entity upon spawning, or \"remove\" to automatically remove.\nBe VERY CAUTIOUS about what entities you choose to add to this list!");
        modNameMappingClickable = config.getStringList("Clickable Names", "Entity Names", new String[]{"alien||micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager", "alien||stevekung.mods.moreplanets.moons.koentus.entities.EntityKoentusianVillager", "alien||stevekung.mods.moreplanets.module.moons.koentus.entities.EntityKoentusianVillager", "alien-villager-goblin||stevekung.mods.moreplanets.planets.fronos.entities.EntityFronosVillager", "alien-villager-goblin||stevekung.mods.moreplanets.module.planets.fronos.entities.EntityFronosVillager", "alien-villager-angel||stevekung.mods.moreplanets.planets.nibiru.entity.EntityNibiruVillager", "alien-villager-angel||stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityNibiruVillager", "goblin-demon||mods.natura.entity.ImpEntity", "goblin||thaumcraft.common.entities.monster.EntityPech", "villager|Sentry|net.torocraft.toroquest.entities.EntitySentry", "villager|Guard|net.torocraft.toroquest.entities.EntityGuard", "villager|Lord|net.torocraft.toroquest.entities.EntityVillageLord", "angel-goblin|Questing Ram|twilightforest.entity.passive.EntityTFQuestRam", "villager|Guard|com.emoniph.witchery.entity.EntityVillageGuard", "goblin||com.emoniph.witchery.entity.EntityGoblin", "goblin-demon||com.emoniph.witchery.entity.EntityImp", "demon||com.emoniph.witchery.entity.EntityDemon", "villager|Traveling Merchant|net.daveyx0.primitivemobs.entity.passive.EntityTravelingMerchant", "villager|Miner|net.daveyx0.primitivemobs.entity.passive.EntityLostMiner", "villager||net.daveyx0.primitivemobs.entity.passive.EntitySheepman", "villager|Blacksmith|net.daveyx0.primitivemobs.entity.passive.EntitySheepmanSmith", "villager-goblin||nex.entity.passive.EntityPigtificate", "villager-goblin|Chief|nex.entity.passive.EntityPigtificateLeader", "villager-goblin||imc.common.EntityPigman"}, "List of entities that can generate a name when right-clicked. Format is: nameType|profession|classPath\nnameType is the name pool for the entity, or a hyphenated series of pools like \"angel-golem\".\nprofession is displayed if that config flag is enabled. It can be left blank for no profession.\nclassPath is mod's address to the entity class.\nnameType options:\nvillager, dragon, golem, alien, angel, demon, goblin, custom\n");
        modStructureNames = config.getStringList("Mod Structures", "Mod Naming", new String[]{"alienvillage|MoonVillage|Moon Village|Moon|moonvillage|micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager", "alienvillage|GC_AbandonedBase|Abandoned Base|Asteroid Belt|abandonedbase|", "alienvillage|FronosVillage|Fronos Village|Fronos|fronosvillage|stevekung.mods.moreplanets.planets.fronos.entities.EntityFronosVillager", "alienvillage|FronosVillage|Fronos Village|Fronos|fronosvillage|stevekung.mods.moreplanets.module.planets.fronos.entities.EntityFronosVillager", "alienvillage|KoentusVillage|Koentus Village|Koentus|koentusvillage|stevekung.mods.moreplanets.moons.koentus.entities.EntityKoentusianVillager", "alienvillage|KoentusVillage|Koentus Village|Koentus|koentusvillage|stevekung.mods.moreplanets.module.moons.koentus.entities.EntityKoentusianVillager", "alienvillage|NibiruVillage|Nibiru Village|The Nether|nibiruvillage|stevekung.mods.moreplanets.planets.nibiru.entity.EntityNibiruVillager", "alienvillage|NibiruVillage|Nibiru Village|The Nether|nibiruvillage|stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityNibiruVillager", "endcity|hardcoreenderdragon_EndTower|Dungeon Tower|The End|endcity|", "endcity|hardcoreenderdragon_EndIsland|Laboratory|The End|endcity|"}, "List of mod structures that can be named with a Codex, or by right-clicking an entity in that structure (optional).Structures must have been generated in a manner similarly to vanilla (e.g. Galacticraft Moon Villages).\nFormat is: nameType|structureType|structureTitle|dimensionName|bookType|entityClassPath\nnameType is your choice of name pool for the structure. Options: village, mineshaft, temple, stronghold, fortress, monument, endcity, mansion, alienvillage\nstructureType how the mod saves the structure info--e.g. dimension/data/[structureType].dat\nstructureTitle is the string type of the structure (e.g. \"Moon Village\"), which will be recorded into a book. It can be left blank.\ndimensionName is the name of the dimension that would be recorded into the book. It can be left blank.\nbookType is the kind of book that is generated. Options: village, mineshaft, temple, jungletemple, desertpyramid, swamphut, igloo, stronghold, fortress, monument, endcity, mansion, moonvillage, koentusvillage, fronosvillage, nibiruvillage, abandonedbase\nentityClassPath is the mod's address to the entity class that will generate this book (when inside the structure). It can be left blank, wherein the structure name can only be obtained via a Codex.\n");
        modProfessionMapping = config.getStringList("Mod Professions", "Mod Naming", new String[]{"Brewer|10|0", "Apiarist|14|4", "Swordsmith|66|5", "Wizard|190|2", "Banker|191|0", "Archaeologist|303|2", "Engineer|456|3", "Apothecary|2435|2", "Music Merchant|6156|5", "Tinkerer|78943|5", "Enchanter|935153|2", "Archivist|1210950779|1"}, "List of professions for other mods' villagers. Format is: Name|ID|pageType\nName is your choice of name for the profession.\nID is the ID associated with the mod profession.\npageType is the vanilla archetype the villager emulates in order to generate hint pages.\nUse this reference:\n-1=None\n0=Farmer\n1=Librarian\n2=Priest\n3=Blacksmith\n4=Butcher\n5=Nitwit\n");
        PMMerchantProfessionMap = config.getInt("PM Traveling Merchant Profession ID", "Mod Naming", 0, 0, 5, "Which vanilla archetype the traveling merchant emulates in order to generate hint pages.\nUse this reference:\n-1=None\n0=Farmer\n1=Librarian\n2=Priest\n3=Blacksmith\n4=Butcher\n5=Nitwit\n");
        PMLostMinerProfessionMap = config.getInt("PM Lost Miner Profession ID", "Mod Naming", 3, 0, 5, "Which vanilla archetype the traveling merchant emulates in order to generate hint pages.\nUse this reference:\n-1=None\n0=Farmer\n1=Librarian\n2=Priest\n3=Blacksmith\n4=Butcher\n5=Nitwit\n");
        TQVillageNames = config.getBoolean("ToroQuest Village Names", "Mod Naming", true, "If you're using ToroQuest, write its town names into village books. Additionally, Village Names well signs will not generate, since they do so before ToroQuest assigns a town name.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Map<String, ArrayList> unpackMappedProfessions(String[] inputList) {
        ArrayList<String> otherModProfessions = new ArrayList<String>();
        ArrayList<Integer> otherModIDs = new ArrayList<Integer>();
        ArrayList<Integer> vanillaProfMaps = new ArrayList<Integer>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String otherModProfession = "";
            int otherModID = -1;
            int vanillaProfMap = -1;
            try {
                otherModProfession = splitEntry[0].trim();
            }
            catch (Exception e) {
                otherModProfession = "";
            }
            try {
                otherModID = Integer.parseInt(splitEntry[1].trim());
            }
            catch (Exception e) {
                otherModID = -1;
            }
            try {
                vanillaProfMap = Integer.parseInt(splitEntry[2].trim());
            }
            catch (Exception e) {
                vanillaProfMap = -1;
            }
            if (otherModProfession.equals("") || otherModID == -1) continue;
            otherModProfessions.add(otherModProfession);
            otherModIDs.add(otherModID);
            vanillaProfMaps.add(vanillaProfMap);
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.put("Professions", otherModProfessions);
        map.put("IDs", otherModIDs);
        map.put("VanillaProfMaps", vanillaProfMaps);
        return map;
    }

    public static Map<String, ArrayList> unpackModStructures(String[] inputList) {
        ArrayList<String> otherModNameTypes = new ArrayList<String>();
        ArrayList<String> otherModStructureTypes = new ArrayList<String>();
        ArrayList<String> otherModStructureTitles = new ArrayList<String>();
        ArrayList<String> otherModDimensionNames = new ArrayList<String>();
        ArrayList<String> otherModBookTypes = new ArrayList<String>();
        ArrayList<String> otherModClassPaths = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String otherModNameType = "";
            String otherModStructureType = "FAILSAFE";
            String otherModStructureTitle = "";
            String otherModDimensionName = "";
            String otherModBookType = "";
            String otherModClassPath = "";
            try {
                otherModNameType = splitEntry[0].trim();
            }
            catch (Exception e) {
                otherModNameType = "";
            }
            try {
                otherModStructureType = splitEntry[1].trim();
            }
            catch (Exception e) {
                otherModStructureType = "FAILSAFE";
            }
            try {
                otherModStructureTitle = splitEntry[2].trim();
            }
            catch (Exception e) {
                otherModStructureTitle = "";
            }
            try {
                otherModDimensionName = splitEntry[3].trim();
            }
            catch (Exception e) {
                otherModDimensionName = "";
            }
            try {
                otherModBookType = splitEntry[4].trim();
            }
            catch (Exception e) {
                otherModBookType = "";
            }
            try {
                otherModClassPath = splitEntry[5].trim();
            }
            catch (Exception e) {
                otherModClassPath = "";
            }
            if (otherModNameType.equals("") || otherModStructureType.equals("") || otherModBookType.equals("")) continue;
            otherModNameTypes.add(otherModNameType);
            otherModStructureTypes.add(otherModStructureType);
            otherModStructureTitles.add(otherModStructureTitle);
            otherModDimensionNames.add(otherModDimensionName);
            otherModBookTypes.add(otherModBookType);
            otherModClassPaths.add(otherModClassPath);
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.put("NameTypes", otherModNameTypes);
        map.put("StructureTypes", otherModStructureTypes);
        map.put("StructureTitles", otherModStructureTitles);
        map.put("DimensionNames", otherModDimensionNames);
        map.put("BookTypes", otherModBookTypes);
        map.put("ClassPaths", otherModClassPaths);
        return map;
    }

    public static Map<String, ArrayList> unpackMappedNames(String[] inputList) {
        ArrayList<String> otherModNameTypes = new ArrayList<String>();
        ArrayList<String> otherModProfessions = new ArrayList<String>();
        ArrayList<String> otherModClassPaths = new ArrayList<String>();
        ArrayList<String> addOrRemoveA = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String otherModNameType = "";
            String otherModProfession = "";
            String otherModClassPath = "";
            String addOrRemove = "";
            try {
                otherModNameType = splitEntry[0].trim();
            }
            catch (Exception e) {
                otherModNameType = "";
            }
            try {
                otherModProfession = splitEntry[1].trim();
            }
            catch (Exception e) {
                otherModProfession = "";
            }
            try {
                otherModClassPath = splitEntry[2].trim();
            }
            catch (Exception e) {
                otherModClassPath = "";
            }
            try {
                addOrRemove = splitEntry[3].trim();
            }
            catch (Exception e) {
                addOrRemove = "";
            }
            if (otherModClassPath.equals("") || otherModNameType.equals("")) continue;
            otherModClassPaths.add(otherModClassPath);
            otherModNameTypes.add(otherModNameType);
            otherModProfessions.add(otherModProfession);
            addOrRemoveA.add(addOrRemove);
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.put("NameTypes", otherModNameTypes);
        map.put("Professions", otherModProfessions);
        map.put("ClassPaths", otherModClassPaths);
        map.put("AddOrRemove", addOrRemoveA);
        return map;
    }

    public static Map<String, ArrayList> unpackZombieCureCatalysts(String[] inputList) {
        ArrayList<String> zombieCureCatalystGroups = new ArrayList<String>();
        ArrayList<String> zombieCureCatalystClassPaths = new ArrayList<String>();
        ArrayList<String> zombieCureCatalystUnlocNames = new ArrayList<String>();
        ArrayList<Integer> zombieCureCatalystMetas = new ArrayList<Integer>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String zombieCureCatalystGroup = "";
            String zombieCureCatalystClassPath = "";
            String zombieCureCatalystUnlocName = "";
            int zombieCureCatalystMeta = -1;
            try {
                zombieCureCatalystGroup = splitEntry[0].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureCatalystClassPath = splitEntry[1].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureCatalystUnlocName = splitEntry[2].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureCatalystMeta = Integer.parseInt(splitEntry[3].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zombieCureCatalystGroup.equals("") || zombieCureCatalystClassPath.equals("")) continue;
            zombieCureCatalystGroups.add(zombieCureCatalystGroup);
            zombieCureCatalystClassPaths.add(zombieCureCatalystClassPath);
            zombieCureCatalystUnlocNames.add(zombieCureCatalystUnlocName);
            zombieCureCatalystMetas.add(zombieCureCatalystMeta);
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.put("Groups", zombieCureCatalystGroups);
        map.put("ClassPaths", zombieCureCatalystClassPaths);
        map.put("UnlocNames", zombieCureCatalystUnlocNames);
        map.put("Metas", zombieCureCatalystMetas);
        return map;
    }

    public static Map<String, ArrayList> unpackZombieCureGroups(String[] inputList) {
        ArrayList<String> zombieCureGroupGroups = new ArrayList<String>();
        ArrayList<Double> zombieCureGroupSpeedups = new ArrayList<Double>();
        ArrayList<Integer> zombieCureGroupLimits = new ArrayList<Integer>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String zombieCureGroupGroup = "";
            double zombieCureGroupSpeedup = 0.0;
            int zombieCureGroupLimit = -1;
            try {
                zombieCureGroupGroup = splitEntry[0].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureGroupSpeedup = Double.parseDouble(splitEntry[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zombieCureGroupLimit = Integer.parseInt(splitEntry[2].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zombieCureGroupGroup.equals("")) continue;
            zombieCureGroupGroups.add(zombieCureGroupGroup);
            zombieCureGroupSpeedups.add(zombieCureGroupSpeedup);
            zombieCureGroupLimits.add(zombieCureGroupLimit);
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.put("Groups", zombieCureGroupGroups);
        map.put("Speedups", zombieCureGroupSpeedups);
        map.put("Limits", zombieCureGroupLimits);
        return map;
    }

    static {
        headerTags = "\u00a78\u00a7o";
    }
}

