/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.handler.AchievementReward;
import astrotibs.villagenames.handler.EntityInteractHandler;
import astrotibs.villagenames.item.ModItems;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.nbt.VNWorldDataStructure;
import astrotibs.villagenames.structure.StructureRegistry;
import astrotibs.villagenames.utility.LogHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;

public class WriteBookHandler {
    public static void targetWriteNewVillageBook(String bookType, String author, int locX, int locY, int locZ, String structureName, String dimensionName, String namePrefix, String nameRoot, String nameSuffix, boolean playerIsInVillage, Village villageYouAreIn, PlayerInteractEvent.EntityInteract event, int targetProfession, int targetCareer, String targetPName, int targetTradeCount, int playerRep, EntityPlayer player, EntityLiving target) {
        String structureHintPageText;
        int population = -1;
        int radius = -1;
        try {
            population = villageYouAreIn.func_75562_e();
            radius = villageYouAreIn.func_75568_b();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String targetClassPath = "";
        if (target != null) {
            targetClassPath = target.getClass().toString().substring(6);
        }
        String bookContents = "{\"text\":\"";
        bookContents = bookContents + "\n\u00a7r\u00a70";
        bookContents = bookContents + (structureName.equals("") ? "" : structureName + ":\n");
        bookContents = bookContents + "\u00a7l";
        if ((namePrefix + " " + nameRoot + " " + nameSuffix).trim().length() <= 15) {
            bookContents = bookContents + (namePrefix + " " + nameRoot + " " + nameSuffix).trim();
        } else if ((namePrefix + " " + nameRoot).trim().length() <= 15) {
            bookContents = bookContents + (namePrefix + " " + nameRoot).trim();
            bookContents = bookContents + "\n\u00a7l" + nameSuffix;
        } else {
            bookContents = bookContents + namePrefix.trim();
            if ((nameRoot + " " + nameSuffix).trim().length() <= 15) {
                bookContents = bookContents + "\n\u00a7l" + (nameRoot + " " + nameSuffix).trim();
            } else {
                bookContents = bookContents + "\n\u00a7l" + nameRoot.trim();
                bookContents = bookContents + "\n\u00a7l" + nameSuffix.trim();
            }
        }
        if (GeneralConfigHandler.recordStructureCoords) {
            bookContents = bookContents + "\n\n\u00a7rLocated at:\n\u00a7rx = \u00a7l" + locX + "\u00a7r\ny = \u00a7l" + locY + "\u00a7r\nz = \u00a7l" + locZ + "\u00a7r";
        }
        bookContents = bookContents + (dimensionName.equals("") ? "\u00a7r" : "\n\u00a7r(" + dimensionName + ")");
        bookContents = bookContents + "\n";
        if (!(population <= -1 || Loader.isModLoaded((String)"toroquest") && GeneralConfigHandler.TQVillageNames)) {
            bookContents = bookContents + "\n\u00a7rPopulation: \u00a7l" + population;
        }
        if (radius > 0) {
            bookContents = bookContents + "\n\u00a7rRadius: \u00a7l" + radius;
        }
        bookContents = bookContents + "\"}";
        ItemStack book = bookType.toLowerCase().trim().equals("mineshaft") ? new ItemStack((Item)ModItems.MINESHAFT_BOOK) : (bookType.toLowerCase().trim().equals("temple") ? new ItemStack((Item)ModItems.TEMPLE_BOOK) : (bookType.toLowerCase().trim().equals("monument") ? new ItemStack((Item)ModItems.MONUMENT_BOOK) : (bookType.toLowerCase().trim().equals("fortress") ? new ItemStack((Item)ModItems.FORTRESS_BOOK) : (bookType.toLowerCase().trim().equals("stronghold") ? new ItemStack((Item)ModItems.STRONGHOLD_BOOK) : (bookType.toLowerCase().trim().equals("endcity") ? new ItemStack((Item)ModItems.END_CITY_BOOK) : (bookType.toLowerCase().trim().equals("mansion") ? new ItemStack((Item)ModItems.MANSION_BOOK) : (bookType.toLowerCase().trim().equals("moonvillage") ? new ItemStack((Item)ModItems.MOON_VILLAGE_BOOK) : (bookType.toLowerCase().trim().equals("fronosvillage") ? new ItemStack((Item)ModItems.FRONOS_VILLAGE_BOOK) : (bookType.toLowerCase().trim().equals("koentusvillage") ? new ItemStack((Item)ModItems.KOENTUS_VILLAGE_BOOK) : (bookType.toLowerCase().trim().equals("nibiruvillage") ? new ItemStack((Item)ModItems.NIBIRU_VILLAGE_BOOK) : (bookType.toLowerCase().trim().equals("abandonedbase") ? new ItemStack((Item)ModItems.ABANDONED_BASE_BOOK) : (bookType.toLowerCase().trim().equals("jungletemple") ? new ItemStack((Item)ModItems.JUNGLE_TEMPLE_BOOK) : (bookType.toLowerCase().trim().equals("desertpyramid") ? new ItemStack((Item)ModItems.DESERT_PYRAMID_BOOK) : (bookType.toLowerCase().trim().equals("swamphut") ? new ItemStack((Item)ModItems.SWAMP_HUT_BOOK) : (bookType.toLowerCase().trim().equals("igloo") ? new ItemStack((Item)ModItems.IGLOO_BOOK) : new ItemStack((Item)ModItems.VILLAGE_BOOK))))))))))))))));
        ArrayList pages = new ArrayList();
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        book.func_77978_p().func_74778_a("title", (namePrefix + " " + nameRoot + " " + nameSuffix).trim());
        if (author != null && !author.equals("")) {
            try {
                book.func_77978_p().func_74778_a("author", author.indexOf("(") != -1 ? author.substring(0, author.indexOf("(")).trim() : author);
            }
            catch (Exception exception) {}
        } else {
            book.func_77978_p().func_74778_a("author", "");
        }
        NBTTagList pagesTag = new NBTTagList();
        pagesTag.func_74742_a((NBTBase)new NBTTagString(bookContents));
        if (target != null && (target instanceof EntityVillager || target.getClass().toString().substring(6).equals("net.daveyx0.primitivemobs.entity.passive.EntityLostMiner") || target.getClass().toString().substring(6).equals("net.daveyx0.primitivemobs.entity.passive.EntityTravelingMerchant")) && (author != "" && author != null || !GeneralConfigHandler.nameEntities) && !(structureHintPageText = WriteBookHandler.makeSecondPage(event, targetClassPath, villageYouAreIn, locX, locY, locZ, playerRep, targetProfession, targetCareer, targetPName, targetTradeCount)).equals("")) {
            pagesTag.func_74742_a((NBTBase)new NBTTagString(structureHintPageText));
        }
        book.func_77978_p().func_74782_a("pages", (NBTBase)pagesTag);
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_174925_a(Items.field_151122_aG, -1, 1, null);
        }
        EntityItem eitem = (GeneralConfigHandler.villagerDropBook && target != null ? target : player).func_70099_a(book, 1.0f);
        eitem.func_174868_q();
        if (target == null && targetProfession == -6 && targetCareer == -27 && targetTradeCount == -8 && playerRep == -16 && !player.field_70170_p.field_72995_K && (population == 0 || playerIsInVillage && population == -1)) {
            try {
                if (!((EntityPlayerMP)player).func_147099_x().func_77443_a(VillageNames.ghosttown)) {
                    player.func_71029_a((StatBase)VillageNames.ghosttown);
                    AchievementReward.allFiveAchievements((EntityPlayerMP)player);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void codexWriteNewVillageBook(String bookType, String author, int locX, int locY, int locZ, String structureName, String dimensionName, String namePrefix, String nameRoot, String nameSuffix, EntityPlayer player, Village villagePlayerIsIn, boolean playerIsInVillage) {
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_174925_a((Item)ModItems.CODEX, -1, 1, null);
        }
        WriteBookHandler.targetWriteNewVillageBook(bookType, author, locX, locY, locZ, structureName, dimensionName, namePrefix, nameRoot, nameSuffix, playerIsInVillage, villagePlayerIsIn, null, -6, -27, "codexDummy", -8, -16, player, null);
    }

    public static String makeSecondPage(PlayerInteractEvent.EntityInteract event, String targetClassPath, Village villageNearVillager, double targetX, double targetY, double targetZ, int playerRep, int villagerProfession, int villagerCareer, String targetPName, int villagerTradeCount) {
        int villagerMappedProfession;
        int[] closestCoords;
        String closestStructure;
        double[] villageCoords;
        double mansionDistSq;
        double monumentDistSq;
        double villageDistSq;
        double templeDistSq;
        double strongholdDistSq;
        double mineshaftDistSq;
        int radius;
        int[] nearestMansionXYZ;
        int[] nearestMonumentXYZ;
        int[] nearestVillageXYZ;
        int[] nearestTempleXYZ;
        int[] nearestStrongholdXYZ;
        int[] nearestMineshaftXYZ;
        double maxStructureDistance;
        double nitwitRadius;
        double strongholdCoefSquared;
        block30: {
            double dz;
            double dy;
            double dx;
            double radiusCoef = 64.0;
            strongholdCoefSquared = 0.5;
            double nitwitCoef = 2.5;
            nitwitRadius = (double)playerRep * radiusCoef * nitwitCoef;
            String structureFeature = "";
            maxStructureDistance = (double)playerRep * Math.sqrt(villagerTradeCount + 1) * radiusCoef;
            nearestMineshaftXYZ = WriteBookHandler.nearestStructureLoc("Mineshaft", event);
            nearestStrongholdXYZ = WriteBookHandler.nearestStructureLoc("Stronghold", event);
            nearestTempleXYZ = WriteBookHandler.nearestStructureLoc("Temple", event);
            nearestVillageXYZ = new int[3];
            nearestMonumentXYZ = WriteBookHandler.nearestStructureLoc("Monument", event);
            nearestMansionXYZ = WriteBookHandler.nearestStructureLoc("Mansion", event);
            List vlist = event.getEntityPlayer().field_70170_p.field_72982_D.func_75540_b();
            Map<String, ArrayList> mappedProfessions = GeneralConfigHandler.unpackMappedProfessions(GeneralConfigHandler.modProfessionMapping);
            double vmaxr = Double.MAX_VALUE;
            radius = villageNearVillager.func_75568_b();
            Iterator vitr = vlist.iterator();
            double rsq = Double.MAX_VALUE;
            double rsq2 = Double.MAX_VALUE;
            while (vitr.hasNext()) {
                Village element = (Village)vitr.next();
                int vx = element.func_180608_a().func_177958_n();
                int vy = element.func_180608_a().func_177956_o();
                int vz = element.func_180608_a().func_177952_p();
                dx = vx - villageNearVillager.func_180608_a().func_177958_n();
                rsq = dx * dx + (dy = (double)(vy - villageNearVillager.func_180608_a().func_177956_o())) * dy + (dz = (double)(vz - villageNearVillager.func_180608_a().func_177952_p())) * dz;
                if (!(rsq < vmaxr) || !(rsq >= (double)((radius + EntityInteractHandler.villageRadiusBuffer) * (radius + EntityInteractHandler.villageRadiusBuffer)))) continue;
                vmaxr = rsq;
                nearestVillageXYZ[0] = vx;
                nearestVillageXYZ[1] = vy;
                nearestVillageXYZ[2] = vz;
            }
            MapGenStructureData structureData = (MapGenStructureData)event.getEntityPlayer().field_70170_p.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
            NBTTagCompound nbttagcompound = structureData.func_143041_a();
            for (Object element : nbttagcompound.func_150296_c()) {
                NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                if (nbtbase.func_74732_a() != 10) continue;
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                try {
                    int[] boundingBox = nbttagcompound2.func_74759_k("BB");
                    int vx = villageNearVillager.func_180608_a().func_177958_n();
                    int vy = villageNearVillager.func_180608_a().func_177956_o();
                    int vz = villageNearVillager.func_180608_a().func_177952_p();
                    if (!nbttagcompound2.func_74767_n("Valid") || vx >= boundingBox[0] && vy >= boundingBox[1] && vz >= boundingBox[2] && vx <= boundingBox[3] && vy <= boundingBox[4] && vz <= boundingBox[5] || !((rsq2 = (dx = (double)((boundingBox[0] + boundingBox[3]) / 2 - vx)) * dx + (dy = (double)((boundingBox[1] + boundingBox[4]) / 2 - vy)) * dy + (dz = (double)((boundingBox[2] + boundingBox[5]) / 2 - vz)) * dz) < vmaxr)) continue;
                    vmaxr = rsq2;
                    nearestVillageXYZ[0] = (boundingBox[0] + boundingBox[3]) / 2;
                    nearestVillageXYZ[1] = (boundingBox[1] + boundingBox[4]) / 2;
                    nearestVillageXYZ[2] = (boundingBox[2] + boundingBox[5]) / 2;
                }
                catch (Exception exception) {}
            }
            mineshaftDistSq = nearestMineshaftXYZ[0] == 0 && nearestMineshaftXYZ[1] == 0 && nearestMineshaftXYZ[2] == 0 ? Double.MAX_VALUE : ((double)nearestMineshaftXYZ[0] - targetX) * ((double)nearestMineshaftXYZ[0] - targetX) + ((double)nearestMineshaftXYZ[1] - targetY) * ((double)nearestMineshaftXYZ[1] - targetY) + ((double)nearestMineshaftXYZ[2] - targetZ) * ((double)nearestMineshaftXYZ[2] - targetZ);
            strongholdDistSq = nearestStrongholdXYZ[0] == 0 && nearestStrongholdXYZ[1] == 0 && nearestStrongholdXYZ[2] == 0 ? Double.MAX_VALUE : ((double)nearestStrongholdXYZ[0] - targetX) * ((double)nearestStrongholdXYZ[0] - targetX) + ((double)nearestStrongholdXYZ[1] - targetY) * ((double)nearestStrongholdXYZ[1] - targetY) + ((double)nearestStrongholdXYZ[2] - targetZ) * ((double)nearestStrongholdXYZ[2] - targetZ);
            templeDistSq = nearestTempleXYZ[0] == 0 && nearestTempleXYZ[1] == 0 && nearestTempleXYZ[2] == 0 ? Double.MAX_VALUE : ((double)nearestTempleXYZ[0] - targetX) * ((double)nearestTempleXYZ[0] - targetX) + ((double)nearestTempleXYZ[1] - targetY) * ((double)nearestTempleXYZ[1] - targetY) + ((double)nearestTempleXYZ[2] - targetZ) * ((double)nearestTempleXYZ[2] - targetZ);
            villageDistSq = nearestVillageXYZ[0] == 0 && nearestVillageXYZ[1] == 0 && nearestVillageXYZ[2] == 0 ? Double.MAX_VALUE : ((double)nearestVillageXYZ[0] - targetX) * ((double)nearestVillageXYZ[0] - targetX) + ((double)nearestVillageXYZ[1] - targetY) * ((double)nearestVillageXYZ[1] - targetY) + ((double)nearestVillageXYZ[2] - targetZ) * ((double)nearestVillageXYZ[2] - targetZ);
            monumentDistSq = nearestMonumentXYZ[0] == 0 && nearestMonumentXYZ[1] == 0 && nearestMonumentXYZ[2] == 0 ? Double.MAX_VALUE : ((double)nearestMonumentXYZ[0] - targetX) * ((double)nearestMonumentXYZ[0] - targetX) + ((double)nearestMonumentXYZ[1] - targetY) * ((double)nearestMonumentXYZ[1] - targetY) + ((double)nearestMonumentXYZ[2] - targetZ) * ((double)nearestMonumentXYZ[2] - targetZ);
            mansionDistSq = nearestMansionXYZ[0] == 0 && nearestMansionXYZ[1] == 0 && nearestMansionXYZ[2] == 0 ? Double.MAX_VALUE : ((double)nearestMansionXYZ[0] - targetX) * ((double)nearestMansionXYZ[0] - targetX) + ((double)nearestMansionXYZ[1] - targetY) * ((double)nearestMansionXYZ[1] - targetY) + ((double)nearestMansionXYZ[2] - targetZ) * ((double)nearestMansionXYZ[2] - targetZ);
            double[] villagerCoords = new double[]{event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v};
            villageCoords = new double[]{villageNearVillager.func_180608_a().func_177958_n(), villageNearVillager.func_180608_a().func_177956_o(), villageNearVillager.func_180608_a().func_177952_p()};
            closestStructure = "";
            closestCoords = new int[3];
            villagerMappedProfession = -1;
            try {
                villagerMappedProfession = villagerProfession >= 0 && villagerProfession <= 5 ? Integer.valueOf(villagerProfession) : mappedProfessions.get("VanillaProfMaps").get(mappedProfessions.get("IDs").indexOf(villagerProfession));
            }
            catch (Exception e) {
                if (event.getEntityLiving().field_70170_p.field_72995_K) break block30;
                LogHelper.error("Error evaluating mod profession ID. Check your formatting!");
            }
        }
        if (targetPName.equals("VillageNames".toLowerCase() + ":nitwit")) {
            villagerMappedProfession = 5;
        }
        if (targetClassPath.equals("net.daveyx0.primitivemobs.entity.passive.EntityTravelingMerchant")) {
            villagerMappedProfession = GeneralConfigHandler.PMMerchantProfessionMap;
        } else if (targetClassPath.equals("net.daveyx0.primitivemobs.entity.passive.EntityLostMiner")) {
            villagerMappedProfession = GeneralConfigHandler.PMLostMinerProfessionMap;
        } else if (targetClassPath.equals("net.daveyx0.primitivemobs.entity.passive.EntitySheepmanSmith")) {
            villagerMappedProfession = 3;
        }
        switch (villagerMappedProfession) {
            case 0: {
                if (villagerCareer == 2 && monumentDistSq <= maxStructureDistance * maxStructureDistance) {
                    closestStructure = "Monument";
                    closestCoords = nearestMonumentXYZ;
                    break;
                }
                if (!(villageDistSq <= maxStructureDistance * maxStructureDistance)) break;
                closestStructure = "Village";
                closestCoords = nearestVillageXYZ;
                break;
            }
            case 1: {
                if (strongholdDistSq <= maxStructureDistance * maxStructureDistance * strongholdCoefSquared && strongholdDistSq < mansionDistSq) {
                    closestStructure = "Stronghold";
                    closestCoords = nearestStrongholdXYZ;
                    break;
                }
                if (!(mansionDistSq <= maxStructureDistance * maxStructureDistance) || !(mansionDistSq <= strongholdDistSq)) break;
                closestStructure = "Mansion";
                closestCoords = nearestMansionXYZ;
                break;
            }
            case 2: {
                if (monumentDistSq <= maxStructureDistance * maxStructureDistance && monumentDistSq <= templeDistSq) {
                    closestStructure = "Monument";
                    closestCoords = nearestMonumentXYZ;
                    break;
                }
                if (!(templeDistSq <= maxStructureDistance * maxStructureDistance) || !(templeDistSq < monumentDistSq)) break;
                closestStructure = "Temple";
                closestCoords = nearestTempleXYZ;
                break;
            }
            case 3: {
                if (!(mineshaftDistSq <= maxStructureDistance * maxStructureDistance)) break;
                closestStructure = "Mineshaft";
                closestCoords = nearestMineshaftXYZ;
                break;
            }
            case 4: {
                if (villageDistSq <= maxStructureDistance * maxStructureDistance && villageDistSq < templeDistSq) {
                    closestStructure = "Village";
                    closestCoords = nearestVillageXYZ;
                    break;
                }
                if (!(templeDistSq <= maxStructureDistance * maxStructureDistance) || !(templeDistSq <= villageDistSq)) break;
                closestStructure = "Temple";
                closestCoords = nearestTempleXYZ;
                break;
            }
            case 5: {
                double nitwitMax = Double.MAX_VALUE;
                if (strongholdDistSq <= nitwitRadius * nitwitRadius * strongholdCoefSquared) {
                    nitwitMax = strongholdDistSq;
                    closestStructure = "Stronghold";
                    closestCoords = nearestStrongholdXYZ;
                }
                if (villageDistSq <= nitwitRadius * nitwitRadius && villageDistSq <= nitwitMax) {
                    nitwitMax = villageDistSq;
                    closestStructure = "Village";
                    closestCoords = nearestVillageXYZ;
                }
                if (mineshaftDistSq <= nitwitRadius * nitwitRadius && mineshaftDistSq <= nitwitMax) {
                    nitwitMax = mineshaftDistSq;
                    closestStructure = "Mineshaft";
                    closestCoords = nearestMineshaftXYZ;
                }
                if (templeDistSq <= nitwitRadius * nitwitRadius && templeDistSq <= nitwitMax) {
                    nitwitMax = templeDistSq;
                    closestStructure = "Temple";
                    closestCoords = nearestTempleXYZ;
                }
                if (monumentDistSq <= nitwitRadius * nitwitRadius && monumentDistSq <= nitwitMax) {
                    nitwitMax = monumentDistSq;
                    closestStructure = "Monument";
                    closestCoords = nearestMonumentXYZ;
                }
                if (!(mansionDistSq <= nitwitRadius * nitwitRadius) || !(mansionDistSq <= nitwitMax)) break;
                nitwitMax = mansionDistSq;
                closestStructure = "Mansion";
                closestCoords = nearestMansionXYZ;
            }
        }
        if (!closestStructure.equals("")) {
            String structureHintPageText = "\n\n" + WriteBookHandler.writeStructureHintPage(closestStructure, closestCoords, villagerProfession, villageCoords, radius, event);
            return structureHintPageText;
        }
        return "";
    }

    private static int[] nearestStructureLoc(String structureName, PlayerInteractEvent.EntityInteract event, double xOffset, double zOffset, boolean includeThis) {
        int[] structurePos = new int[3];
        Map<String, BlockPos> nearbyStructures = StructureRegistry.instance.getNearestStructures((WorldServer)event.getEntityPlayer().field_70170_p, (int)(event.getTarget().field_70165_t + xOffset), (int)event.getTarget().field_70163_u, (int)(event.getTarget().field_70161_v + zOffset));
        double max = Double.MAX_VALUE;
        boolean CX = false;
        boolean CZ = false;
        boolean radius = false;
        for (Map.Entry<String, BlockPos> e : nearbyStructures.entrySet()) {
            double dz;
            double dy;
            BlockPos pos = e.getValue();
            double dx = (double)pos.func_177958_n() - event.getTarget().field_70165_t;
            double distsq = dx * dx + (dy = (double)pos.func_177956_o() - event.getTarget().field_70163_u) * dy + (dz = (double)pos.func_177952_p() - event.getTarget().field_70161_v) * dz;
            if (!(distsq < max) || !e.getKey().equals(structureName)) continue;
            max = distsq;
            structurePos[0] = pos.func_177958_n();
            structurePos[1] = pos.func_177956_o();
            structurePos[2] = pos.func_177952_p();
        }
        return structurePos;
    }

    public static int[] nearestStructureLoc(String structureName, PlayerInteractEvent.EntityInteract event) {
        return WriteBookHandler.nearestStructureLoc(structureName, event, 0.0, 0.0, false);
    }

    private static String writeStructureHintPage(String nearbyStructure, int[] structureCoords, int villagerProfession, double[] villageCoords, int villageRadius, PlayerInteractEvent.EntityInteract event) {
        String[] structureStringArray;
        String structureName;
        double directionDegrees;
        String structureHintPage = "";
        Random random = event.getWorld().field_73012_v;
        double dx = (double)structureCoords[0] - villageCoords[0];
        double dy = (double)structureCoords[1] - villageCoords[1];
        double dz = (double)structureCoords[2] - villageCoords[2];
        double featureDistance2D = Math.sqrt(dx * dx + dz * dz);
        double featureDistance3D = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double thetaPolar = Math.atan2(-dz, dx);
        for (directionDegrees = thetaPolar * 180.0 / Math.PI; directionDegrees < 0.0; directionDegrees += 360.0) {
        }
        boolean isInVillageBounds = false;
        if (dx * dx + dz * dz <= (double)(villageRadius * villageRadius)) {
            isInVillageBounds = true;
        }
        boolean isBelowGround = false;
        if (nearbyStructure.equals("Mineshaft") || nearbyStructure.equals("Stronghold")) {
            isBelowGround = true;
        }
        String directionString = directionDegrees <= 11.25 ? "east" : (directionDegrees <= 33.75 ? "east-northeast" : (directionDegrees <= 56.25 ? "northeast" : (directionDegrees <= 78.75 ? "north-northeast" : (directionDegrees <= 101.25 ? "north" : (directionDegrees <= 123.75 ? "north-northwest" : (directionDegrees <= 146.25 ? "northwest" : (directionDegrees <= 168.75 ? "west-northwest" : (directionDegrees <= 191.25 ? "west" : (directionDegrees <= 213.75 ? "west-southwest" : (directionDegrees <= 236.25 ? "southwest" : (directionDegrees <= 258.75 ? "south-southwest" : (directionDegrees <= 281.25 ? "south" : (directionDegrees <= 303.75 ? "south-southeast" : (directionDegrees <= 326.25 ? "southeast" : (directionDegrees <= 348.75 ? "east-southeast" : "east")))))))))))))));
        String[] structureNameArray = WriteBookHandler.tryGetStructureName(nearbyStructure, structureCoords, event);
        if (structureNameArray[0] == null && structureNameArray[1] == null && structureNameArray[2] == null) {
            VNWorldDataStructure data = VNWorldDataStructure.forWorld(event.getWorld(), "villagenames3_" + nearbyStructure, "NamedStructures");
            structureNameArray = NameGenerator.newRandomName(nearbyStructure);
            String headerTags = structureNameArray[0];
            String namePrefix = structureNameArray[1];
            String nameRoot = structureNameArray[2];
            String nameSuffix = structureNameArray[3];
            int townColorMeta = 15;
            int signX = structureCoords[0];
            int signY = structureCoords[1];
            int signZ = structureCoords[2];
            NBTTagList nbttaglist = new NBTTagList();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74768_a("signX", signX);
            nbttagcompound1.func_74768_a("signY", signY);
            nbttagcompound1.func_74768_a("signZ", signZ);
            nbttagcompound1.func_74768_a("townColor", townColorMeta);
            nbttagcompound1.func_74778_a("namePrefix", namePrefix);
            nbttagcompound1.func_74778_a("nameRoot", nameRoot);
            nbttagcompound1.func_74778_a("nameSuffix", nameSuffix);
            nbttagcompound1.func_74757_a("fromEntity", true);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            NBTTagCompound tagCompound = data.getData();
            data.getData().func_74782_a((namePrefix + " " + nameRoot + " " + nameSuffix).trim() + ", x" + signX + " y" + signY + " z" + signZ, (NBTBase)nbttaglist);
            data.func_76185_a();
            structureName = structureNameArray[1] + " " + structureNameArray[2] + " " + structureNameArray[3];
            structureName = structureName.trim();
        } else {
            structureName = structureNameArray[0] + " " + structureNameArray[1] + " " + structureNameArray[2];
            structureName = structureName.trim();
        }
        int approxDist2D = (int)Math.round(featureDistance2D / 100.0) * 100;
        String structureString = "";
        if (nearbyStructure.equals("Village")) {
            structureStringArray = new String[]{"We trade with " + structureName + ", ", "The villagers of this town trade with " + structureName + ", ", "Our trading partner, " + structureName + ", is ", "There's another settlement named " + structureName + " that we trade with, ", "The village of " + structureName + " is ", "A village named " + structureName + " is ", "There is a village, " + structureName + ", "};
            structureString = structureStringArray[random.nextInt(structureStringArray.length)];
        } else if (nearbyStructure.equals("Stronghold")) {
            structureStringArray = new String[]{"We have records of a stronghold, " + structureName + ", ", "An underground fortress, " + structureName + ", is ", "Our records list a stronghold, " + structureName + ", ", "A mysterious labyrinth, " + structureName + ", is "};
            structureString = structureStringArray[random.nextInt(structureStringArray.length)];
        } else if (nearbyStructure.equals("Temple")) {
            structureStringArray = new String[]{"An abandoned temple called " + structureName + " is ", "A former religious ritual site, " + structureName + ", is ", "Some bygone religious sect constructed a temple at the " + structureName + " site. It's ", "A previous civilization built the temple of " + structureName + ", "};
            structureString = structureStringArray[random.nextInt(structureStringArray.length)];
        } else if (nearbyStructure.equals("Mineshaft")) {
            structureStringArray = new String[]{"An underground mining site, " + structureName + ", is ", "Previous settlers built an underground mining site, " + structureName + ", ", "There's a long-deserted mine at the old " + structureName + " site ", "Back at the old " + structureName + " site, there should be an abandoned mineshaft. It's ", "An abandoned mining structure known as " + structureName + " is "};
            structureString = structureStringArray[random.nextInt(structureStringArray.length)];
        } else if (nearbyStructure.equals("Monument")) {
            structureStringArray = new String[]{"Rumors on the wind speak of a sunken temple, " + structureName + ", ", "There are rumors of " + structureName + ", under the sea, ", "The monument of " + structureName + "was said to have been dragged into the sea long ago. It's rumored to be ", "An old fisherman's tale mentions " + structureName + ", "};
            structureString = structureStringArray[random.nextInt(structureStringArray.length)];
        } else if (nearbyStructure.equals("Mansion")) {
            structureStringArray = new String[]{"We have records of a cult mansion, " + structureName + ", ", "We have records of a cult operating at " + structureName + ", ", "Our records list a cult mansion, " + structureName + ", ", "A mysterious cult meets at a mansion called " + structureName + ", "};
            structureString = structureStringArray[random.nextInt(structureStringArray.length)];
        }
        if (villagerProfession == 5) {
            if (nearbyStructure.equals("Mineshaft")) {
                structureStringArray = new String[]{"I hear there used to be a mine called " + structureName + ", ", "There used to be a mine over at the old " + structureName + " site, ", "If the wind is still over at the " + structureName + " site, you can hear faint sounds coming from deep underground. You can go check it out if you want: it's "};
                structureString = structureStringArray[random.nextInt(structureStringArray.length)];
            } else if (nearbyStructure.equals("Stronghold")) {
                structureStringArray = new String[]{"I've heard rumors about " + structureName + ", an underground stronghold ", "I get really weird supernatural sensations over at the old " + structureName + " site. If you want to dig around under there, it's "};
                structureString = structureStringArray[random.nextInt(structureStringArray.length)];
            } else if (nearbyStructure.equals("Temple")) {
                structureStringArray = new String[]{"In my wanderings I've stumbled upon an abandoned site called " + structureName + ", ", "I hear there's a temple or something like that over at the " + structureName + " religious site, "};
                structureString = structureStringArray[random.nextInt(structureStringArray.length)];
            } else if (nearbyStructure.equals("Village")) {
                structureStringArray = new String[]{"There is another village named " + structureName + ", ", "Everyone knows about the town of " + structureName + ", ", "My buddy once lost a shoe while visiting " + structureName + ", "};
                structureString = structureStringArray[random.nextInt(structureStringArray.length)];
            } else if (nearbyStructure.equals("Monument")) {
                structureStringArray = new String[]{"I've heard fishermen mention a sunken monument called " + structureName + ", ", "The darkest sea tales, whispered in hushed tones, mention " + structureName + ", a sunken temple filled with treasure. If you dare to look for it, rumor says it's "};
                structureString = structureStringArray[random.nextInt(structureStringArray.length)];
            } else if (nearbyStructure.equals("Mansion")) {
                structureStringArray = new String[]{"I've heard a lot of very bad things about the cult that practices in " + structureName + ", ", "Others don't like to talk about it, but everyone here knows about the eerie cult that gathers at " + structureName + ", deep in the dark wood. If you're foolish enough to look, it's "};
                structureString = structureStringArray[random.nextInt(structureStringArray.length)];
            }
        }
        structureHintPage = structureHintPage + "" + structureString;
        String[] thisVillageArray = new String[]{"this village", "this very village"};
        String thisVillage = thisVillageArray[random.nextInt(thisVillageArray.length)];
        if (isInVillageBounds && isBelowGround) {
            structureHintPage = structureHintPage + "located underneath " + thisVillage + ". ";
        } else if (isInVillageBounds && !isBelowGround) {
            structureHintPage = structureHintPage + "located within " + thisVillage + ". ";
        } else {
            String approxString;
            String[] approxStringArray;
            if (approxDist2D >= 100) {
                approxStringArray = new String[]{"approximately", "roughly", "about"};
                approxString = approxStringArray[random.nextInt(approxStringArray.length)];
                structureHintPage = structureHintPage + "located " + approxString;
                structureHintPage = structureHintPage + " " + approxDist2D + " meters ";
            } else {
                approxStringArray = new String[]{"less than", "under", "short of"};
                approxString = approxStringArray[random.nextInt(approxStringArray.length)];
                structureHintPage = structureHintPage + "located " + approxString;
                structureHintPage = structureHintPage + " 100 meters ";
            }
            String[] wordArray = new String[]{"due", "to the"};
            String randomWord = wordArray[random.nextInt(wordArray.length)];
            structureHintPage = structureHintPage + randomWord + " " + directionString + ". ";
        }
        return structureHintPage;
    }

    private static String[] tryGetStructureName(String nearbyStructure, int[] structureCoords, PlayerInteractEvent.EntityInteract event) {
        VNWorldDataStructure data = VNWorldDataStructure.forWorld(event.getEntity().field_70170_p, "villagenames3_" + nearbyStructure, "NamedStructures");
        NBTTagCompound tagCompound = data.getData();
        Set tagmapKeyset = tagCompound.func_150296_c();
        Iterator itr = tagmapKeyset.iterator();
        String namePrefix = null;
        String nameRoot = null;
        String nameSuffix = null;
        while (itr.hasNext()) {
            Object element = itr.next();
            String townSignEntry = element.toString();
            NBTTagCompound tagList = tagCompound.func_150295_c(townSignEntry, (int)tagCompound.func_74732_a()).func_150305_b(0);
            int featureX = tagList.func_74762_e("signX");
            int featureY = tagList.func_74762_e("signY");
            int featureZ = tagList.func_74762_e("signZ");
            double sdx = featureX - structureCoords[0];
            double d = featureY == 64 ? 0.0 : (double)(featureY - structureCoords[1]);
            double sdy = d;
            double sdz = featureZ - structureCoords[2];
            if (!(sdx * sdx + sdy * sdy + sdz * sdz <= 10000.0)) continue;
            namePrefix = tagList.func_74779_i("namePrefix");
            nameRoot = tagList.func_74779_i("nameRoot");
            nameSuffix = tagList.func_74779_i("nameSuffix");
        }
        return new String[]{namePrefix, nameRoot, nameSuffix};
    }

    public static String[] tryGetStructureInfo(String structureType, int[] structureBB, World world) {
        VNWorldDataStructure data = null;
        data = VNWorldDataStructure.forWorld(world, "villagenames3_" + structureType, "NamedStructures");
        NBTTagCompound tagCompound = data.getData();
        Set tagmapKeyset = tagCompound.func_150296_c();
        Iterator itr = tagmapKeyset.iterator();
        String namePrefix = null;
        String nameRoot = null;
        String nameSuffix = null;
        String signX = null;
        String signY = null;
        String signZ = null;
        while (itr.hasNext()) {
            Object element = itr.next();
            String featureSignLoc = element.toString();
            NBTTagCompound tagList = tagCompound.func_150295_c(featureSignLoc, (int)tagCompound.func_74732_a()).func_150305_b(0);
            int[] structureCoords = new int[]{tagList.func_74762_e("signX"), tagList.func_74762_e("signY"), tagList.func_74762_e("signZ")};
            if (structureCoords[0] < structureBB[0] || structureCoords[2] < structureBB[2] || structureCoords[0] > structureBB[3] || structureCoords[2] > structureBB[5] || structureCoords[1] != 64 && (structureCoords[1] < structureBB[1] || structureCoords[1] > structureBB[4])) continue;
            namePrefix = tagList.func_74779_i("namePrefix");
            nameRoot = tagList.func_74779_i("nameRoot");
            nameSuffix = tagList.func_74779_i("nameSuffix");
            signX = "" + structureCoords[0];
            signY = "" + structureCoords[1];
            signZ = "" + structureCoords[2];
        }
        return new String[]{namePrefix, nameRoot, nameSuffix, signX, signY, signZ};
    }
}

