/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.tracker;

import astrotibs.villagenames.common.ExtendedVillagerZombie;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EventTracker {
    private final Vec3i eventPos;
    private final String customName;
    private final Object extraInfo;
    private int tickWhenAdded;
    private final int entityID;

    public Vec3i getPosition() {
        return this.eventPos;
    }

    public String getCustomName() {
        return this.customName;
    }

    public Object getExtraInfo() {
        return this.extraInfo;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public void setBirthTick(int tick) {
        this.tickWhenAdded = tick;
    }

    public int getBirthTick() {
        return this.tickWhenAdded;
    }

    public void expireNow() {
        this.tickWhenAdded = -1;
    }

    private EventTracker(int entityID, Vec3i pos, String customName, Object extraInfo) {
        this.entityID = entityID;
        this.customName = customName;
        this.eventPos = pos;
        this.extraInfo = extraInfo;
        this.tickWhenAdded = 0;
    }

    public EventTracker(EntityVillager villager) {
        this(villager.func_145782_y(), new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v), villager.func_95999_t(), new Object[]{villager.func_70946_n(), ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"careerId", "field_175563_bv"}), villager.func_70631_g_()});
    }

    public EventTracker(EntityLiving guard) {
        this(guard.func_145782_y(), new Vec3i(guard.field_70165_t, guard.field_70163_u + 0.5, guard.field_70161_v), guard.func_95999_t(), new Object[0]);
    }

    public EventTracker(EntityZombie zombie, ExtendedVillagerZombie properties) {
        this(zombie.func_145782_y(), new Vec3i(zombie.field_70165_t, zombie.field_70163_u + 0.5, zombie.field_70161_v), zombie.func_95999_t(), properties);
    }

    public void updateZombie(EntityJoinWorldEvent event, ExtendedVillagerZombie properties) {
        EntityZombie zombie = (EntityZombie)event.getEntity();
        if (GeneralConfigHandler.debugMessages) {
            LogHelper.info("EventTracker.updateZombie called with this.getCustomName(): " + this.getCustomName() + ", this.getObject(): " + this.getExtraInfo());
        }
        Object[] extraInfo = (Object[])this.getExtraInfo();
        int profession = (Integer)extraInfo[0];
        int career = (Integer)extraInfo[1];
        boolean isBaby = (Boolean)extraInfo[2];
        String customName = this.getCustomName();
        String PMTMUnloc = "Traveling Merchant";
        String PMTMUnlocModern = "Traveling Merchant";
        String PMShUnloc = "Sheepman";
        String PMShUnlocModern = "Sheepman";
        String PMSSUnloc = "Sheepman Smith";
        if (!(customName.equals("") || customName.equals(null) || customName.equals(PMTMUnloc) || customName.equals(PMTMUnlocModern) || customName.equals(PMShUnloc) || customName.equals(PMShUnlocModern) || customName.equals(PMSSUnloc))) {
            zombie.func_96094_a(this.getCustomName());
            zombie.func_110163_bv();
        }
        zombie.func_82227_f(isBaby);
        zombie.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
        zombie.func_184201_a(EntityEquipmentSlot.OFFHAND, null);
        zombie.func_184201_a(EntityEquipmentSlot.CHEST, null);
        zombie.func_184201_a(EntityEquipmentSlot.FEET, null);
        zombie.func_184201_a(EntityEquipmentSlot.HEAD, null);
        zombie.func_184201_a(EntityEquipmentSlot.LEGS, null);
    }

    public void updateVillager(EntityVillager villager) {
        if (GeneralConfigHandler.debugMessages) {
            LogHelper.info("EventTracker.updateVillager called with this.getCustomName(): " + this.getCustomName());
        }
        ExtendedVillagerZombie properties = (ExtendedVillagerZombie)this.getExtraInfo();
        if (!this.getCustomName().equals("") && !this.getCustomName().equals(null)) {
            villager.func_96094_a(this.getCustomName());
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Entity ID = ");
        r.append(this.getEntityID());
        r.append(", Position = ");
        if (this.getPosition() == null) {
            r.append("NULL");
        } else {
            r.append(this.getPosition().toString());
        }
        r.append(", Tick of Birth = ");
        r.append(this.getBirthTick());
        r.append(", Custom Name = ");
        r.append(this.getCustomName());
        r.append(", Extra Info = ");
        if (this.getExtraInfo() == null) {
            r.append("NULL");
        } else {
            r.append(this.getExtraInfo().getClass().getName());
            r.append(":");
            r.append(this.getExtraInfo().toString());
        }
        return r.toString();
    }
}

