/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.tracker;

import astrotibs.villagenames.common.ExtendedVillagerZombie;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.tracker.EventTracker;
import astrotibs.villagenames.utility.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ServerInfoTracker {
    private static HashMap<Integer, Integer> CuredZombies = new HashMap();
    private static int CuredZombiesListLastChange = 0;
    private static HashMap<Integer, Integer> CuredVillagers = new HashMap();
    private static int CuredVillagersListLastChange = 0;
    private static final int ListExpiration = 12000;
    private static boolean canStartTracking = false;

    public static void add(EntityVillager villager, World world) {
        ServerInfoTracker.add(EventType.VILLAGER, new EventTracker(villager), world);
    }

    public static void add(EntityZombie zombie, World world) {
        ExtendedVillagerZombie properties = null;
        ServerInfoTracker.add(EventType.ZOMBIE, new EventTracker(zombie, properties), world);
    }

    public static void add(EntityLiving guard, World world) {
        ServerInfoTracker.add(EventType.GUARD, new EventTracker(guard), world);
    }

    public static void startedCuringZombie(int playerID, int zombieID, World world) {
        if (zombieID > 0 && playerID > 0) {
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("> Player [" + playerID + "] started to cure zombie [" + zombieID + "]");
            }
            CuredZombies.put(zombieID, playerID);
            CuredZombiesListLastChange = world.func_73046_m().func_71259_af();
        }
    }

    public static void endedCuringZombie(int oldZombieID, int newVillagerID, World world) {
        Integer playerID = CuredZombies.get(oldZombieID);
        if (newVillagerID > 0 && playerID != null && playerID > 0) {
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("> Player [" + playerID + "] cured villager [" + newVillagerID + "], formerly known as zombie [" + oldZombieID + "]");
            }
            CuredVillagers.put(newVillagerID, playerID);
            CuredVillagersListLastChange = world.func_73046_m().func_71259_af();
        }
    }

    private static void add(EventType type, EventTracker event, World world) {
        if (ServerInfoTracker.ThisTick(world) == 0) {
            return;
        }
        if (event == null) {
            return;
        }
        if (!canStartTracking) {
            return;
        }
        event.setBirthTick(world.func_73046_m().func_71259_af());
        type.getTracker().add(event);
    }

    public static EventTracker seek(EventType type, Vec3i position, World world) {
        int ageTolerance;
        int rangeLimit;
        switch (type) {
            case VILLAGER: {
                rangeLimit = 1;
                ageTolerance = 5;
                break;
            }
            case ZOMBIE: {
                rangeLimit = 1;
                ageTolerance = 3;
                break;
            }
            case GUARD: {
                rangeLimit = 1;
                ageTolerance = 5;
                break;
            }
            default: {
                return null;
            }
        }
        return ServerInfoTracker.seekValueOnList(type.getTracker(), position, rangeLimit, ageTolerance, world);
    }

    private static EventTracker seekValueOnList(List<EventTracker> list, Vec3i position, int rangeLimit, int ageTolerance, World world) {
        int thisTick = ServerInfoTracker.ThisTick(world);
        for (EventTracker et : list) {
            if (et.getBirthTick() <= 0 || et.getBirthTick() + ageTolerance < thisTick || !(position.func_177951_i(et.getPosition()) <= (double)rangeLimit)) continue;
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("ServerInfoTracker > found a valid target [" + et + "]");
            }
            et.expireNow();
            return et;
        }
        return null;
    }

    public static void removeCuredZombiesFromTracker(World world, int zombieID) {
        Integer playerID = CuredZombies.get(zombieID);
        if (playerID != null && playerID > 0) {
            CuredZombies.remove(zombieID);
        }
    }

    public static void removeCuredVillagersFromTracker(World world, int villagerID) {
        Integer playerID = CuredVillagers.get(villagerID);
        if (playerID != null && playerID > 0) {
            CuredVillagers.remove(villagerID);
        }
    }

    public static void cleanExpired(World world) {
        if (!canStartTracking) {
            return;
        }
        int thisTick = ServerInfoTracker.ThisTick(world);
        int expireAllUntil = thisTick - 100;
        ServerInfoTracker.cleanExpiredList(EventType.VILLAGER.getTracker(), expireAllUntil);
        ServerInfoTracker.cleanExpiredList(EventType.ZOMBIE.getTracker(), expireAllUntil);
        ServerInfoTracker.cleanExpiredList(EventType.GUARD.getTracker(), expireAllUntil);
        if (CuredZombiesListLastChange + 12000 < thisTick && CuredZombies.size() > 0) {
            CuredZombies.clear();
        }
        if (CuredVillagersListLastChange + 12000 < thisTick && CuredVillagers.size() > 0) {
            CuredVillagers.clear();
        }
    }

    private static void cleanExpiredList(List<EventTracker> list, int limit) {
        if (list.size() > 0) {
            Iterator<EventTracker> i = list.iterator();
            while (i.hasNext()) {
                EventTracker et = i.next();
                if (et.getBirthTick() >= 0 && et.getBirthTick() >= limit) continue;
                if (GeneralConfigHandler.debugMessages) {
                    LogHelper.info("removing: " + et);
                }
                i.remove();
            }
        }
    }

    public static void startTracking() {
        canStartTracking = true;
        EventType.ZOMBIE.getTracker().clear();
        EventType.VILLAGER.getTracker().clear();
        EventType.GUARD.getTracker().clear();
        CuredZombies.clear();
        CuredVillagers.clear();
    }

    private static int ThisTick(World world) {
        return world.func_73046_m().func_71259_af();
    }

    public static enum EventType {
        ZOMBIE,
        VILLAGER,
        GUARD;

        private List<EventTracker> tracker = new ArrayList<EventTracker>();

        public List<EventTracker> getTracker() {
            return this.tracker;
        }
    }
}

