/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ReputationHandler {
    private static final String repTagKey = "VNRep";
    private static final String repSuffix = "_rep";

    @SubscribeEvent
    public void repairerOfReputations(WorldEvent.Load event) {
        World world = event.getWorld();
        try {
            MapGenStructureData structureData = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
            NBTTagCompound nbttagcompound = structureData.func_143041_a();
            for (Object element : nbttagcompound.func_150296_c()) {
                NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                if (nbtbase.func_74732_a() != 10) continue;
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                NBTTagCompound playerReps = new NBTTagCompound();
                if (nbttagcompound2.func_74764_b(repTagKey)) {
                    playerReps = (NBTTagCompound)nbttagcompound2.func_74781_a(repTagKey);
                }
                for (Object repElement : playerReps.func_150296_c()) {
                    String playerUUID = repElement.toString();
                    int VNRep = playerReps.func_74762_e(playerUUID);
                    boolean VNCollected = playerReps.func_74767_n(playerUUID + repSuffix);
                    if (!playerReps.func_74764_b(playerUUID + repSuffix)) continue;
                    if (GeneralConfigHandler.debugMessages) {
                        LogHelper.info("Resetting rep flag for player " + playerUUID + " in village " + element.toString());
                    }
                    playerReps.func_74757_a(playerUUID + repSuffix, false);
                    structureData.func_76185_a();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getVNReputationForPlayer(EntityPlayerMP player, String villageTopTag, Village village) {
        MapGenStructureData structureData = (MapGenStructureData)player.field_70170_p.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
        NBTTagCompound nbttagcompound = structureData.func_143041_a();
        NBTBase nbtbase = nbttagcompound.func_74781_a(villageTopTag);
        NBTTagCompound villageTag = (NBTTagCompound)nbtbase;
        NBTTagCompound playerReps = new NBTTagCompound();
        int VNPlayerRep = 0;
        boolean returnDefaultRep = false;
        if (villageTag != null) {
            if (villageTag.func_74764_b(repTagKey)) {
                playerReps = (NBTTagCompound)villageTag.func_74781_a(repTagKey);
                if (playerReps.func_74764_b(player.func_110124_au().toString())) {
                    int PrevVNPlayerRep = playerReps.func_74762_e(player.func_110124_au().toString());
                    if (village == null) {
                        VNPlayerRep = PrevVNPlayerRep;
                    } else {
                        int collectionRep = village.getPlayerReputation(player.func_110124_au());
                        if (PrevVNPlayerRep == collectionRep) {
                            VNPlayerRep = PrevVNPlayerRep;
                        } else if (collectionRep != 0) {
                            if (playerReps.func_74767_n(player.func_110124_au().toString() + repSuffix)) {
                                if (GeneralConfigHandler.debugMessages) {
                                    LogHelper.info("There was a reputation mismatch. Player age is " + player.field_70173_aa + ". We assume villageCollectionObj was correct: " + collectionRep + " and not VN's: " + PrevVNPlayerRep);
                                }
                                VNPlayerRep = collectionRep;
                            } else {
                                if (GeneralConfigHandler.debugMessages) {
                                    LogHelper.info("There was a reputation mismatch. We assume VN's was correct: " + PrevVNPlayerRep + " and not villageCollectionObj's: " + collectionRep);
                                }
                                village.modifyPlayerReputation(player.func_110124_au(), PrevVNPlayerRep - collectionRep);
                                VNPlayerRep = PrevVNPlayerRep;
                            }
                        }
                    }
                } else {
                    returnDefaultRep = true;
                }
            } else {
                returnDefaultRep = true;
            }
            if (returnDefaultRep && village != null) {
                VNPlayerRep = village.getPlayerReputation(player.func_110124_au());
                if (GeneralConfigHandler.debugMessages) {
                    LogHelper.info("You have no recorded VN rep in this town. It is now set to " + VNPlayerRep);
                }
            }
            villageTag.func_74782_a(repTagKey, (NBTBase)playerReps);
            playerReps.func_74768_a(player.func_110124_au().toString(), VNPlayerRep);
            playerReps.func_74757_a(player.func_110124_au().toString() + repSuffix, village != null);
            structureData.func_76185_a();
            return VNPlayerRep;
        }
        int nullVillageTagRep = 0;
        try {
            nullVillageTagRep = village.getPlayerReputation(player.func_110124_au());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nullVillageTagRep;
    }

    public static String getVillageTagPlayerIsIn(EntityPlayerMP player) {
        MapGenStructureData structureData = (MapGenStructureData)player.field_70170_p.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
        NBTTagCompound nbttagcompound = structureData.func_143041_a();
        for (Object entry : nbttagcompound.func_150296_c()) {
            NBTTagCompound villageTag;
            NBTBase nbtbase = nbttagcompound.func_74781_a(entry.toString());
            if (nbtbase.func_74732_a() != 10 || !(villageTag = (NBTTagCompound)nbtbase).func_74767_n("Valid")) continue;
            int[] boundingBox = villageTag.func_74759_k("BB");
            int posX = (int)player.field_70165_t;
            int posY = (int)player.field_70163_u;
            int posZ = (int)player.field_70161_v;
            if (posX < boundingBox[0] || posY < boundingBox[1] || posZ < boundingBox[2] || posX > boundingBox[3] || posY > boundingBox[4] || posZ > boundingBox[5]) continue;
            return entry.toString();
        }
        return "none";
    }
}

