/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.IOUtils;

public class VersionChecker
implements Runnable {
    private static boolean isLatestVersion = false;
    private static String latestVersion = "";

    @Override
    public void run() {
        InputStream in = null;
        try {
            in = new URL("https://www.dropbox.com/s/y2xm0pagpie2lhx/latestversion_1.11.2.txt?dl=1").openStream();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            latestVersion = (String)IOUtils.readLines((InputStream)in).get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        isLatestVersion = "3.0".equals(latestVersion);
        if (!(this.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null))) {
            LogHelper.info("This version of Village Names (3.0) differs from the latest version: " + latestVersion);
        }
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getLatestVersion() {
        return latestVersion;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            if (!(VillageNames.haveWarnedVersionOutOfDate || !GeneralConfigHandler.versionChecker || VillageNames.versionChecker.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null) || "3.0".contains("DEV"))) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Village Names" + TextFormatting.RESET + " version " + TextFormatting.YELLOW + this.getLatestVersion() + TextFormatting.RESET + " is available! Get it at:"));
                event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "minecraft.curseforge.com/projects/village-names" + TextFormatting.RESET));
            }
            VillageNames.haveWarnedVersionOutOfDate = true;
        }
    }
}

