/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.sounds;

import astrotibs.villagenames.config.GeneralConfigHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EventSounds {
    private double enderEyeSoundRadius = 18.0;
    public static final SoundEvent ENDEREYE_DEAD = EventSounds.registerSound("entity.endereye.dead");
    public static final SoundEvent ENDEREYE_LAUNCH = EventSounds.registerSound("entity.endereye.endereye_launch");
    public static final SoundEvent ENDPORTAL_PLACE = EventSounds.registerSound("block.end_portal.eyeplace");
    public static final SoundEvent ENDPORTAL_OPEN = EventSounds.registerSound("block.end_portal.endportal");

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && GeneralConfigHandler.enderSounds && event.getEntity() instanceof EntityPlayerMP) {
            ArrayList allPlayers = Lists.newArrayList();
            for (Object entity : event.getEntity().field_70170_p.field_73010_i) {
                if (!EntityPlayerMP.class.isAssignableFrom(entity.getClass())) continue;
                allPlayers.add((EntityPlayerMP)entity);
            }
            for (EntityPlayerMP entityplayermp : allPlayers) {
                World world = event.getEntity().field_70170_p;
                List listEnderEyesInRange = world.func_72872_a(EntityEnderEye.class, new AxisAlignedBB(entityplayermp.field_70165_t - this.enderEyeSoundRadius, entityplayermp.field_70163_u - this.enderEyeSoundRadius, entityplayermp.field_70161_v - this.enderEyeSoundRadius, entityplayermp.field_70165_t + this.enderEyeSoundRadius, entityplayermp.field_70163_u + this.enderEyeSoundRadius, entityplayermp.field_70161_v + this.enderEyeSoundRadius));
                if (listEnderEyesInRange == null) continue;
                for (EntityEnderEye entityendereye : listEnderEyesInRange) {
                    List listPlayersInRange;
                    double eyeX = entityendereye.field_70165_t;
                    double eyeY = entityendereye.field_70163_u;
                    double eyeZ = entityendereye.field_70161_v;
                    int despawnTimer = -1;
                    if (!((entityplayermp.field_70165_t - eyeX) * (entityplayermp.field_70165_t - eyeX) + (entityplayermp.field_70163_u - eyeY) * (entityplayermp.field_70163_u - eyeY) + (entityplayermp.field_70161_v - eyeZ) * (entityplayermp.field_70161_v - eyeZ) <= this.enderEyeSoundRadius * this.enderEyeSoundRadius)) continue;
                    try {
                        despawnTimer = (Integer)ReflectionHelper.getPrivateValue(EntityEnderEye.class, (Object)entityendereye, (String[])new String[]{"despawnTimer", "field_70223_e"});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (despawnTimer != 80 || entityplayermp != (listPlayersInRange = world.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(eyeX - this.enderEyeSoundRadius, eyeY - this.enderEyeSoundRadius, eyeZ - this.enderEyeSoundRadius, eyeX + this.enderEyeSoundRadius, eyeY + this.enderEyeSoundRadius, eyeZ + this.enderEyeSoundRadius))).get(0)) continue;
                    entityplayermp.field_70170_p.func_184148_a((EntityPlayer)null, eyeX + 0.5, eyeY + 0.5, eyeZ + 0.5, ENDEREYE_DEAD, SoundCategory.MASTER, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && (event.getHand() == EnumHand.MAIN_HAND && event.getEntityPlayer().func_184614_ca() != null && event.getEntityPlayer().func_184614_ca().func_77973_b() == Items.field_151061_bv || event.getHand() == EnumHand.OFF_HAND && event.getEntityPlayer().func_184592_cb() != null && event.getEntityPlayer().func_184592_cb().func_77973_b() == Items.field_151061_bv) && GeneralConfigHandler.enderSounds && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150378_br && !((Boolean)event.getWorld().func_180495_p(event.getPos()).func_177229_b((IProperty)BlockEndPortalFrame.field_176507_b)).booleanValue()) {
            event.getWorld().func_184148_a((EntityPlayer)null, (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5, ENDPORTAL_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            Integer[] portalCenter = this.endPortalTriggering(event.getWorld(), event.getPos(), event.getEntityPlayer());
            if (portalCenter != null) {
                event.getWorld().func_184148_a((EntityPlayer)null, (double)portalCenter[0].intValue() + 0.5, (double)portalCenter[1].intValue() + 0.5, (double)portalCenter[2].intValue() + 0.5, ENDPORTAL_OPEN, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && GeneralConfigHandler.enderSounds && event.getEntity() instanceof EntityEnderEye) {
            event.getWorld().func_184148_a((EntityPlayer)null, event.getEntity().field_70165_t + 0.5, event.getEntity().field_70163_u + 0.5, event.getEntity().field_70161_v + 0.5, ENDEREYE_LAUNCH, SoundCategory.MASTER, 1.0f, 1.0f);
        }
    }

    private Integer[] endPortalTriggering(World world, BlockPos pos, EntityPlayer player) {
        Block targetBlock = world.func_180495_p(pos).func_177230_c();
        int targetMeta = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
        if (targetBlock == Blocks.field_150378_br && (targetMeta & 4) == 0) {
            int portalCenterOffsetX;
            Integer[] xOffsetsToScan = new Integer[]{0, 1, 2, 2, 2, 1, 0, -1, -2, -2, -2, -1};
            Integer[] zOffsetsToScan = new Integer[]{-2, -2, -1, 0, 1, 2, 2, 2, 1, 0, -1, -2};
            Integer[] metaRequired = new Integer[]{4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 4};
            int n = targetMeta == 3 ? 2 : (portalCenterOffsetX = targetMeta == 1 ? -2 : 0);
            int portalCenterOffsetZ = targetMeta == 0 ? 2 : (targetMeta == 2 ? -2 : 0);
            Block possibleFrameBlock = null;
            int possibleFrameMeta = -1;
            for (int nudge = -1; nudge <= 1; ++nudge) {
                int portalCenterOffsetNudgeX = targetMeta % 2 == 0 ? nudge : 0;
                int portalCenterOffsetNudgeZ = (targetMeta + 1) % 2 == 0 ? nudge : 0;
                int eyedCorrectFramePieces = 0;
                int uneyedCorrectFramePieces = 0;
                for (int i = 0; i < xOffsetsToScan.length; ++i) {
                    possibleFrameBlock = world.func_180495_p(new BlockPos(pos.func_177958_n() + portalCenterOffsetX + xOffsetsToScan[i] + portalCenterOffsetNudgeX, pos.func_177956_o(), pos.func_177952_p() + portalCenterOffsetZ + zOffsetsToScan[i] + portalCenterOffsetNudgeZ)).func_177230_c();
                    possibleFrameMeta = world.func_180495_p(new BlockPos(pos.func_177958_n() + portalCenterOffsetX + xOffsetsToScan[i] + portalCenterOffsetNudgeX, pos.func_177956_o(), pos.func_177952_p() + portalCenterOffsetZ + zOffsetsToScan[i] + portalCenterOffsetNudgeZ)).func_177230_c().func_176201_c(world.func_180495_p(new BlockPos(pos.func_177958_n() + portalCenterOffsetX + xOffsetsToScan[i] + portalCenterOffsetNudgeX, pos.func_177956_o(), pos.func_177952_p() + portalCenterOffsetZ + zOffsetsToScan[i] + portalCenterOffsetNudgeZ)));
                    if (possibleFrameBlock != Blocks.field_150378_br) continue;
                    if (possibleFrameMeta == metaRequired[i]) {
                        ++eyedCorrectFramePieces;
                        continue;
                    }
                    if (possibleFrameMeta != metaRequired[i] - 4) break;
                    ++uneyedCorrectFramePieces;
                }
                if (eyedCorrectFramePieces != 11 || uneyedCorrectFramePieces != true) continue;
                return new Integer[]{pos.func_177958_n() + portalCenterOffsetX + portalCenterOffsetNudgeX, pos.func_177956_o(), pos.func_177952_p() + portalCenterOffsetZ + portalCenterOffsetNudgeZ};
            }
        }
        return null;
    }

    public static void registerSounds() {
    }

    private static SoundEvent registerSound(String soundName) {
        ResourceLocation soundID = new ResourceLocation("villagenames".toLowerCase(), soundName);
        return (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(soundID).setRegistryName(soundID));
    }
}

