/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames;

import astrotibs.villagenames.block.ModBlocksVN;
import astrotibs.villagenames.command.CommandName;
import astrotibs.villagenames.config.ConfigInit;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.handler.DevVersionWarning;
import astrotibs.villagenames.handler.EntityMonitorHandler;
import astrotibs.villagenames.handler.ServerCleanExpired;
import astrotibs.villagenames.handler.ServerTrackerStarter;
import astrotibs.villagenames.handler.VersionChecker;
import astrotibs.villagenames.handler.VillagerTradeHandler;
import astrotibs.villagenames.igloo.IglooGeneratorIWG;
import astrotibs.villagenames.igloo.VNComponentIglooPieces;
import astrotibs.villagenames.igloo.VNMapGenIgloo;
import astrotibs.villagenames.init.Recipes;
import astrotibs.villagenames.integration.ModChecker;
import astrotibs.villagenames.item.ModItems;
import astrotibs.villagenames.nbt.NBTUpdater;
import astrotibs.villagenames.network.MessageVillageGuard;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import astrotibs.villagenames.network.NetworkHelper;
import astrotibs.villagenames.prismarine.guardian.entity.monster.EntityGuardian;
import astrotibs.villagenames.prismarine.guardian.particle.PacketHandlerClient;
import astrotibs.villagenames.prismarine.guardian.particle.SToCMessage;
import astrotibs.villagenames.prismarine.guardian.spawning.SpawnEventListener;
import astrotibs.villagenames.prismarine.monument.MonumentGeneratorIWG;
import astrotibs.villagenames.prismarine.monument.StructureOceanMonument;
import astrotibs.villagenames.prismarine.monument.StructureOceanMonumentPieces;
import astrotibs.villagenames.prismarine.register.ModBlocksPrismarine;
import astrotibs.villagenames.prismarine.register.ModItemsPrismarine;
import astrotibs.villagenames.proxy.CommonProxy;
import astrotibs.villagenames.sounds.EventSounds;
import astrotibs.villagenames.sounds.PersistentMonitorSounds;
import astrotibs.villagenames.utility.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.stats.Achievement;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="VillageNames", name="Village Names", version="3.0", guiFactory="astrotibs.villagenames.gui.VNGuiFactory")
public final class VillageNames {
    @SidedProxy(clientSide="astrotibs.villagenames.proxy.ClientProxy", serverSide="astrotibs.villagenames.proxy.ServerProxy")
    public static CommonProxy PROXY;
    public static SimpleNetworkWrapper VNNetworkWrapper;
    public static File configDirectory;
    @Mod.Instance(value="VillageNames")
    public static VillageNames instance;
    public static String currentConfigFolder;
    public static String oldConfigFolder;
    public static String obsoleteConfigFolder;
    public static Achievement maxrep;
    public static Achievement minrep;
    public static Achievement ghosttown;
    public static Achievement archaeologist;
    public static Achievement laputa;
    public static VersionChecker versionChecker;
    public static boolean haveWarnedVersionOutOfDate;
    public static boolean devVersionWarned;
    public static int numberStructuresArchaeologist;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModChecker.printDetectedMods();
        configDirectory = new File(event.getModConfigurationDirectory(), currentConfigFolder);
        ConfigInit.init(configDirectory);
        File oldConfigDirectory = new File(event.getModConfigurationDirectory(), oldConfigFolder);
        if (new File(event.getModConfigurationDirectory(), oldConfigFolder).exists()) {
            LogHelper.warn("ATTENTION! The old configuration folder " + oldConfigFolder + " exists. It will NOT BE USED in this version of Village Names! A new " + currentConfigFolder + " folder has been created.");
            if (new File(event.getModConfigurationDirectory(), obsoleteConfigFolder).exists()) {
                LogHelper.error("For some reason, you have both a " + oldConfigFolder + " and " + obsoleteConfigFolder + " folder. Note that NEITHER FOLDER IS USED!");
            } else {
                try {
                    oldConfigDirectory.renameTo(new File(event.getModConfigurationDirectory(), obsoleteConfigFolder));
                    LogHelper.warn("The previous config folder has been renamed to " + obsoleteConfigFolder + ". It will NOT BE USED anymore.");
                }
                catch (Exception e) {
                    LogHelper.error("Failed to rename " + oldConfigFolder + " folder to " + obsoleteConfigFolder);
                }
            }
        } else if (new File(event.getModConfigurationDirectory(), obsoleteConfigFolder).exists()) {
            LogHelper.info("Old config files are located in config/" + obsoleteConfigFolder + ". They will NOT BE USED anymore.");
        }
        ModItems.init();
        ModBlocksVN.init();
        if (GeneralConfigHandler.codexChestLoot) {
            ChestLootHandler.init();
        }
        if (GeneralConfigHandler.addOceanMonuments) {
            ModBlocksPrismarine.init();
            ModItemsPrismarine.init();
            GameRegistry.registerWorldGenerator((IWorldGenerator)new MonumentGeneratorIWG(), (int)0);
            MapGenStructureIO.func_143034_b(StructureOceanMonument.StartMonument.class, (String)"Monument");
            StructureOceanMonumentPieces.registerOceanMonumentPieces();
            EntityRegistry.registerGlobalEntityID(EntityGuardian.class, (String)"Guardian", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)5929580, (int)15040062);
            MinecraftForge.EVENT_BUS.register((Object)new SpawnEventListener());
            LogHelper.info("Ocean Monuments, Prismarine, Guardians, and Sponges registered");
        }
        if (GeneralConfigHandler.addIgloos) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new IglooGeneratorIWG(), (int)0);
            MapGenStructureIO.func_143034_b(VNMapGenIgloo.Start.class, (String)"Temple");
            VNComponentIglooPieces.registerScatteredFeaturePieces();
            ChestLootHandler.iglooChest();
            LogHelper.info("Registered Igloo generation");
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventSounds());
        FMLCommonHandler.instance().bus().register((Object)new PersistentMonitorSounds());
        MinecraftForge.EVENT_BUS.register((Object)new NBTUpdater());
        MinecraftForge.EVENT_BUS.register((Object)new ServerTrackerStarter());
        MinecraftForge.EVENT_BUS.register((Object)new EntityMonitorHandler());
        FMLCommonHandler.instance().bus().register((Object)new ServerCleanExpired());
        if (GeneralConfigHandler.versionChecker) {
            FMLCommonHandler.instance().bus().register((Object)versionChecker);
        }
        if ("3.0".contains("DEV")) {
            FMLCommonHandler.instance().bus().register((Object)new DevVersionWarning());
        }
        PROXY.preInit(event);
        int clientMessageID = 2;
        VNNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("vnChannel");
        VNNetworkWrapper.registerMessage(PacketHandlerClient.class, SToCMessage.class, clientMessageID, Side.CLIENT);
        VNNetworkWrapper.registerMessage(NetworkHelper.VillagerProfessionHandler.class, MessageZombieVillagerProfession.class, 0, Side.CLIENT);
        VNNetworkWrapper.registerMessage(NetworkHelper.VillageGuardHandler.class, MessageVillageGuard.class, 1, Side.CLIENT);
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().name = EnumChatFormatting.GOLD + "Village Names";
        event.getModMetadata().version = EnumChatFormatting.YELLOW + "3.0";
        event.getModMetadata().credits = EnumChatFormatting.AQUA + "Thanks: Pahimar, MineMaarten, whrrgarbl, Jabelar, Darian Stephens";
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.add(EnumChatFormatting.BLUE + "AstroTibs");
        event.getModMetadata().url = EnumChatFormatting.GRAY + "minecraft.curseforge.com/projects/village-names";
        event.getModMetadata().description = EnumChatFormatting.GREEN + "Generates random names for villages, villagers, and other structures and entities.";
        event.getModMetadata().logoFile = "assets/villagenames/vn_banner.png";
        if (GeneralConfigHandler.villagerCareers) {
            for (int i = 0; i < 5; ++i) {
                VillagerRegistry.instance().registerVillageTradeHandler(i, (VillagerRegistry.IVillageTradeHandler)new VillagerTradeHandler());
            }
            LogHelper.info("Registered Villager careers and updated trade pools");
        }
        if (GeneralConfigHandler.enableNitwit) {
            VillagerRegistry.instance().registerVillagerId(5);
            LogHelper.info("Registered Nitwit villager");
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Recipes.init();
        PROXY.init(event);
        PROXY.registerRender();
        PROXY.registerEvents();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandName());
    }

    static {
        currentConfigFolder = "VillageNames3";
        oldConfigFolder = "VillageNames";
        obsoleteConfigFolder = "VillageNamesOLD";
        versionChecker = new VersionChecker();
        haveWarnedVersionOutOfDate = false;
        devVersionWarned = false;
        numberStructuresArchaeologist = 7;
    }
}

