/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.common;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedVillager
implements IExtendedEntityProperties {
    public static final String VN_VILLAGER_TAGS = "VNExtendedVillager";
    public static final String careerKey = "Career";
    protected static final String InitializedKey = "Defined";
    private final EntityVillager villager;
    private int career;
    private Boolean hasValidData;
    protected World theWorld;

    public ExtendedVillager(EntityVillager villager) {
        this.villager = villager;
        this.career = -1;
    }

    public static final void register(EntityVillager villager) {
        villager.registerExtendedProperties(VN_VILLAGER_TAGS, (IExtendedEntityProperties)new ExtendedVillager(villager));
    }

    public static final ExtendedVillager get(EntityVillager villager) {
        return (ExtendedVillager)villager.getExtendedProperties(VN_VILLAGER_TAGS);
    }

    public int getCareer() {
        return this.career;
    }

    public void setCareer(int n) {
        this.career = n;
        this.hasValidData = true;
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (this.hasValidData == null) {
            this.career = -1;
            this.hasValidData = false;
        }
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a(careerKey, this.career);
        properties.func_74757_a(InitializedKey, this.hasValidData.booleanValue());
        compound.func_74782_a(VN_VILLAGER_TAGS, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(VN_VILLAGER_TAGS);
        if (properties == null) {
            this.hasValidData = false;
            this.career = -1;
        } else {
            this.career = properties.func_74762_e(careerKey);
            this.hasValidData = properties.func_74767_n(InitializedKey);
        }
    }

    public void init(Entity entity, World world) {
        this.theWorld = world;
    }

    public static int pickRandomCareer(Random random, int profession) {
        switch (profession) {
            case 0: {
                return 1 + random.nextInt(4);
            }
            case 1: {
                return 1 + random.nextInt(2);
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1 + random.nextInt(3);
            }
            case 4: {
                return 1 + random.nextInt(2);
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }
}

