/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedVillagerZombie
implements IExtendedEntityProperties {
    public static final String Identifier = "VillagerInfo";
    protected static final String ProfessionKey = "Profession";
    protected static final String CareerKey = "Career";
    protected static final String InitializedKey = "Defined";
    private final EntityZombie zombieWoof;
    protected World myWorld;
    private int profession;
    private int career;
    private Boolean hasValidData;

    public int getProfession() {
        return this.profession;
    }

    public int getCareer() {
        return this.career;
    }

    public void setProfession(int profession) {
        this.profession = profession >= 0 ? profession : -1;
        this.hasValidData = true;
    }

    public void setCareer(int career) {
        this.career = career >= 0 ? career : -1;
        this.hasValidData = true;
    }

    public void pickRandomProfession() {
        if (!(this.profession > -1 || this.hasValidData != null && this.hasValidData.booleanValue())) {
            int p = this.myWorld.field_73012_v.nextInt(6);
            this.setProfession(p);
        }
    }

    public void pickRandomProfessionAndCareer() {
        if (!(this.profession > -1 || this.career > -1 || this.hasValidData != null && this.hasValidData.booleanValue())) {
            int p = this.myWorld.field_73012_v.nextInt(6);
            int c = -1;
            switch (p) {
                case 0: {
                    c = 1 + this.myWorld.field_73012_v.nextInt(4);
                }
                case 1: {
                    c = 1 + this.myWorld.field_73012_v.nextInt(2);
                }
                case 2: {
                    c = 1;
                }
                case 3: {
                    c = 1 + this.myWorld.field_73012_v.nextInt(3);
                }
                case 4: {
                    c = 1 + this.myWorld.field_73012_v.nextInt(2);
                }
                case 5: {
                    c = 1;
                }
            }
            this.setProfession(p);
            this.setCareer(c);
        }
    }

    public ExtendedVillagerZombie(EntityZombie zombie) {
        this.zombieWoof = zombie;
        this.profession = -1;
        this.career = -1;
        this.hasValidData = false;
    }

    public static final void register(EntityZombie zombie) {
        zombie.registerExtendedProperties(Identifier, (IExtendedEntityProperties)new ExtendedVillagerZombie(zombie));
    }

    public static final ExtendedVillagerZombie get(EntityZombie zombie) {
        return (ExtendedVillagerZombie)zombie.getExtendedProperties(Identifier);
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (this.hasValidData == null) {
            this.profession = -1;
            this.career = -1;
            this.hasValidData = false;
        }
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a(ProfessionKey, this.profession);
        properties.func_74768_a(CareerKey, this.career);
        properties.func_74757_a(InitializedKey, this.hasValidData.booleanValue());
        compound.func_74782_a(Identifier, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(Identifier);
        if (properties == null) {
            this.hasValidData = false;
            this.profession = -1;
            this.career = -1;
        } else {
            this.profession = properties.func_74762_e(ProfessionKey);
            this.career = properties.func_74762_e(CareerKey);
            this.hasValidData = properties.func_74767_n(InitializedKey);
        }
    }

    public void init(Entity entity, World world) {
        this.myWorld = world;
    }
}

