/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.common.ExtendedVillageGuard;
import astrotibs.villagenames.common.ExtendedVillager;
import astrotibs.villagenames.common.ExtendedVillagerZombie;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.handler.AchievementReward;
import astrotibs.villagenames.handler.EntityInteractHandler;
import astrotibs.villagenames.handler.ReputationHandler;
import astrotibs.villagenames.handler.VillagerTradeHandler;
import astrotibs.villagenames.network.NetworkHelper;
import astrotibs.villagenames.prismarine.minecraft.Vec3i;
import astrotibs.villagenames.tracker.ClientInfoTracker;
import astrotibs.villagenames.tracker.EventTracker;
import astrotibs.villagenames.tracker.ServerInfoTracker;
import astrotibs.villagenames.utility.GenericHelper;
import astrotibs.villagenames.utility.LogHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EntityMonitorHandler {
    protected static int tickRate = 50;
    protected final int failuresToForceAcceptance = 100;

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entity instanceof EntityVillager && GenericHelper.isVanillaZombie(event.source.func_76346_g())) {
            EntityVillager villager = (EntityVillager)event.entity;
            ServerInfoTracker.add(villager);
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("EntityMonitorHandler > A zombie just killed villager " + (villager.func_94057_bL().equals("") || villager.func_94057_bL().equals(null) ? "(None)" : villager.func_94057_bL()) + " [" + villager.func_145782_y() + "] at [" + new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v) + "], profession [" + villager.func_70946_n() + "]");
            }
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        EntityLiving guard;
        Object properties;
        EntityZombie zombie;
        if (GenericHelper.isVanillaZombie(event.target) && !event.entity.field_70170_p.field_72995_K && (zombie = (EntityZombie)event.target).func_82231_m() && (properties = ExtendedVillagerZombie.get(zombie)) != null) {
            NetworkHelper.sendVillagerProfessionMessage(zombie.func_145782_y(), properties, event.entityPlayer);
        }
        if (event.entity.getClass().toString().substring(6).equals("com.emoniph.witchery.entity.EntityVillageGuard") && !event.entity.field_70170_p.field_72995_K && (properties = ExtendedVillageGuard.get(guard = (EntityLiving)event.target)) != null) {
            NetworkHelper.sendVillageGuardMessage(guard.func_145782_y(), (ExtendedVillageGuard)properties, event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (GeneralConfigHandler.zombieVillagerSkins && GenericHelper.isVanillaZombie(event.entity)) {
            EntityZombie zombie = (EntityZombie)event.entity;
            if (event.world.field_72995_K) {
                ClientInfoTracker.SyncZombieMessage(zombie);
            } else if (zombie.func_82231_m()) {
                EventTracker tracked = ServerInfoTracker.seek(ServerInfoTracker.EventType.VILLAGER, new Vec3i(zombie.field_70165_t, zombie.field_70163_u + 0.5, zombie.field_70161_v));
                ExtendedVillagerZombie properties = ExtendedVillagerZombie.get(zombie);
                if (tracked != null) {
                    if (GeneralConfigHandler.debugMessages) {
                        LogHelper.info("EntityMonitorHandler > Found info on the tracker--must copy to zombie");
                    }
                    tracked.updateZombie(event, properties);
                } else {
                    if (GeneralConfigHandler.debugMessages) {
                        LogHelper.info("EntityMonitorHandler > No info on the tracker--assigning a random profession");
                    }
                    if (GeneralConfigHandler.villagerCareers) {
                        properties.pickRandomProfessionAndCareer();
                    } else {
                        properties.pickRandomProfession();
                    }
                }
                if (GeneralConfigHandler.debugMessages) {
                    LogHelper.info("EntityMonitorHandler > Custom name [" + zombie.func_94057_bL() + "]");
                    LogHelper.info("EntityMonitorHandler > Profession [" + properties.getProfession() + "]");
                    if (GeneralConfigHandler.villagerCareers) {
                        LogHelper.info("EntityMonitorHandler > Career [" + properties.getCareer() + "]");
                    }
                }
            }
        } else if (event.entity instanceof EntityVillager && !event.world.field_72995_K) {
            EntityVillager villager = (EntityVillager)event.entity;
            EventTracker tracked = ServerInfoTracker.seek(ServerInfoTracker.EventType.ZOMBIE, new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v));
            if (tracked != null) {
                if (GeneralConfigHandler.debugMessages) {
                    LogHelper.info("EntityMonitorHandler > Found info on the tracker--must copy to villager");
                }
                tracked.updateVillager(villager);
                ServerInfoTracker.endedCuringZombie(tracked.getEntityID(), villager.func_145782_y());
                ServerInfoTracker.removeCuredZombiesFromTracker(event.world, tracked.getEntityID());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        block48: {
            block51: {
                block54: {
                    block53: {
                        block52: {
                            block49: {
                                block50: {
                                    block47: {
                                        if (!GenericHelper.isVanillaZombie(event.entity)) break block47;
                                        zombie = (EntityZombie)event.entity;
                                        if (zombie.field_70170_p.field_72995_K || !zombie.func_82230_o()) break block48;
                                        checkfactor = 10.0;
                                        vanillaRollbackTicks = 0;
                                        if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < 0.009999999776482582 * checkfactor) {
                                            countedBedsOrBars = 0;
                                            for (k = (int)zombie.field_70165_t - 4; k < (int)zombie.field_70165_t + 4 && countedBedsOrBars < 14; ++k) {
                                                for (l = (int)zombie.field_70163_u - 4; l < (int)zombie.field_70163_u + 4 && countedBedsOrBars < 14; ++l) {
                                                    for (i1 = (int)zombie.field_70161_v - 4; i1 < (int)zombie.field_70161_v + 4 && countedBedsOrBars < 14; ++i1) {
                                                        block = zombie.field_70170_p.func_147439_a(k, l, i1);
                                                        if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                                                        if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < 0.30000001192092896 / checkfactor) {
                                                            --vanillaRollbackTicks;
                                                        }
                                                        ++countedBedsOrBars;
                                                    }
                                                }
                                            }
                                        }
                                        zombieCureCatalysts = GeneralConfigHandler.unpackZombieCureCatalysts(GeneralConfigHandler.zombieCureCatalysts);
                                        zombieCureGroups = GeneralConfigHandler.unpackZombieCureGroups(GeneralConfigHandler.zombieCureGroups);
                                        modTickAdjustment = 0;
                                        if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < 0.009999999776482582 * checkfactor) {
                                            for (groupi = 0; groupi < zombieCureGroups.get("Groups").size(); ++groupi) {
                                                group = (String)zombieCureGroups.get("Groups").get(groupi);
                                                groupLimit = (Integer)zombieCureGroups.get("Limits").get(groupi);
                                                groupSpeedup = (Double)zombieCureGroups.get("Speedups").get(groupi) / checkfactor;
                                                speedupSign = groupSpeedup < 0.0 ? -1 : 1;
                                                groupSpeedup = Math.abs(groupSpeedup);
                                                countedGroupBlocks = 0;
                                                for (k = (int)zombie.field_70165_t - 4; k < (int)zombie.field_70165_t + 4 && countedGroupBlocks < groupLimit; ++k) {
                                                    for (l = (int)zombie.field_70163_u - 4; l < (int)zombie.field_70163_u + 4 && countedGroupBlocks < groupLimit; ++l) {
                                                        block20: for (i1 = (int)zombie.field_70161_v - 4; i1 < (int)zombie.field_70161_v + 4 && countedGroupBlocks < groupLimit; ++i1) {
                                                            block = zombie.field_70170_p.func_147439_a(k, l, i1);
                                                            blockmeta = zombie.field_70170_p.func_72805_g(k, l, i1);
                                                            blockClassPath = block.getClass().toString().substring(6);
                                                            blockUnlocName = block.func_149739_a();
                                                            for (blocki = 0; blocki < zombieCureCatalysts.get("Groups").size(); ++blocki) {
                                                                catalystGroup = (String)zombieCureCatalysts.get("Groups").get(blocki);
                                                                catalystClassPath = (String)zombieCureCatalysts.get("ClassPaths").get(blocki);
                                                                catalystUnlocName = (String)zombieCureCatalysts.get("UnlocNames").get(blocki);
                                                                catalystMeta = (Integer)zombieCureCatalysts.get("Metas").get(blocki);
                                                                if (!catalystGroup.equals(group) || !catalystClassPath.equals(blockClassPath) || !catalystUnlocName.equals("") && !catalystUnlocName.equals(blockUnlocName) || catalystMeta != -1 && blockmeta != catalystMeta) continue;
                                                                i = 1;
                                                                while ((double)i < groupSpeedup) {
                                                                    modTickAdjustment += speedupSign;
                                                                    ++i;
                                                                }
                                                                if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < groupSpeedup % 1.0) {
                                                                    modTickAdjustment += speedupSign;
                                                                }
                                                                ++countedGroupBlocks;
                                                                continue block20;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        conversionTime = 0;
                                        try {
                                            conversionTime = (Integer)ReflectionHelper.getPrivateValue(EntityZombie.class, (Object)((EntityZombie)event.entity), (String[])new String[]{"conversionTime", "field_82234_d"});
                                            conversionTime -= vanillaRollbackTicks + modTickAdjustment;
                                            conversionTime = Math.min(conversionTime, 6000);
                                            ReflectionHelper.setPrivateValue(EntityZombie.class, (Object)((EntityZombie)event.entity), (Object)conversionTime, (String[])new String[]{"conversionTime", "field_82234_d"});
                                        }
                                        catch (Exception group) {
                                            // empty catch block
                                        }
                                        getConversionTimeBoost_m = ReflectionHelper.findMethod(EntityZombie.class, (Object)((EntityZombie)event.entity), (String[])new String[]{"getConversionTimeBoost", "func_82233_q"}, (Class[])new Class[0]);
                                        getConversionTimeBoost = 0;
                                        try {
                                            getConversionTimeBoost = (Integer)getConversionTimeBoost_m.invoke((Object)((EntityZombie)event.entity), new Object[0]);
                                        }
                                        catch (Exception groupSpeedup) {
                                            // empty catch block
                                        }
                                        nextConversionTime = conversionTime - getConversionTimeBoost;
                                        if (GeneralConfigHandler.debugMessages && nextConversionTime <= 500 && nextConversionTime % 20 == 0) {
                                            LogHelper.info("EntityMonitorHandler > Zombie [" + zombie.func_145782_y() + "] being cured in " + conversionTime + " ticks");
                                        }
                                        if (nextConversionTime <= 0 && conversionTime > 0) {
                                            if (GeneralConfigHandler.debugMessages) {
                                                LogHelper.info("EntityMonitorHandler > Zombie " + zombie.toString() + " is about to be cured in tick " + MinecraftServer.func_71276_C().func_71259_af());
                                            }
                                            ServerInfoTracker.add(zombie);
                                        }
                                        break block48;
                                    }
                                    if (!Loader.isModLoaded((String)"witchery") || !(event.entity instanceof EntityLiving) || !event.entity.getClass().toString().substring(6).equals("com.emoniph.witchery.entity.EntityVillageGuard") || ServerInfoTracker.EventType.GUARD.getTracker().size() <= 0) break block49;
                                    guard = (EntityLiving)event.entity;
                                    if (!event.entity.field_70170_p.field_72995_K) break block50;
                                    ClientInfoTracker.SyncGuardMessage(guard);
                                    break block48;
                                }
                                tracked = ServerInfoTracker.seek(ServerInfoTracker.EventType.GUARD, new Vec3i(guard.field_70165_t, guard.field_70163_u + 0.5, guard.field_70161_v));
                                properties = ExtendedVillageGuard.get(guard);
                                if (tracked == null) break block48;
                                if (GeneralConfigHandler.debugMessages) {
                                    LogHelper.info("EntityMonitorHandler > Found villager info on the tracker--must copy to guard");
                                }
                                tracked.updateGuard(event, properties);
                                break block48;
                            }
                            if (!(event.entity instanceof EntityVillager) || event.entity.field_70170_p.field_72995_K) break block51;
                            villager = (EntityVillager)event.entity;
                            if (!GeneralConfigHandler.villagerCareers || villager.func_70946_n() < 0 || villager.func_70946_n() > 4) break block48;
                            profession = villager.func_70946_n();
                            career = ExtendedVillager.get(villager).getCareer();
                            buyingList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"buyingList", "field_70963_i"});
                            if (career <= 0) {
                                career = ExtendedVillager.pickRandomCareer(villager.field_70170_p.field_73012_v, villager.func_70946_n());
                                ExtendedVillager.get(villager).setCareer(career);
                            }
                            block23: do {
                                addDefaultEquipmentAndRecipies_m = ReflectionHelper.findMethod(EntityVillager.class, (Object)villager, (String[])new String[]{"addDefaultEquipmentAndRecipies", "func_70950_c"}, (Class[])new Class[]{Integer.TYPE});
                                mulliganTrades = 0;
                                while ((buyingList == null ? 0 : buyingList.size()) <= 0) {
                                    try {
                                        addDefaultEquipmentAndRecipies_m.invoke((Object)villager, new Object[]{1});
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalArgumentException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                    buyingList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"buyingList", "field_70963_i"});
                                    if (++mulliganTrades < 100) continue;
                                }
                                listSizeBeforeCulling = buyingList.size();
                                mulliganTrades = 0;
                                while (true) {
                                    for (i = buyingList.size() - 1; i >= 0; --i) {
                                        merchantrecipe = (MerchantRecipe)buyingList.get(i);
                                        if (!VillagerTradeHandler.isTradeInappropriate(merchantrecipe, profession, career, i + 1)) continue;
                                        buyingList.remove(i);
                                    }
                                    if (buyingList.size() == listSizeBeforeCulling) continue block23;
                                    ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)buyingList, (String[])new String[]{"buyingList", "field_70963_i"});
                                    if (mulliganTrades >= 100) {
                                        if (GeneralConfigHandler.debugMessages) {
                                            LogHelper.info("Infinite loop suspected while generating villager trades. Capping at " + buyingList.size() + " trades");
                                        }
                                        if (profession != 1 || career != 1 || buyingList == null || buyingList.size() != 0 && buyingList.size() != 3 && buyingList.size() != 4) continue block23;
                                        enchantment = Enchantment.field_92090_c[villager.field_70170_p.field_73012_v.nextInt(Enchantment.field_92090_c.length)];
                                        i1 = MathHelper.func_76136_a((Random)villager.field_70170_p.field_73012_v, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
                                        buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(5 + i1 * 10) + 3 * i1, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, i1))));
                                        ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)buyingList, (String[])new String[]{"buyingList", "field_70963_i"});
                                        continue block23;
                                    }
                                    if (buyingList.size() >= listSizeBeforeCulling) ** continue;
                                    try {
                                        addDefaultEquipmentAndRecipies_m.invoke((Object)villager, new Object[]{1});
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalArgumentException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                    ++mulliganTrades;
                                    buyingList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"buyingList", "field_70963_i"});
                                }
                            } while (buyingList.size() != listSizeBeforeCulling);
                            if ((buyingList == null ? 0 : buyingList.size()) > 0) break block52;
                            buyingList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151043_k, 8 + villager.field_70170_p.field_73012_v.nextInt(3)), new ItemStack(Items.field_151166_bC, 1)));
                            ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)buyingList, (String[])new String[]{"buyingList", "field_70963_i"});
                            break block48;
                        }
                        if (profession != 0 || career != 3 || buyingList == null || buyingList.size() > 16 || !((MerchantRecipe)buyingList.get(buyingList.size() - 1)).func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1)))) break block53;
                        buyingList.remove(buyingList.size() - 1);
                        for (i = 0; i < 16; ++i) {
                            buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1 + villager.field_70170_p.field_73012_v.nextInt(2)), new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, i)));
                        }
                        ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)buyingList, (String[])new String[]{"buyingList", "field_70963_i"});
                        break block48;
                    }
                    if (profession != 3) break block54;
                    for (i = buyingList.size() - 1; i >= 0; --i) {
                        merchantrecipe = (MerchantRecipe)buyingList.get(i);
                        itemToCheck = merchantrecipe.func_77397_d();
                        if (itemToCheck.func_77948_v() || !(career == 1 && itemToCheck.func_77969_a(new ItemStack((Item)Items.field_151163_ad)) != false || career == 2 && itemToCheck.func_77969_a(new ItemStack(Items.field_151040_l)) != false || career == 2 && itemToCheck.func_77969_a(new ItemStack(Items.field_151048_u)) != false || career == 2 && itemToCheck.func_77969_a(new ItemStack(Items.field_151056_x)) != false || career == 3 && itemToCheck.func_77969_a(new ItemStack(Items.field_151037_a)) != false || career == 3 && itemToCheck.func_77969_a(new ItemStack(Items.field_151035_b)) != false) && (career != 3 || !itemToCheck.func_77969_a(new ItemStack(Items.field_151046_w)))) continue;
                        emeraldPrice = merchantrecipe.func_77394_a();
                        itemToCheck = EnchantmentHelper.func_77504_a((Random)villager.field_70170_p.field_73012_v, (ItemStack)itemToCheck, (int)(5 + villager.field_70170_p.field_73012_v.nextInt(15)));
                        buyingList.set(i, (Object)new MerchantRecipe(emeraldPrice, itemToCheck));
                    }
                    break block48;
                }
                if (profession != 4 || career != 2) break block48;
                alis = new ArrayList<ItemStack>();
                alis.add(new ItemStack((Item)Items.field_151027_R));
                alis.add(new ItemStack((Item)Items.field_151021_T));
                alis.add(new ItemStack((Item)Items.field_151024_Q));
                alis.add(new ItemStack((Item)Items.field_151026_S));
                for (j = 0; j < 4; ++j) {
                    for (i = buyingList.size() - 1; i >= 0; --i) {
                        merchantrecipe = (MerchantRecipe)buyingList.get(i);
                        itemToCheck = merchantrecipe.func_77397_d();
                        if (itemToCheck.func_77948_v() || !itemToCheck.func_77969_a((ItemStack)alis.get(j))) continue;
                        itemToCheck = EnchantmentHelper.func_77504_a((Random)villager.field_70170_p.field_73012_v, (ItemStack)itemToCheck, (int)(5 + villager.field_70170_p.field_73012_v.nextInt(15)));
                        emeraldPrice = new ItemStack(Items.field_151166_bC, (new int[]{7, 4, 5, 5})[j] + villager.field_70170_p.field_73012_v.nextInt((new int[]{6, 5, 5, 6})[j]));
                        buyingList.set(i, (Object)new MerchantRecipe(emeraldPrice, itemToCheck));
                    }
                }
                break block48;
            }
            if (!(event.entity instanceof EntityPlayerMP) || event.entity.field_70170_p.field_72995_K || event.entity.field_71093_bK != 0 || event.entity.field_70173_aa % EntityMonitorHandler.tickRate != 0) break block48;
            player = (EntityPlayerMP)event.entity;
            world = player.field_70170_p;
            try {
                villageTopTagPlayerIsIn = ReputationHandler.getVillageTagPlayerIsIn(player);
                villageObjPlayerIsIn = world.field_72982_D.func_75550_a((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, EntityInteractHandler.villageRadiusBuffer);
                if (!villageTopTagPlayerIsIn.equals("none") || villageObjPlayerIsIn != null) {
                    playerRep = ReputationHandler.getVNReputationForPlayer(player, villageTopTagPlayerIsIn, villageObjPlayerIsIn);
                    if (playerRep <= -30 && !player.func_147099_x().func_77443_a(VillageNames.minrep)) {
                        player.func_71029_a((StatBase)VillageNames.minrep);
                        AchievementReward.allFiveAchievements(player);
                    } else if (playerRep >= 10 && !player.func_147099_x().func_77443_a(VillageNames.maxrep)) {
                        player.func_71029_a((StatBase)VillageNames.maxrep);
                        AchievementReward.allFiveAchievements(player);
                    }
                    if (EntityMonitorHandler.tickRate < 50) {
                        EntityMonitorHandler.tickRate += 2;
                    }
                    if (EntityMonitorHandler.tickRate <= 50) ** GOTO lbl237
                    EntityMonitorHandler.tickRate = 50;
                }
                EntityMonitorHandler.tickRate = 100;
            }
            catch (Exception var4_70) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        EntityLiving guard;
        if (GenericHelper.isVanillaZombie(event.entity) && ExtendedVillagerZombie.get((EntityZombie)event.entity) == null) {
            ExtendedVillagerZombie.register((EntityZombie)event.entity);
        } else if (event.entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)event.entity;
            if (GeneralConfigHandler.villagerCareers && ExtendedVillager.get(villager) == null) {
                ExtendedVillager.register(villager);
            }
        } else if (Loader.isModLoaded((String)"witchery") && event.entity.getClass().toString().substring(6).equals("com.emoniph.witchery.entity.EntityVillageGuard") && ExtendedVillageGuard.get(guard = (EntityLiving)event.entity) == null) {
            ExtendedVillageGuard.register(guard);
        }
    }
}

