/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.village.Village;
import net.minecraft.world.gen.structure.MapGenStructureData;

public class ReputationHandler {
    private static final String collectedKey = "VNCollected";
    private static final String repKey = "VNRep";

    public static int getVNReputationForPlayer(EntityPlayerMP player, String villageTopTag, Village village) {
        MapGenStructureData structureData = (MapGenStructureData)player.field_70170_p.perWorldStorage.func_75742_a(MapGenStructureData.class, "Village");
        NBTTagCompound nbttagcompound = structureData.func_143041_a();
        NBTBase nbtbase = nbttagcompound.func_74781_a(villageTopTag);
        NBTTagCompound villageTag = (NBTTagCompound)nbtbase;
        NBTTagCompound playerReps = new NBTTagCompound();
        int VNPlayerRep = 0;
        boolean returnDefaultRep = false;
        if (villageTag != null) {
            if (villageTag.func_74764_b(repKey)) {
                playerReps = (NBTTagCompound)villageTag.func_74781_a(repKey);
                if (playerReps.func_74764_b(player.func_110124_au().toString())) {
                    int PrevVNPlayerRep = playerReps.func_74762_e(player.func_110124_au().toString());
                    if (village == null) {
                        VNPlayerRep = PrevVNPlayerRep;
                    } else {
                        int collectionRep = village.func_82684_a(player.getDisplayName());
                        if (PrevVNPlayerRep == collectionRep) {
                            VNPlayerRep = PrevVNPlayerRep;
                        } else if (villageTag.func_74767_n(collectedKey)) {
                            VNPlayerRep = collectionRep;
                            if (GeneralConfigHandler.debugMessages) {
                                LogHelper.info("There was a reputation mismatch. We assume villageCollectionObj was correct: " + VNPlayerRep);
                            }
                        } else {
                            village.func_82688_a(player.getDisplayName(), PrevVNPlayerRep);
                            VNPlayerRep = PrevVNPlayerRep;
                            if (GeneralConfigHandler.debugMessages) {
                                LogHelper.info("There was a reputation mismatch. We assume VN's was correct: " + VNPlayerRep);
                            }
                        }
                    }
                } else {
                    returnDefaultRep = true;
                }
            } else {
                returnDefaultRep = true;
            }
            if (returnDefaultRep && village != null) {
                VNPlayerRep = village.func_82684_a(player.getDisplayName());
                if (GeneralConfigHandler.debugMessages) {
                    LogHelper.info("You have no recorded VN rep in this town. It is now set to " + VNPlayerRep);
                }
            }
            villageTag.func_74782_a(repKey, (NBTBase)playerReps);
            villageTag.func_74757_a(collectedKey, village != null);
            playerReps.func_74768_a(player.func_110124_au().toString(), VNPlayerRep);
            structureData.func_76185_a();
            return VNPlayerRep;
        }
        int nullVillageTagRep = 0;
        try {
            nullVillageTagRep = village.func_82684_a(player.getDisplayName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nullVillageTagRep;
    }

    public static String getVillageTagPlayerIsIn(EntityPlayerMP player) {
        MapGenStructureData structureData = (MapGenStructureData)player.field_70170_p.perWorldStorage.func_75742_a(MapGenStructureData.class, "Village");
        NBTTagCompound nbttagcompound = structureData.func_143041_a();
        for (Object entry : nbttagcompound.func_150296_c()) {
            NBTTagCompound villageTag;
            NBTBase nbtbase = nbttagcompound.func_74781_a(entry.toString());
            if (nbtbase.func_74732_a() != 10 || !(villageTag = (NBTTagCompound)nbtbase).func_74767_n("Valid")) continue;
            int[] boundingBox = villageTag.func_74759_k("BB");
            int posX = (int)player.field_70165_t;
            int posY = (int)player.field_70163_u;
            int posZ = (int)player.field_70161_v;
            if (posX < boundingBox[0] || posY < boundingBox[1] || posZ < boundingBox[2] || posX > boundingBox[3] || posY > boundingBox[4] || posZ > boundingBox[5]) continue;
            return entry.toString();
        }
        return "none";
    }
}

