/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.IOUtils;

public class VersionChecker
implements Runnable {
    private static boolean isLatestVersion = false;
    private static String latestVersion = "";

    @Override
    public void run() {
        InputStream in = null;
        try {
            in = new URL("https://www.dropbox.com/s/ww32gqcftjgnl7n/latestversion_1.7.10.txt?dl=1").openStream();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            latestVersion = (String)IOUtils.readLines((InputStream)in).get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        isLatestVersion = "3.0".equals(latestVersion);
        if (!(this.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null))) {
            LogHelper.info("This version of Village Names (3.0) differs from the latest version: " + latestVersion);
        }
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getLatestVersion() {
        return latestVersion;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            if (!(VillageNames.haveWarnedVersionOutOfDate || !GeneralConfigHandler.versionChecker || VillageNames.versionChecker.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null) || "3.0".contains("DEV"))) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Village Names" + EnumChatFormatting.RESET + " version " + EnumChatFormatting.YELLOW + this.getLatestVersion() + EnumChatFormatting.RESET + " is available! Get it at:"));
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "minecraft.curseforge.com/projects/village-names" + EnumChatFormatting.RESET));
            }
            VillageNames.haveWarnedVersionOutOfDate = true;
        }
    }
}

