/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.common.ExtendedVillager;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.item.ModItems;
import astrotibs.villagenames.name.NameGenerator;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class VillagerTradeHandler
implements VillagerRegistry.IVillageTradeHandler {
    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        int profession = villager.func_70946_n();
        int career = ExtendedVillager.get(villager).getCareer();
        MerchantRecipeList buyingList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"buyingList", "field_70963_i"});
        int nextSlotToFill = (buyingList == null ? 0 : buyingList.size()) + 1;
        switch (profession) {
            case 0: {
                switch (career) {
                    case 1: {
                        if (nextSlotToFill == 1 || nextSlotToFill > 4) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151174_bG, 15 + random.nextInt(5)), new ItemStack(Items.field_151166_bC, 1)));
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151172_bF, 15 + random.nextInt(5)), new ItemStack(Items.field_151166_bC, 1)));
                        }
                        if (nextSlotToFill == 2 || nextSlotToFill > 4) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150423_aK), 8 + random.nextInt(6)), new ItemStack(Items.field_151166_bC, 1)));
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151158_bO, 2 + random.nextInt(2))));
                        }
                        if (nextSlotToFill == 3 || nextSlotToFill > 4) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150440_ba), 7 + random.nextInt(6)), new ItemStack(Items.field_151166_bC, 1)));
                        }
                        if (nextSlotToFill < 4) break;
                        recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151105_aU, 1)));
                        break;
                    }
                    case 2: {
                        if (nextSlotToFill == 1 || nextSlotToFill > 2) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151007_F, 15 + random.nextInt(6)), new ItemStack(Items.field_151166_bC, 1)));
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151044_h, 16 + random.nextInt(9)), new ItemStack(Items.field_151166_bC, 1)));
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151115_aP, 6), new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151101_aQ, 6)));
                        }
                        if (nextSlotToFill < 2) break;
                        recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 7 + random.nextInt(2)), EnchantmentHelper.func_77504_a((Random)random, (ItemStack)new ItemStack((Item)Items.field_151112_aM, 1, 0), (int)(5 + random.nextInt(15)))));
                        break;
                    }
                    case 3: {
                        if (nextSlotToFill < 2) break;
                        recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1 + random.nextInt(2)), new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, random.nextInt(16))));
                        break;
                    }
                    case 4: {
                        if (nextSlotToFill == 1 || nextSlotToFill > 2) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151007_F, 15 + random.nextInt(6)), new ItemStack(Items.field_151166_bC, 1)));
                        }
                        if (nextSlotToFill < 2) break;
                        recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 2 + random.nextInt(2)), new ItemStack((Item)Items.field_151031_f, 1)));
                    }
                }
                break;
            }
            case 1: {
                switch (career) {
                    case 1: {
                        if (nextSlotToFill == 1 || nextSlotToFill == 4 || nextSlotToFill == 5 || nextSlotToFill > 6) {
                            float adjustedProb = 0.07f + (buyingList == null ? 0.0f : MathHelper.func_76129_c((float)buyingList.size()) * 0.2f);
                            float f = adjustedProb = adjustedProb > 0.9f ? 0.9f - (adjustedProb - 0.9f) : adjustedProb;
                            if (villager.field_70170_p.field_73012_v.nextFloat() < adjustedProb) {
                                Enchantment enchantment = Enchantment.field_92090_c[villager.field_70170_p.field_73012_v.nextInt(Enchantment.field_92090_c.length)];
                                int i1 = MathHelper.func_76136_a((Random)villager.field_70170_p.field_73012_v, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
                                recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(5 + i1 * 10) + 3 * i1, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, i1))));
                            }
                        }
                        if (nextSlotToFill >= 6) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 20 + random.nextInt(3)), new ItemStack(Items.field_151057_cb, 1)));
                        }
                        if (nextSlotToFill >= 7) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 20 + random.nextInt(3)), new ItemStack(Items.field_151057_cb, 1)));
                        }
                        if (nextSlotToFill < 8 || !GeneralConfigHandler.treasureTrades) break;
                        int enchantLevel = 1;
                        enchantLevel = 4 + villager.field_70170_p.field_73012_v.nextInt(2);
                        MerchantRecipe mineshaftForEnchantBook = new MerchantRecipe(new ItemStack((Item)ModItems.mineshaftBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77349_p, enchantLevel)));
                        recipeList.add((Object)mineshaftForEnchantBook);
                        enchantLevel = 3;
                        MerchantRecipe mineshaftForFortuneBook = new MerchantRecipe(new ItemStack((Item)ModItems.mineshaftBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77346_s, enchantLevel)));
                        recipeList.add((Object)mineshaftForFortuneBook);
                        enchantLevel = 1;
                        MerchantRecipe strongholdForInfinity = new MerchantRecipe(new ItemStack((Item)ModItems.strongholdBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77342_w, enchantLevel)));
                        recipeList.add((Object)strongholdForInfinity);
                        enchantLevel = 3 + villager.field_70170_p.field_73012_v.nextInt(2);
                        MerchantRecipe fortressForFeatherBook = new MerchantRecipe(new ItemStack((Item)ModItems.fortressBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77330_e, enchantLevel)));
                        recipeList.add((Object)fortressForFeatherBook);
                        if (GeneralConfigHandler.addOceanMonuments) {
                            enchantLevel = 1;
                            MerchantRecipe monumentForAquaBook = new MerchantRecipe(new ItemStack((Item)ModItems.monumentBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77341_i, enchantLevel)));
                            recipeList.add((Object)monumentForAquaBook);
                        }
                        enchantLevel = 4 + villager.field_70170_p.field_73012_v.nextInt(2);
                        MerchantRecipe jungleTempleForBaneBook = new MerchantRecipe(new ItemStack((Item)ModItems.jungletempleBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77336_l, enchantLevel)));
                        recipeList.add((Object)jungleTempleForBaneBook);
                        enchantLevel = 3 + villager.field_70170_p.field_73012_v.nextInt(2);
                        MerchantRecipe desertPyramidForBlastProtectionBook = new MerchantRecipe(new ItemStack((Item)ModItems.desertpyramidBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77327_f, enchantLevel)));
                        recipeList.add((Object)desertPyramidForBlastProtectionBook);
                        enchantLevel = 4 + villager.field_70170_p.field_73012_v.nextInt(2);
                        MerchantRecipe desertPyramidForSmiteBook = new MerchantRecipe(new ItemStack((Item)ModItems.desertpyramidBook, 1), new ItemStack(Items.field_151166_bC, Math.min(villager.field_70170_p.field_73012_v.nextInt(1 + enchantLevel * 9) + 3 * enchantLevel, 64)), Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77339_k, enchantLevel)));
                        recipeList.add((Object)desertPyramidForSmiteBook);
                        String bookAuthor = villager.func_94057_bL();
                        String bookTitle = "Custom Structure Name";
                        switch (random.nextInt(16)) {
                            case 0: {
                                bookTitle = "Your Very Own Unique Location Name";
                                break;
                            }
                            case 1: {
                                bookTitle = "A Random Nonsense Gobbledygook Name";
                                break;
                            }
                            case 2: {
                                bookTitle = "How To Name Things And Influence People";
                                break;
                            }
                            case 3: {
                                bookTitle = "Deed To A Place That Doesn't Exist";
                                break;
                            }
                            case 4: {
                                bookTitle = "A Brand-New Structure Name";
                                break;
                            }
                            case 5: {
                                bookTitle = "A New Structure Name For You!";
                                break;
                            }
                            case 6: {
                                bookTitle = "Naming Things For Dummies";
                                break;
                            }
                            case 7: {
                                bookTitle = "Naming Things And You";
                                break;
                            }
                            case 8: {
                                bookTitle = "Live, Laugh, Name, Love";
                                break;
                            }
                            case 9: {
                                bookTitle = "Markovian Name Generation";
                                break;
                            }
                            case 10: {
                                bookTitle = "A Tale Of One City Name";
                                break;
                            }
                            case 11: {
                                bookTitle = "The Case of the Un-Named Thing";
                                break;
                            }
                            case 12: {
                                bookTitle = "The Unnamed";
                                bookAuthor = "H.P. Lovenames";
                                break;
                            }
                            case 13: {
                                bookTitle = "Custom Structure Name";
                                break;
                            }
                            case 14: {
                                bookTitle = "Name Inspiration";
                                break;
                            }
                            case 15: {
                                bookTitle = "A One-Of-A-Kind Title";
                            }
                        }
                        String bookContents = "";
                        switch (random.nextInt(8)) {
                            case 0: {
                                bookContents = "If you've gone and built something grand, but don't know what name to give it--why not use this name:";
                                break;
                            }
                            case 1: {
                                bookContents = "Here's a custom-generated name for you to use, if you wish:";
                                break;
                            }
                            case 2: {
                                bookContents = "Coming up with names can be difficult. If you're drawing a blank, why not use this name:";
                                break;
                            }
                            case 3: {
                                bookContents = "Here's a unique name you can give to something if you need some inspiration:";
                                break;
                            }
                            case 4: {
                                bookContents = "Village Names uses a Markov chain to generate names for entities and structures. If you've built something and you want to use VN to generate a new name for it, you can use this one:";
                                bookAuthor = "AstroTibs";
                                break;
                            }
                            case 5: {
                                bookContents = "Feeling uninspired? Have writer's block? Feel free to use this customized location name:";
                                break;
                            }
                            case 6: {
                                bookContents = "Maybe you've just built or discovered something, and you're not sure what to name it. Why not name it this:";
                                break;
                            }
                            case 7: {
                                bookContents = "Coming up with a good, authentic location name can be hard. Well, this name might be neither good nor authentic, but maybe you'll use it anyway:";
                            }
                        }
                        String[] locationName = NameGenerator.newRandomName("village-mineshaft-stronghold-temple-fortress-monument-endcity-mansion-alienvillage");
                        bookContents = bookContents + "\n\n" + (locationName[1] + " " + locationName[2] + " " + locationName[3]).trim();
                        ItemStack bookWithName = new ItemStack(Items.field_151164_bB);
                        if (bookWithName.field_77990_d == null) {
                            bookWithName.func_77982_d(new NBTTagCompound());
                        }
                        bookWithName.field_77990_d.func_74778_a("title", bookTitle);
                        if (bookAuthor != null && !bookAuthor.equals("")) {
                            try {
                                bookWithName.field_77990_d.func_74778_a("author", bookAuthor.indexOf("(") != -1 ? bookAuthor.substring(0, bookAuthor.indexOf("(")).trim() : bookAuthor);
                            }
                            catch (Exception exception) {}
                        } else {
                            bookWithName.func_77978_p().func_74778_a("author", "");
                        }
                        NBTTagList pagesTag = new NBTTagList();
                        pagesTag.func_74742_a((NBTBase)new NBTTagString(bookContents));
                        bookWithName.field_77990_d.func_74782_a("pages", (NBTBase)pagesTag);
                        recipeList.add((Object)new MerchantRecipe(new ItemStack((Item)ModItems.villageBook, 1), bookWithName));
                        break;
                    }
                    case 2: {
                        if (nextSlotToFill == 2 || nextSlotToFill > 4) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151111_aL, 1), new ItemStack(Items.field_151166_bC, 1)));
                        }
                        if (nextSlotToFill == 3 || nextSlotToFill > 4) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 7 + random.nextInt(5)), new ItemStack((Item)Items.field_151148_bJ, 1)));
                        }
                        if (nextSlotToFill < 4 || !GeneralConfigHandler.treasureTrades) break;
                        MerchantRecipe strongholdForEnderEye = new MerchantRecipe(new ItemStack((Item)ModItems.strongholdBook, 1), new ItemStack(Items.field_151061_bv, 2));
                        recipeList.add((Object)strongholdForEnderEye);
                        MerchantRecipe fortressForFireResistance = new MerchantRecipe(new ItemStack((Item)ModItems.fortressBook, 1), new ItemStack((Item)Items.field_151068_bn, 1, 8259));
                        recipeList.add((Object)fortressForFireResistance);
                        MerchantRecipe swampHutForHarmingPotion = new MerchantRecipe(new ItemStack((Item)ModItems.swamphutBook, 1), new ItemStack((Item)Items.field_151068_bn, 1, 16428));
                        recipeList.add((Object)swampHutForHarmingPotion);
                        MerchantRecipe swampHutForHealingPotion = new MerchantRecipe(new ItemStack((Item)ModItems.swamphutBook, 1), new ItemStack((Item)Items.field_151068_bn, 1, 8229));
                        recipeList.add((Object)swampHutForHealingPotion);
                        if (GeneralConfigHandler.addOceanMonuments) {
                            MerchantRecipe monumentForWaterBreathing = new MerchantRecipe(new ItemStack((Item)ModItems.monumentBook, 1), new ItemStack((Item)Items.field_151068_bn, 1, 8269));
                            recipeList.add((Object)monumentForWaterBreathing);
                        }
                        MerchantRecipe jungleTempleForStrength = new MerchantRecipe(new ItemStack((Item)ModItems.jungletempleBook, 1), new ItemStack((Item)Items.field_151068_bn, 1, 8233));
                        recipeList.add((Object)jungleTempleForStrength);
                        if (GeneralConfigHandler.addIgloos) {
                            MerchantRecipe iglooForGoldenApple = new MerchantRecipe(new ItemStack((Item)ModItems.igloobook, 1), new ItemStack(Items.field_151153_ao, 1));
                            recipeList.add((Object)iglooForGoldenApple);
                            MerchantRecipe iglooForSplashWeakness = new MerchantRecipe(new ItemStack((Item)ModItems.igloobook, 1), new ItemStack((Item)Items.field_151068_bn, 1, 16456));
                            recipeList.add((Object)iglooForSplashWeakness);
                        }
                        String[] entityName = NameGenerator.newRandomName("villager-alien-angel-demon-dragon-goblin-golem");
                        ItemStack tagWithName = new ItemStack(Items.field_151057_cb, 1).func_151001_c((entityName[1] + " " + entityName[2] + " " + entityName[3]).trim());
                        tagWithName.func_82841_c(99);
                        recipeList.add((Object)new MerchantRecipe(new ItemStack((Item)ModItems.villageBook, 1), tagWithName));
                    }
                }
                break;
            }
            case 2: {
                switch (career) {
                    case 1: {
                        if (nextSlotToFill == 1 || nextSlotToFill > 4) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151078_bh, 36 + random.nextInt(5)), new ItemStack(Items.field_151166_bC, 1)));
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151043_k, 8 + random.nextInt(3)), new ItemStack(Items.field_151166_bC, 1)));
                        }
                        if (nextSlotToFill == 2 || nextSlotToFill > 4) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151100_aR, 1 + random.nextInt(2), 4)));
                        }
                        if (nextSlotToFill != 3 && nextSlotToFill <= 4) break;
                        recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151079_bi, 4 + random.nextInt(4))));
                    }
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                switch (career) {
                    case 1: {
                        if (nextSlotToFill == 1 || nextSlotToFill > 2) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151076_bf, 14 + random.nextInt(5)), new ItemStack(Items.field_151166_bC, 1)));
                        }
                        if (nextSlotToFill < 2) break;
                        recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151077_bg, 6 + random.nextInt(3))));
                        break;
                    }
                    case 2: {
                        if (nextSlotToFill == 1 || nextSlotToFill > 3) {
                            recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151116_aA, 9 + random.nextInt(4)), new ItemStack(Items.field_151166_bC, 1)));
                        }
                        if (nextSlotToFill != 2 && nextSlotToFill <= 3) break;
                        recipeList.func_77205_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 7 + random.nextInt(2)), EnchantmentHelper.func_77504_a((Random)random, (ItemStack)new ItemStack((Item)Items.field_151027_R, 1, 0), (int)(7 + random.nextInt(6)))));
                    }
                }
                break;
            }
        }
    }

    public static boolean isTradeInappropriate(MerchantRecipe merchantrecipe, int profession, int career, int slotPosition) {
        switch (profession) {
            case 0: {
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151015_O, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return career != 1 || slotPosition != 1 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151025_P, 1, 0)))) {
                    return career != 1 || slotPosition != 1 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151034_e, 1, 0)))) {
                    return career != 1 || slotPosition != 3 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151106_aX, 1, 0)))) {
                    return career != 1 || slotPosition < 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151127_ba, 1, 0)))) {
                    return !GeneralConfigHandler.villagerLegacyTrades || career != 1 || slotPosition < 5;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return career != 3 || slotPosition != 1 && slotPosition <= 2;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151097_aZ, 1, 0)))) {
                    return career != 3 || slotPosition != 1 && slotPosition <= 2;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151032_g, 1, 0)))) {
                    return career != 4 || slotPosition != 1 && slotPosition <= 2;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150351_n), 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151145_ak, 1, 0)))) {
                    return career != 4 || slotPosition < 2;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151076_bf, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151101_aQ, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151033_d, 1, 0)))) {
                    return true;
                }
                if (!merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151077_bg, 1, 0)))) break;
                return true;
            }
            case 1: {
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151121_aF, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return (career != 1 || slotPosition != 1 && slotPosition <= 6) && (career != 2 || slotPosition != 1 && slotPosition <= 4);
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151122_aG, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return career != 1 || slotPosition != 2 && slotPosition <= 6;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151111_aL, 1, 0)))) {
                    return career != 1 || slotPosition != 2 && slotPosition <= 6;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Item.func_150898_a((Block)Blocks.field_150342_X), 1, 0)))) {
                    return career != 1 || slotPosition != 2 && slotPosition <= 6;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151164_bB, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return career != 1 || slotPosition != 3 && slotPosition <= 6;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151113_aN, 1, 0)))) {
                    return career != 1 || slotPosition != 3 && slotPosition <= 6;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Item.func_150898_a((Block)Blocks.field_150359_w), 1, 0)))) {
                    return career != 1 || slotPosition != 3 && slotPosition <= 6;
                }
                if ((career != 1 || slotPosition != 2 && slotPosition != 3 && slotPosition != 6) && career != 2 || !merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151122_aG, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151134_bR, 1, 0)))) break;
                return true;
            }
            case 2: {
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151137_ax, 1, 0)))) {
                    return career != 1 || slotPosition != 2 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Item.func_150898_a((Block)Blocks.field_150426_aN), 1, 0)))) {
                    return career != 1 || slotPosition != 3 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151062_by, 1, 0)))) {
                    return career != 1 || slotPosition < 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151061_bv, 1, 0)))) {
                    return !GeneralConfigHandler.villagerLegacyTrades || career != 1 || slotPosition < 5;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151040_l, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151040_l, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151048_u, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151048_u, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack((Item)Items.field_151030_Z, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151030_Z, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack((Item)Items.field_151163_ad, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151163_ad, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151036_c, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151036_c, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151056_x, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151056_x, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151035_b, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151035_b, 1, 0)))) {
                    return true;
                }
                if (!merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151046_w, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151046_w, 1, 0)))) break;
                return true;
            }
            case 3: {
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151044_h, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return (career != 1 || slotPosition != 1 && slotPosition <= 4) && (career != 2 || slotPosition != 1 && slotPosition <= 3) && (career != 3 || slotPosition != 1 && slotPosition <= 3);
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151042_j, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return (career != 1 || slotPosition != 2 && slotPosition <= 4) && (career != 2 || slotPosition != 2 && slotPosition <= 3) && (career != 3 || slotPosition != 2 && slotPosition <= 3);
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151045_i, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return (career != 1 || slotPosition != 3 && slotPosition <= 4) && (career != 2 || slotPosition != 3 && slotPosition <= 3) && (career != 3 || slotPosition != 3 && slotPosition <= 3);
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151028_Y, 1, 0)))) {
                    return career != 1 || slotPosition != 1 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151030_Z, 1, 0)))) {
                    return career != 1 || slotPosition != 2 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151163_ad, 1, 0)))) {
                    return career != 1 || slotPosition != 3 && slotPosition <= 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151029_X, 1, 0)))) {
                    return career != 1 || slotPosition < 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151022_W, 1, 0)))) {
                    return career != 1 || slotPosition < 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151020_U, 1, 0)))) {
                    return career != 1 || slotPosition < 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151023_V, 1, 0)))) {
                    return career != 1 || slotPosition < 4;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151036_c, 1, 0)))) {
                    return career != 2 || slotPosition != 1 && slotPosition <= 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151040_l, 1, 0)))) {
                    return career != 2 || slotPosition != 2 && slotPosition <= 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151048_u, 1, 0)))) {
                    return career != 2 || slotPosition < 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151056_x, 1, 0)))) {
                    return career != 2 || slotPosition < 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151037_a, 1, 0)))) {
                    return career != 3 || slotPosition != 1 && slotPosition <= 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151035_b, 1, 0)))) {
                    return career != 3 || slotPosition != 2 && slotPosition <= 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151046_w, 1, 0)))) {
                    return career != 3 || slotPosition < 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151043_k, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return !GeneralConfigHandler.villagerLegacyTrades || !(career == 1 && slotPosition >= 5 || career == 2 && slotPosition >= 4) && (career != 3 || slotPosition < 4);
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151047_v, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151019_K, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151012_L, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151167_ab, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151175_af, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151161_ac, 1, 0)))) {
                    return true;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151165_aa, 1, 0)))) {
                    return true;
                }
                if (!merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151173_ae, 1, 0)))) break;
                return true;
            }
            case 4: {
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151147_al, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return career != 1 || slotPosition != 1 && slotPosition <= 2;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151044_h, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return career != 1 || slotPosition < 2;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151157_am, 1, 0)))) {
                    return career != 1 || slotPosition < 2;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151082_bd, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0)))) {
                    return !GeneralConfigHandler.villagerLegacyTrades || career != 1 || slotPosition < 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151083_be, 1, 0)))) {
                    return !GeneralConfigHandler.villagerLegacyTrades || career != 1 || slotPosition < 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151026_S, 1, 0)))) {
                    return career != 2 || slotPosition != 1 && slotPosition <= 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151027_R, 1, 0)))) {
                    return career != 2 || slotPosition != 2 && slotPosition <= 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Items.field_151141_av, 1, 0)))) {
                    return career != 2 || slotPosition < 3;
                }
                if (merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151021_T, 1, 0)))) {
                    return !GeneralConfigHandler.villagerLegacyTrades || career != 2 || slotPosition < 4;
                }
                if (!merchantrecipe.func_77393_a(new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack((Item)Items.field_151024_Q, 1, 0)))) break;
                return !GeneralConfigHandler.villagerLegacyTrades || career != 2 || slotPosition < 4;
            }
        }
        return false;
    }
}

