/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.block.ModBlocksVN;
import astrotibs.villagenames.block.color.BlockConcrete;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.name.NamePieces;
import astrotibs.villagenames.nbt.VNWorldDataStructure;
import astrotibs.villagenames.utility.LogHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class WellDecorateEvent {
    @SubscribeEvent
    public void onPopulating(PopulateChunkEvent.Post event) {
        if (event.hasVillageGenerated && event.world.field_73011_w.field_76574_g == 0 && !event.world.field_72995_K) {
            Random random = event.world.field_73012_v;
            boolean wellSlabs = GeneralConfigHandler.wellSlabs;
            boolean nameSign = GeneralConfigHandler.nameSign;
            boolean wellBoundary = GeneralConfigHandler.wellBoundary;
            boolean wellKillSwitch = GeneralConfigHandler.wellDecorations;
            boolean addConcrete = GeneralConfigHandler.addConcrete;
            boolean concreteWell = GeneralConfigHandler.concreteWell;
            int i = (event.chunkX << 4) + 8;
            int k = (event.chunkZ << 4) + 8;
            int signCornerAndFacing = random.nextInt(8);
            int signOrientation = signCornerAndFacing / 2 * 4;
            int signLocation = (signCornerAndFacing + 1) / 2 % 4;
            int signXOffset = (1 - Math.abs((signLocation + 1) / 2 - 1) * 2) * 2;
            int signZOffset = (signLocation / 2 * 2 - 1) * 2;
            int signHeightOffGround = 2;
            Block signBase = Blocks.field_150347_e;
            int isWellCorner = 0;
            for (int x = i; x < i + 16; ++x) {
                for (int z = k; z < k + 16; ++z) {
                    int y = event.world.func_72976_f(x, z);
                    if (y <= 1) continue;
                    Block id = event.world.func_147439_a(x, --y, z);
                    while (id.isAir((IBlockAccess)event.world, x, y, z) || id.isLeaves((IBlockAccess)event.world, x, y, z)) {
                        id = event.world.func_147439_a(x, --y, z);
                    }
                    if (!id.func_149662_c()) continue;
                    id = event.world.func_147439_a(x, y - 4, z);
                    Block id2 = event.world.func_147439_a(x, y - 5, z);
                    Block id3 = event.world.func_147439_a(x, y - 6, z);
                    if (!WellDecorateEvent.isWaterId(id) || !WellDecorateEvent.isWaterId(id2) || !WellDecorateEvent.isWaterId(id3)) continue;
                    int[] field = new int[]{x, y -= 4, z};
                    int[] field2 = new int[]{x, y - 1, z};
                    int[] field3 = new int[]{x, y - 2, z};
                    List<int[]> listWater = WellDecorateEvent.getBorder(event.world, id, field);
                    List<int[]> listWater2 = WellDecorateEvent.getBorder(event.world, id2, field2);
                    List<int[]> listWater3 = WellDecorateEvent.getBorder(event.world, id3, field3);
                    List<int[]> listOpaque = WellDecorateEvent.getOpaqueBorder(event.world, field);
                    if (listWater.size() != 3 || listWater2.size() != 3 || listWater3.size() != 3 || listOpaque.size() != 5) continue;
                    if (1 - Math.abs(++isWellCorner / 2 - 1) + (isWellCorner - 1) % 2 * 2 == signLocation) {
                        String[] newVillageName = NameGenerator.newRandomName("Village");
                        String headerTags = newVillageName[0];
                        String namePrefix = newVillageName[1];
                        String nameRoot = newVillageName[2];
                        String nameSuffix = newVillageName[3];
                        if (event.world.func_147439_a(x + signXOffset, y + 2, z + signZOffset).isAir((IBlockAccess)event.world, x + signXOffset, y + 2, z + signZOffset) || event.world.func_147439_a(x + signXOffset, y + 2, z + signZOffset).isLeaves((IBlockAccess)event.world, x + signXOffset, y + 2, z + signZOffset)) {
                            int[] codeColor_a = NamePieces.codeColors_default;
                            int townColorMeta = codeColor_a[random.nextInt(codeColor_a.length)];
                            if (townColorMeta == -1) {
                                int[] codeColors_remaining_a = NamePieces.codeColors_remaining;
                                townColorMeta = codeColors_remaining_a[random.nextInt(codeColors_remaining_a.length)];
                            }
                            int signX = x + signXOffset;
                            int signY = y + 2;
                            int signZ = z + signZOffset;
                            int villageArea = -1;
                            MapGenStructureData structureData = (MapGenStructureData)event.world.perWorldStorage.func_75742_a(MapGenStructureData.class, "Village");
                            NBTTagCompound nbttagcompound = structureData.func_143041_a();
                            for (Object element0 : nbttagcompound.func_150296_c()) {
                                NBTBase nbtbase = nbttagcompound.func_74781_a(element0.toString());
                                if (nbtbase.func_74732_a() != 10) continue;
                                try {
                                    NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                                    int[] boundingBox = nbttagcompound2.func_74759_k("BB");
                                    if (signX < boundingBox[0] || signY < boundingBox[1] || signZ < boundingBox[2] || signX > boundingBox[3] || signY > boundingBox[4] || signZ > boundingBox[5]) continue;
                                    int ChunkX = nbttagcompound2.func_74762_e("ChunkX");
                                    int ChunkZ = nbttagcompound2.func_74762_e("ChunkZ");
                                    villageArea = (boundingBox[3] - boundingBox[0]) * (boundingBox[3] - boundingBox[0]);
                                    if (GeneralConfigHandler.debugMessages) {
                                        LogHelper.info("Village located at ChunkX: " + ChunkX + ", ChunkZ: " + ChunkZ + " with area " + villageArea);
                                    }
                                    signX = (boundingBox[0] + boundingBox[3]) / 2;
                                    signY = (boundingBox[1] + boundingBox[4]) / 2;
                                    signZ = (boundingBox[2] + boundingBox[5]) / 2;
                                }
                                catch (Exception e) {
                                    if (!GeneralConfigHandler.debugMessages) continue;
                                    LogHelper.warn("Village bounding box could not be determined.");
                                }
                            }
                            int topLineRand = random.nextInt(4);
                            String topLine = "Welcome to";
                            if (topLineRand > 1) {
                                if (villageArea > 12000) {
                                    topLine = "City" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 5000) {
                                    topLine = "Town" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 2083) {
                                    topLine = "Village" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 868) {
                                    topLine = "Hamlet" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 0) {
                                    topLine = "Outpost" + (topLineRand % 2 == 0 ? ":" : " of");
                                }
                            }
                            topLine = topLine.replaceAll("\\^", " ").trim();
                            VNWorldDataStructure data = VNWorldDataStructure.forWorld(event.world, "villagenames3_Village", "NamedStructures");
                            NBTTagCompound tagCompound = data.getData();
                            Set tagmapKeyset = tagCompound.func_150296_c();
                            for (Object element : tagmapKeyset) {
                                int radiussearch;
                                int townZ;
                                int townY;
                                String townSignEntry = element.toString();
                                NBTTagCompound tagList = tagCompound.func_150295_c(townSignEntry, (int)tagCompound.func_74732_a()).func_150305_b(0);
                                int townX = tagList.func_74762_e("signX");
                                if ((signX - townX) * (signX - townX) + (signY - (townY = tagList.func_74762_e("signY"))) * (signY - townY) + (signZ - (townZ = tagList.func_74762_e("signZ"))) * (signZ - townZ) > (radiussearch = 32) * radiussearch) continue;
                                townColorMeta = tagList.func_74762_e("townColor");
                                namePrefix = tagList.func_74779_i("namePrefix");
                                nameRoot = tagList.func_74779_i("nameRoot");
                                nameSuffix = tagList.func_74779_i("nameSuffix");
                                break;
                            }
                            if (wellKillSwitch && nameSign) {
                                event.world.func_147449_b(x + signXOffset, y + 1, z + signZOffset, Blocks.field_150463_bK);
                                event.world.func_147465_d(x + signXOffset, y + 2, z + signZOffset, Blocks.field_150472_an, signOrientation, 2);
                            }
                            if (wellKillSwitch && wellBoundary) {
                                int pedY;
                                BlockConcrete concreteBlock = ModBlocksVN.blockConcrete;
                                Block roofGlazedBlock = ModBlocksVN.glazedTerracotta;
                                switch (townColorMeta / 4) {
                                    case 0: {
                                        roofGlazedBlock = ModBlocksVN.glazedTerracotta;
                                        break;
                                    }
                                    case 1: {
                                        roofGlazedBlock = ModBlocksVN.glazedTerracotta2;
                                        break;
                                    }
                                    case 2: {
                                        roofGlazedBlock = ModBlocksVN.glazedTerracotta3;
                                        break;
                                    }
                                    case 3: {
                                        roofGlazedBlock = ModBlocksVN.glazedTerracotta4;
                                    }
                                }
                                if (addConcrete && concreteWell) {
                                    for (pedY = y - 3; pedY <= y; ++pedY) {
                                        for (int rimi = 2; rimi > -3; --rimi) {
                                            event.world.func_147465_d(x + signXOffset / 2 * rimi, pedY, z + signZOffset, (Block)concreteBlock, townColorMeta, 2);
                                            event.world.func_147465_d(x + signXOffset, pedY, z + -signZOffset / 2 * (1 + rimi), (Block)concreteBlock, townColorMeta, 2);
                                            event.world.func_147465_d(x - signXOffset * 3 / 2, pedY, z + signZOffset / 2 * rimi, (Block)concreteBlock, townColorMeta, 2);
                                            event.world.func_147465_d(x + -signXOffset / 2 * (1 + rimi), pedY, z - signZOffset * 3 / 2, (Block)concreteBlock, townColorMeta, 2);
                                        }
                                    }
                                    int metaSpin = random.nextInt(4) + 4;
                                    int metaChirality = random.nextBoolean() ? 1 : -1;
                                    event.world.func_147465_d(x, y + 4, z, roofGlazedBlock, metaSpin * 4 % 16 + townColorMeta % 4, 2);
                                    event.world.func_147465_d(x, y + 4, z - signZOffset / 2, roofGlazedBlock, (metaSpin + metaChirality * 1) * 4 % 16 + townColorMeta % 4, 2);
                                    event.world.func_147465_d(x - signXOffset / 2, y + 4, z - signZOffset / 2, roofGlazedBlock, (metaSpin + metaChirality * 2) * 4 % 16 + townColorMeta % 4, 2);
                                    event.world.func_147465_d(x - signXOffset / 2, y + 4, z, roofGlazedBlock, (metaSpin + metaChirality * 3) * 4 % 16 + townColorMeta % 4, 2);
                                } else {
                                    for (pedY = y - 3; pedY <= y; ++pedY) {
                                        event.world.func_147465_d(x + signXOffset, pedY, z + signZOffset, Blocks.field_150406_ce, townColorMeta, 2);
                                    }
                                }
                            }
                            TileEntitySign signContents = new TileEntitySign();
                            if (namePrefix.length() + 1 + nameRoot.length() > 15) {
                                signContents.field_145915_a[0] = headerTags + topLine.trim();
                                signContents.field_145915_a[1] = namePrefix.trim();
                                if (nameRoot.length() + 1 + nameSuffix.length() > 15) {
                                    signContents.field_145915_a[2] = nameRoot.trim();
                                    signContents.field_145915_a[3] = nameSuffix.trim();
                                } else {
                                    signContents.field_145915_a[2] = (nameRoot + " " + nameSuffix).trim();
                                }
                            } else if (namePrefix.length() + 1 + nameRoot.length() + 1 + nameSuffix.length() <= 15) {
                                signContents.field_145915_a[1] = headerTags + topLine;
                                signContents.field_145915_a[2] = (namePrefix + " " + nameRoot + " " + nameSuffix).trim();
                            } else {
                                signContents.field_145915_a[1] = headerTags + topLine.trim();
                                signContents.field_145915_a[2] = (namePrefix + " " + nameRoot).trim();
                                signContents.field_145915_a[3] = nameSuffix.trim();
                            }
                            if (topLine.equals("")) {
                                for (int isign = 0; isign < 3; ++isign) {
                                    signContents.field_145915_a[isign] = signContents.field_145915_a[isign + 1];
                                }
                                signContents.field_145915_a[3] = "";
                            }
                            if (wellKillSwitch && nameSign) {
                                event.world.func_147455_a(x + signXOffset, y + 2, z + signZOffset, (TileEntity)signContents);
                            }
                            NBTTagList nbttaglist = new NBTTagList();
                            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                            nbttagcompound1.func_74768_a("signX", signX);
                            nbttagcompound1.func_74768_a("signY", signY);
                            nbttagcompound1.func_74768_a("signZ", signZ);
                            nbttagcompound1.func_74768_a("townColor", townColorMeta);
                            nbttagcompound1.func_74778_a("namePrefix", namePrefix);
                            nbttagcompound1.func_74778_a("nameRoot", nameRoot);
                            nbttagcompound1.func_74778_a("nameSuffix", nameSuffix);
                            nbttagcompound1.func_74778_a("sign0", signContents.field_145915_a[0]);
                            nbttagcompound1.func_74778_a("sign1", signContents.field_145915_a[1]);
                            nbttagcompound1.func_74778_a("sign2", signContents.field_145915_a[2]);
                            nbttagcompound1.func_74778_a("sign3", signContents.field_145915_a[3]);
                            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                            data.getData().func_74782_a((namePrefix + " " + nameRoot + " " + nameSuffix).trim() + ", x" + signX + " y" + signY + " z" + signZ, (NBTBase)nbttaglist);
                            data.func_76185_a();
                        } else {
                            int signX = x + signXOffset;
                            int signY = y + 2;
                            int signZ = z + signZOffset;
                            LogHelper.error("Tried to generate a sign inside a well's post at x=" + signX + " y=" + signY + " z=" + signZ);
                        }
                    }
                    if (wellKillSwitch && wellSlabs) {
                        field = listOpaque.remove(1);
                        event.world.func_147449_b(field[0], field[1] + 1, field[2], (Block)Blocks.field_150333_U);
                        field = listOpaque.remove(2);
                        event.world.func_147449_b(field[0], field[1] + 1, field[2], (Block)Blocks.field_150333_U);
                    }
                    while (event.world.func_147439_a(x, y, z) == id) {
                        --y;
                    }
                    field = new int[]{x, y, z};
                    listOpaque = WellDecorateEvent.getOpaqueBorder(event.world, field);
                }
            }
        }
        if (GeneralConfigHandler.pyramidTerracotta && event.world.field_73011_w.field_76574_g == 0 && event.world.getBiomeGenForCoordsBody(event.chunkX, event.chunkZ) != BiomeGenBase.field_76782_w && event.world.getBiomeGenForCoordsBody(event.chunkX, event.chunkZ) != BiomeGenBase.field_76792_x && event.world.getBiomeGenForCoordsBody(event.chunkX, event.chunkZ) != BiomeGenBase.field_76780_h && event.world.getBiomeGenForCoordsBody(event.chunkX, event.chunkZ) != BiomeGenBase.field_150584_S && event.world.getBiomeGenForCoordsBody(event.chunkX, event.chunkZ) != BiomeGenBase.field_76774_n) {
            this.searchTempleAndReplaceWool(event, 8);
        }
    }

    private static boolean hasAround(World world, Block id, int x, int y, int z) {
        return world.func_147439_a(x - 1, y, z) == id && world.func_147439_a(x + 1, y, z) == id && world.func_147439_a(x, y, z - 1) == id && world.func_147439_a(x, y, z + 1) == id;
    }

    private static List<int[]> getBorder(World world, Block id, int[] field) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int x = field[0] - 1; x < field[0] + 2; ++x) {
            for (int z = field[2] - 1; z < field[2] + 2; ++z) {
                if (x == field[0] && z == field[2] || world.func_147439_a(x, field[1], z) != id) continue;
                list.add(new int[]{x, field[1], z});
            }
        }
        return list;
    }

    private static List<int[]> getOpaqueBorder(World world, int[] field) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int x = field[0] - 1; x < field[0] + 2; ++x) {
            for (int z = field[2] - 1; z < field[2] + 2; ++z) {
                if (x == field[0] && z == field[2] || !world.func_147439_a(x, field[1], z).func_149662_c()) continue;
                list.add(new int[]{x, field[1], z});
            }
        }
        return list;
    }

    private static boolean isCorner(World world, Block id, int[] pos) {
        int[] b;
        List<int[]> list = WellDecorateEvent.getBorder(world, id, pos);
        if (list.size() < 2) {
            return false;
        }
        int[] a = list.get(0);
        return a[0] != (b = list.get(1))[0] && a[2] != b[2];
    }

    private static boolean isReplaceable(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    private static boolean isWaterId(Block id) {
        return id.func_149688_o() == Material.field_151586_h;
    }

    public void searchTempleAndReplaceWool(PopulateChunkEvent.Post event, int buffer) {
        if (event.world.field_73011_w.field_76574_g == 0 && !event.world.field_72995_K) {
            try {
                MapGenStructureData structureData = (MapGenStructureData)event.world.perWorldStorage.func_75742_a(MapGenStructureData.class, "Temple");
                NBTTagCompound nbttagcompound = structureData.func_143041_a();
                for (Object element : nbttagcompound.func_150296_c()) {
                    NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                    if (nbtbase.func_74732_a() != 10) continue;
                    NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                    try {
                        int[] boundingBox = nbttagcompound2.func_74759_k("BB");
                        int xChunkCenter = event.chunkX << 4;
                        int zChunkCenter = event.chunkZ << 4;
                        if (xChunkCenter < boundingBox[0] - buffer || zChunkCenter < boundingBox[2] - buffer || xChunkCenter > boundingBox[3] + buffer || zChunkCenter > boundingBox[5] + buffer) continue;
                        for (int k = 50; k <= 80; ++k) {
                            for (int i = -16; i < 16; ++i) {
                                for (int j = -16; j < 16; ++j) {
                                    int woolmeta;
                                    Block blocktoscan = event.world.func_147439_a((event.chunkX << 4) + i, k, (event.chunkZ << 4) + j);
                                    if (blocktoscan != Blocks.field_150325_L || (woolmeta = event.world.func_72805_g((event.chunkX << 4) + i, k, (event.chunkZ << 4) + j)) != 1 && woolmeta != 11) continue;
                                    event.world.func_147465_d((event.chunkX << 4) + i, k, (event.chunkZ << 4) + j, Blocks.field_150406_ce, woolmeta, 2);
                                }
                            }
                        }
                        if (GeneralConfigHandler.debugMessages) {
                            LogHelper.info("Replacing desert pyramid wool at " + (boundingBox[0] + boundingBox[3]) / 2 + " " + (boundingBox[2] + boundingBox[5]) / 2);
                        }
                        nbttagcompound2.func_74757_a("VNWoolReplaced", true);
                        structureData.func_76186_a(true);
                    }
                    catch (Exception e) {
                        if (!GeneralConfigHandler.debugMessages) continue;
                        LogHelper.warn("Failed to evaluate Temple bounding box");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

