/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.igloo.utils;

import astrotibs.villagenames.igloo.utils.EnumFacing194;
import astrotibs.villagenames.igloo.utils.Rotation;

public enum Mirror {
    NONE("no_mirror"),
    LEFT_RIGHT("mirror_left_right"),
    FRONT_BACK("mirror_front_back");

    private final String name;
    private static String[] mirrorNames;

    private Mirror(String nameIn) {
        this.name = nameIn;
    }

    public int mirrorRotation(int rotationIn, int rotationCount) {
        int i = rotationCount / 2;
        int j = rotationIn > i ? rotationIn - rotationCount : rotationIn;
        switch (this) {
            case LEFT_RIGHT: {
                return (rotationCount - j) % rotationCount;
            }
            case FRONT_BACK: {
                return (i - j + rotationCount) % rotationCount;
            }
        }
        return rotationIn;
    }

    public Rotation toRotation(EnumFacing194 facing) {
        EnumFacing194.Axis enumfacing$axis = facing.getAxis();
        return !(this == LEFT_RIGHT && enumfacing$axis == EnumFacing194.Axis.Z || this == FRONT_BACK && enumfacing$axis == EnumFacing194.Axis.X) ? Rotation.NONE : Rotation.CLOCKWISE_180;
    }

    public EnumFacing194 mirror(EnumFacing194 facing) {
        switch (this) {
            case LEFT_RIGHT: {
                if (facing == EnumFacing194.WEST) {
                    return EnumFacing194.EAST;
                }
                if (facing == EnumFacing194.EAST) {
                    return EnumFacing194.WEST;
                }
                return facing;
            }
            case FRONT_BACK: {
                if (facing == EnumFacing194.NORTH) {
                    return EnumFacing194.SOUTH;
                }
                if (facing == EnumFacing194.SOUTH) {
                    return EnumFacing194.NORTH;
                }
                return facing;
            }
        }
        return facing;
    }

    static {
        mirrorNames = new String[Mirror.values().length];
        int i = 0;
        for (Mirror mirror : Mirror.values()) {
            Mirror.mirrorNames[i++] = mirror.name;
        }
    }
}

