/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.network;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.common.ExtendedVillageGuard;
import astrotibs.villagenames.common.ExtendedVillagerZombie;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.network.MessageVillageGuard;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import astrotibs.villagenames.tracker.ClientInfoTracker;
import astrotibs.villagenames.utility.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class NetworkHelper {
    public static void sendVillagerProfessionMessage(int zombieId, ExtendedVillagerZombie properties, EntityPlayer target) {
        if (GeneralConfigHandler.villagerCareers && zombieId > 0 && properties != null && properties.getProfession() >= 0 && properties.getCareer() > 0 || zombieId > 0 && properties != null && properties.getProfession() >= 0) {
            MessageZombieVillagerProfession message = new MessageZombieVillagerProfession(zombieId, properties.getProfession(), properties.getCareer());
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("NetworkHelper > target: " + target);
                LogHelper.info("NetworkHelper > " + message.toString());
            }
            VillageNames.VNNetworkWrapper.sendTo((IMessage)message, (EntityPlayerMP)target);
        }
    }

    public static void sendVillageGuardMessage(int guardId, ExtendedVillageGuard properties, EntityPlayer target) {
        if (guardId > 0 && properties != null) {
            MessageVillageGuard message = new MessageVillageGuard(guardId);
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("NetworkHelper > target: " + target);
                LogHelper.info("NetworkHelper > " + message.toString());
            }
            VillageNames.VNNetworkWrapper.sendTo((IMessage)message, (EntityPlayerMP)target);
        }
    }

    public static class VillageGuardHandler
    implements IMessageHandler<MessageVillageGuard, IMessage> {
        public IMessage onMessage(MessageVillageGuard message, MessageContext ctx) {
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("NetworkHelper > " + message.toString());
            }
            if (message.getEntityID() > 0) {
                ClientInfoTracker.addGuardMessage(message);
                ClientInfoTracker.SyncGuardMessage(message.getEntityID());
            }
            return null;
        }
    }

    public static class VillagerProfessionHandler
    implements IMessageHandler<MessageZombieVillagerProfession, IMessage> {
        public IMessage onMessage(MessageZombieVillagerProfession message, MessageContext ctx) {
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("NetworkHelper > " + message.toString());
            }
            if (GeneralConfigHandler.villagerCareers && message.getEntityID() > 0 && message.getProfession() >= 0 && message.getCareer() > 0 || message.getEntityID() > 0 && message.getProfession() >= 0) {
                ClientInfoTracker.addZombieMessage(message);
                ClientInfoTracker.SyncZombieMessage(message.getEntityID());
            }
            return null;
        }
    }
}

