/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.prismarine.guardian.entity.monster;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.prismarine.guardian.entity.ai.EntityAIWanderExtender;
import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.PathNavigateSwimmer;
import astrotibs.villagenames.prismarine.guardian.particle.SToCMessage;
import astrotibs.villagenames.prismarine.guardian.util.MathHelper1122;
import astrotibs.villagenames.prismarine.register.ModBlocksPrismarine;
import astrotibs.villagenames.prismarine.register.ModItemsPrismarine;
import astrotibs.villagenames.proxy.ClientProxy;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;

public class EntityGuardian
extends EntityMob {
    private float clientSideTailAnimation;
    private float clientSideTailAnimationO;
    private float clientSideTailAnimationSpeed;
    private float clientSideSpikesAnimation;
    private float clientSideSpikesAnimationO;
    private EntityLivingBase targetedEntity;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    private EntityAIWanderExtender wander = new EntityAIWanderExtender(this, 1.0, 80);
    public GuardianMoveHelper field_70765_h;
    public GuardianLookHelper field_70749_g;
    public PathNavigateSwimmer field_70699_by;

    public EntityGuardian(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.func_70105_a(0.85f, 0.85f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIGuardianAttack(this));
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGuardian.class, 12.0f, 0.01f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.wander.func_75248_a(3);
        entityaimovetowardsrestriction.func_75248_a(3);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (IEntitySelector)new GuardianTargetSelector(this)));
        this.field_70765_h = new GuardianMoveHelper(this);
        this.field_70749_g = new GuardianLookHelper(this);
        this.field_70699_by = new PathNavigateSwimmer(this, worldIn);
        this.clientSideTailAnimationO = this.clientSideTailAnimation = this.field_70146_Z.nextFloat();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setElder(tagCompund.func_74767_n("Elder"));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Elder", this.isElder());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    private boolean isSyncedFlagSet(int flagId) {
        return (this.field_70180_af.func_75679_c(16) & flagId) != 0;
    }

    private void setSyncedFlag(int flagId, boolean state) {
        int i = this.field_70180_af.func_75679_c(16);
        if (state) {
            this.field_70180_af.func_75692_b(16, (Object)(i | flagId));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)(i & ~flagId));
        }
    }

    public boolean isMoving() {
        return this.isSyncedFlagSet(2);
    }

    private void setMoving(boolean setMoving) {
        this.setSyncedFlag(2, setMoving);
    }

    public int getAttackDuration() {
        return this.isElder() ? 60 : 80;
    }

    public boolean isElder() {
        return this.isSyncedFlagSet(4);
    }

    public void setElder(boolean elder) {
        this.setSyncedFlag(4, elder);
        if (elder) {
            this.func_70105_a(1.9975f, 1.9975f);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
            this.func_110163_bv();
            this.wander.setExecutionChance(400);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setElder() {
        this.setElder(true);
        this.clientSideSpikesAnimation = 1.0f;
        this.clientSideSpikesAnimationO = 1.0f;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_75692_b(17, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return this.field_70180_af.func_75679_c(17) != 0;
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(17));
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double playerX, double playerY, double playerZ) {
        double d3 = this.field_70165_t - playerX;
        double d4 = this.field_70163_u - playerY;
        double d5 = this.field_70161_v - playerZ;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        this.field_70158_ak = this.hasTargetedEntity();
        return this.func_70112_a(d6);
    }

    public void func_145781_i(int dataID) {
        super.func_145781_i(dataID);
        if (dataID == 16) {
            if (this.isElder() && this.field_70130_N < 1.0f) {
                this.func_70105_a(1.9975f, 1.9975f);
            }
        } else if (dataID == 17) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public int func_70627_aG() {
        return 160;
    }

    protected String func_70639_aQ() {
        return !this.func_70090_H() ? "VillageNames:land_idle" : (this.isElder() ? "VillageNames:elder_idle" : "VillageNames:guardian_idle");
    }

    protected String func_70621_aR() {
        return !this.func_70090_H() ? "VillageNames:land_hit" : (this.isElder() ? "VillageNames:elder_hit" : "VillageNames:guardian_hit");
    }

    protected String func_70673_aS() {
        return !this.func_70090_H() ? "VillageNames:land_death" : (this.isElder() ? "VillageNames:elder_death" : "VillageNames:guardian_death");
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public float func_70783_a(int x, int y, int z) {
        return this.field_70170_p.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_72801_o(x, y, z) - 0.5f : super.func_70783_a(x, y, z);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70699_by.onUpdateNavigation();
        this.field_70765_h.onUpdateMoveHelper();
        this.field_70749_g.onUpdateLook();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.clientSideTailAnimationO = this.clientSideTailAnimation;
            if (!this.func_70090_H()) {
                this.clientSideTailAnimationSpeed = 2.0f;
                if (this.field_70181_x > 0.0 && this.clientSideTouchedGround) {
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "VillageNames:flop", 1.0f, 1.0f, false);
                }
                int xDetect = (int)this.field_70165_t;
                int yDetect = (int)this.field_70163_u;
                int zDetect = (int)this.field_70161_v;
                this.clientSideTouchedGround = this.field_70181_x < 0.0 && this.field_70170_p.func_147445_c(xDetect, yDetect - 1, zDetect, false);
            } else {
                this.clientSideTailAnimationSpeed = this.isMoving() ? (this.clientSideTailAnimationSpeed < 0.5f ? 4.0f : (this.clientSideTailAnimationSpeed += (0.5f - this.clientSideTailAnimationSpeed) * 0.1f)) : (this.clientSideTailAnimationSpeed += (0.125f - this.clientSideTailAnimationSpeed) * 0.2f);
            }
            this.clientSideTailAnimation += this.clientSideTailAnimationSpeed;
            this.clientSideSpikesAnimationO = this.clientSideSpikesAnimation;
            this.clientSideSpikesAnimation = !this.func_70090_H() ? this.field_70146_Z.nextFloat() : (this.isMoving() ? (this.clientSideSpikesAnimation += (0.0f - this.clientSideSpikesAnimation) * 0.25f) : (this.clientSideSpikesAnimation += (1.0f - this.clientSideSpikesAnimation) * 0.06f));
            if (this.isMoving() && this.func_70090_H()) {
                Vec3 vec3 = this.func_70676_i(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - vec3.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3.field_72449_c * 1.5, 0.0, 0.0, 0.0);
                }
            }
            if (this.hasTargetedEntity()) {
                EntityLivingBase target;
                if (this.clientSideAttackTime < this.getAttackDuration()) {
                    ++this.clientSideAttackTime;
                }
                if ((target = this.getTargetedEntity()) != null) {
                    this.field_70749_g.setLookPositionWithEntity((Entity)target, 90.0f, 90.0f);
                    this.field_70749_g.onUpdateLook();
                    double animationProgress = this.getAttackAnimationScale(0.0f);
                    double dx = target.field_70165_t - this.field_70165_t;
                    double dy = target.field_70163_u + (double)(target.field_70131_O * (this.targetedEntity instanceof EntityPlayer ? -0.5f : 0.5f)) - (this.field_70163_u + (double)this.func_70047_e());
                    double dz = target.field_70161_v - this.field_70161_v;
                    double dr = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    dx /= dr;
                    dy /= dr;
                    dz /= dr;
                    double randomDouble = this.field_70146_Z.nextDouble();
                    while (randomDouble < dr) {
                        this.field_70170_p.func_72869_a("bubble", this.field_70165_t + dx * (randomDouble += 1.8 - animationProgress + this.field_70146_Z.nextDouble() * (1.7 - animationProgress)), this.field_70163_u + dy * randomDouble + (double)this.func_70047_e(), this.field_70161_v + dz * randomDouble, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (this.func_70090_H()) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.5;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70122_E = false;
            this.field_70160_al = true;
        }
        if (this.hasTargetedEntity()) {
            this.field_70177_z = this.field_70759_as;
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailAnimation(float partialTicks) {
        return this.clientSideTailAnimationO + (this.clientSideTailAnimation - this.clientSideTailAnimationO) * partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSpikesAnimation(float partialTicks) {
        return this.clientSideSpikesAnimationO + (this.clientSideSpikesAnimation - this.clientSideSpikesAnimationO) * partialTicks;
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    private <T extends Entity> List<T> getPlayers(Class<? extends T> playerType, Predicate<? super T> filter) {
        ArrayList list = Lists.newArrayList();
        for (Object entity : this.field_70170_p.field_73010_i) {
            if (!playerType.isAssignableFrom(entity.getClass()) || !filter.apply((Object)((Entity)entity))) continue;
            list.add((Entity)entity);
        }
        return list;
    }

    private boolean survivalOrAdventure(EntityPlayerMP player) {
        return player.field_71134_c.func_73081_b() == WorldSettings.GameType.SURVIVAL || player.field_71134_c.func_73081_b() == WorldSettings.GameType.ADVENTURE;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        super.func_70629_bd();
        if (this.isElder()) {
            int mfInflict = 1200;
            int mfRenew = 1200;
            int mfDuration = 6000;
            int mfLevel = 2;
            if ((this.field_70173_aa + this.func_145782_y()) % mfInflict == 0) {
                Potion potion = Potion.field_76419_f;
                Predicate<EntityPlayerMP> filter = new Predicate<EntityPlayerMP>(){

                    public boolean apply(@Nullable EntityPlayerMP player) {
                        return EntityGuardian.this.func_70068_e((Entity)player) < 2500.0 && EntityGuardian.this.survivalOrAdventure(player);
                    }
                };
                List<EntityPlayerMP> allPlayers = this.getPlayers(EntityPlayerMP.class, filter);
                for (EntityPlayerMP entityplayermp : allPlayers) {
                    if (entityplayermp.func_70644_a(potion) && entityplayermp.func_70660_b(potion).func_76458_c() >= mfLevel && entityplayermp.func_70660_b(potion).func_76459_b() >= mfRenew) continue;
                    PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                    out.writeInt(10);
                    SToCMessage packet = new SToCMessage((ByteBuf)out);
                    VillageNames.VNNetworkWrapper.sendTo((IMessage)packet, entityplayermp);
                    entityplayermp.func_70690_d(new PotionEffect(potion.field_76415_H, mfDuration, mfLevel));
                }
            }
            if (!this.func_110175_bO()) {
                this.func_110171_b((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 16);
            }
        }
    }

    public void func_70103_a(byte opCode) {
        super.func_70103_a(opCode);
        if (opCode == 21) {
            ClientProxy.handleHealthUpdate(this);
        }
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int i = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(looting + 1);
        if (i > 0) {
            this.func_70099_a(new ItemStack(ModItemsPrismarine.prismarine_shard, i, 0), 1.0f);
        }
        if (this.field_70146_Z.nextInt(3 + looting) > 1) {
            this.func_70099_a(new ItemStack(Items.field_151115_aP, 1), 1.0f);
        } else if (this.field_70146_Z.nextInt(3 + looting) > 1) {
            this.func_70099_a(new ItemStack(ModItemsPrismarine.prismarine_crystals, 1, 0), 1.0f);
        }
        if (recentlyHit && this.isElder()) {
            this.func_70099_a(new ItemStack(ModBlocksPrismarine.blockSpongeVN, 1, 1), 1.0f);
        }
    }

    public static List<WeightedRandomFishable> func_174855_j() {
        return EntityFishHook.field_146036_f;
    }

    protected void func_70600_l(int i) {
        ItemStack itemstack = ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)this.field_70146_Z, EntityGuardian.func_174855_j())).func_150708_a(this.field_70146_Z);
        this.func_70099_a(itemstack, 1.0f);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        World world = this.field_70170_p;
        int spawnX = (int)this.field_70165_t;
        int spawnY = (int)this.field_70163_u;
        int spawnZ = (int)this.field_70161_v;
        boolean canSpawnHere = world.func_147439_a(spawnX, spawnY, spawnZ).func_149688_o() == Material.field_151586_h && (this.field_70146_Z.nextInt(20) == 0 || !this.canBlockSeeSky((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.func_70814_o() && this.func_70783_a(MathHelper1122.func_76128_c((double)this.field_70165_t), MathHelper1122.func_76128_c((double)this.field_70121_D.field_72338_b), MathHelper1122.func_76128_c((double)this.field_70161_v)) >= 0.0f);
        return canSpawnHere;
    }

    public boolean canBlockSeeSky(int spawnX, int spawnY, int spawnZ) {
        if (spawnY >= 63) {
            return this.field_70170_p.func_72937_j(spawnX, spawnY, spawnZ);
        }
        if (!this.field_70170_p.func_72937_j(spawnX, 63, spawnZ)) {
            return false;
        }
        for (int y = 62; y > spawnY; --y) {
            Block block = this.field_70170_p.func_147439_a(spawnX, y, spawnZ);
            if (block.func_149717_k() <= 0 || block.func_149688_o().func_76224_d()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.isMoving() && !source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase && this.func_110143_aJ() > 0.0f) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
            }
        }
        if (this.wander != null) {
            this.wander.makeUpdate();
        }
        return super.func_70097_a(source, amount);
    }

    public int func_70646_bf() {
        return 180;
    }

    public void func_70612_e(float strafe, float forward) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.1f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (!this.isMoving() && this.func_70638_az() == null) {
                    this.field_70181_x -= 0.005;
                }
            } else {
                super.func_70612_e(strafe, forward);
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    static class GuardianLookHelper {
        private EntityGuardian entityGuardian;
        private float deltaLookYaw;
        private float deltaLookPitch;
        private boolean isLooking;
        private double posX;
        private double posY;
        private double posZ;

        public GuardianLookHelper(EntityGuardian entitylivingIn) {
            this.entityGuardian = entitylivingIn;
        }

        public void setLookPositionWithEntity(Entity entityIn, float deltaYaw, float deltaPitch) {
            this.posX = entityIn.field_70165_t;
            this.posY = entityIn instanceof EntityLivingBase ? entityIn.field_70163_u + (double)entityIn.func_70047_e() : (entityIn.field_70121_D.field_72338_b + entityIn.field_70121_D.field_72337_e) / 2.0;
            this.posZ = entityIn.field_70161_v;
            this.deltaLookYaw = deltaYaw;
            this.deltaLookPitch = deltaPitch;
            this.isLooking = true;
        }

        public void setLookPosition(double x, double y, double z, float deltaYaw, float deltaPitch) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.deltaLookYaw = deltaYaw;
            this.deltaLookPitch = deltaPitch;
            this.isLooking = true;
        }

        public void onUpdateLook() {
            this.entityGuardian.field_70125_A = 0.0f;
            if (this.isLooking) {
                this.isLooking = false;
                double d0 = this.posX - this.entityGuardian.field_70165_t;
                double d1 = this.posY - (this.entityGuardian.field_70163_u + (double)this.entityGuardian.func_70047_e());
                double d2 = this.posZ - this.entityGuardian.field_70161_v;
                double d3 = MathHelper1122.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
                this.entityGuardian.field_70125_A = this.updateRotation(this.entityGuardian.field_70125_A, f1, this.deltaLookPitch);
                this.entityGuardian.field_70759_as = this.updateRotation(this.entityGuardian.field_70759_as, f, this.deltaLookYaw);
            } else {
                this.entityGuardian.field_70759_as = this.updateRotation(this.entityGuardian.field_70759_as, this.entityGuardian.field_70761_aq, 10.0f);
            }
            float f2 = MathHelper1122.func_76142_g((float)(this.entityGuardian.field_70759_as - this.entityGuardian.field_70761_aq));
            if (!this.entityGuardian.field_70699_by.noPath()) {
                if (f2 < -75.0f) {
                    this.entityGuardian.field_70759_as = this.entityGuardian.field_70761_aq - 75.0f;
                }
                if (f2 > 75.0f) {
                    this.entityGuardian.field_70759_as = this.entityGuardian.field_70761_aq + 75.0f;
                }
            }
        }

        private float updateRotation(float angleIn, float angleTo, float limitAngle) {
            float f3 = MathHelper1122.func_76142_g((float)(angleTo - angleIn));
            if (f3 > limitAngle) {
                f3 = limitAngle;
            }
            if (f3 < -limitAngle) {
                f3 = -limitAngle;
            }
            return angleIn + f3;
        }

        public boolean getIsLooking() {
            return this.isLooking;
        }

        public double getLookPosX() {
            return this.posX;
        }

        public double getLookPosY() {
            return this.posY;
        }

        public double getLookPosZ() {
            return this.posZ;
        }

        public GuardianLookHelper getLookHelper() {
            return this.entityGuardian.field_70749_g;
        }
    }

    static class GuardianTargetSelector
    implements IEntitySelector {
        private EntityGuardian parentEntity;

        public GuardianTargetSelector(EntityGuardian guardian) {
            this.parentEntity = guardian;
        }

        public boolean func_82704_a(Entity potentialTarget) {
            return (potentialTarget instanceof EntityPlayer || potentialTarget instanceof EntitySquid) && potentialTarget.func_70068_e((Entity)this.parentEntity) > 9.0;
        }
    }

    public static class GuardianMoveHelper {
        private EntityGuardian entityGuardian;
        private double posX;
        private double posY;
        private double posZ;
        private double speed;
        private boolean update;
        private static final String __OBFID = "CL_00001573";

        public GuardianMoveHelper(EntityGuardian entityIn) {
            this.entityGuardian = entityIn;
            this.posX = entityIn.field_70165_t;
            this.posY = entityIn.field_70163_u;
            this.posZ = entityIn.field_70161_v;
        }

        public boolean isUpdating() {
            return this.update;
        }

        public double getSpeed() {
            return this.speed;
        }

        public void setMoveTo(double x, double y, double z, double speedIn) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.speed = speedIn;
            this.update = true;
        }

        public void onUpdateMoveHelper() {
            if (this.update && !this.entityGuardian.field_70699_by.noPath()) {
                double d0 = this.posX - this.entityGuardian.field_70165_t;
                double d1 = this.posY - this.entityGuardian.field_70163_u;
                double d2 = this.posZ - this.entityGuardian.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper1122.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper1122.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.limitAngle(this.entityGuardian.field_70177_z, f, 30.0f);
                float f1 = (float)(this.speed * this.entityGuardian.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityGuardian.func_70659_e(this.entityGuardian.func_70689_ay() + (f1 - this.entityGuardian.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                double d6 = Math.sin(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                this.entityGuardian.field_70159_w += d4 * d5;
                this.entityGuardian.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.75) * 0.05;
                this.entityGuardian.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityGuardian.field_70181_x += (double)this.entityGuardian.func_70689_ay() * d1 * 0.1;
                GuardianLookHelper entitylookhelper = this.entityGuardian.field_70749_g;
                double d7 = this.entityGuardian.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityGuardian.func_70047_e() + this.entityGuardian.field_70163_u + d1 / d3 * 1.0;
                double d9 = this.entityGuardian.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.getLookPosX();
                double d11 = entitylookhelper.getLookPosY();
                double d12 = entitylookhelper.getLookPosZ();
                if (!entitylookhelper.getIsLooking()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityGuardian.field_70749_g.setLookPosition(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entityGuardian.setMoving(true);
            } else {
                this.entityGuardian.func_70659_e(0.0f);
                this.entityGuardian.setMoving(false);
            }
        }

        private float limitAngle(float angleIn, float angleTo, float limitAngle) {
            float f1;
            float f3 = MathHelper1122.func_76142_g((float)(angleTo - angleIn));
            if (f3 > limitAngle) {
                f3 = limitAngle;
            }
            if (f3 < -limitAngle) {
                f3 = -limitAngle;
            }
            if ((f1 = angleIn + f3) < 0.0f) {
                f1 += 360.0f;
            } else if (f1 > 360.0f) {
                f1 -= 360.0f;
            }
            return f1;
        }

        public double getX() {
            return this.posX;
        }

        public double getY() {
            return this.posY;
        }

        public double getZ() {
            return this.posZ;
        }

        public GuardianMoveHelper getMoveHelper() {
            return this.entityGuardian.field_70765_h;
        }
    }

    static class AIGuardianAttack
    extends EntityAIBase {
        private EntityGuardian theEntity;
        private int tickCounter;

        public AIGuardianAttack(EntityGuardian entity) {
            this.theEntity = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.theEntity.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && (this.theEntity.isElder() || this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) > 9.0);
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.theEntity.field_70699_by.clearPathEntity();
            this.theEntity.field_70749_g.setLookPositionWithEntity((Entity)this.theEntity.func_70638_az(), 90.0f, 90.0f);
            this.theEntity.field_70160_al = true;
        }

        public void func_75251_c() {
            this.theEntity.setTargetedEntity(0);
            this.theEntity.func_70624_b(null);
            this.theEntity.wander.makeUpdate();
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.theEntity.func_70638_az();
            this.theEntity.field_70699_by.clearPathEntity();
            this.theEntity.field_70749_g.setLookPositionWithEntity((Entity)entitylivingbase, 90.0f, 90.0f);
            if (!this.theEntity.func_70685_l((Entity)entitylivingbase)) {
                this.theEntity.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.theEntity.setTargetedEntity(this.theEntity.func_70638_az().func_145782_y());
                    this.theEntity.field_70170_p.func_72960_a((Entity)this.theEntity, (byte)21);
                } else if (this.tickCounter >= this.theEntity.getAttackDuration()) {
                    float f = 1.0f;
                    if (this.theEntity.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    if (this.theEntity.isElder()) {
                        f += 2.0f;
                    }
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)this.theEntity, (Entity)this.theEntity), f);
                    entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.theEntity), (float)this.theEntity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.theEntity.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }
}

