/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.prismarine.guardian.entity.pathfinding;

import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.PathPointSwimmer;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class PathEntitySwimmer {
    private final PathPointSwimmer[] points;
    private int currentPathIndex;
    private int pathLength;

    public PathEntitySwimmer(PathPointSwimmer[] pathpoints) {
        this.points = pathpoints;
        this.pathLength = pathpoints.length;
    }

    public void incrementPathIndex() {
        ++this.currentPathIndex;
    }

    public boolean isFinished() {
        return this.currentPathIndex >= this.pathLength;
    }

    public PathPointSwimmer getFinalPathPoint() {
        return this.pathLength > 0 ? this.points[this.pathLength - 1] : null;
    }

    public PathPointSwimmer getPathPointFromIndex(int index) {
        return this.points[index];
    }

    public int getCurrentPathLength() {
        return this.pathLength;
    }

    public void setCurrentPathLength(int length) {
        this.pathLength = length;
    }

    public int getCurrentPathIndex() {
        return this.currentPathIndex;
    }

    public void setCurrentPathIndex(int currentPathIndexIn) {
        this.currentPathIndex = currentPathIndexIn;
    }

    public Vec3 getVectorFromIndex(Entity entityIn, int index) {
        double d0 = (double)this.points[index].xCoord + (double)((int)(entityIn.field_70130_N + 1.0f)) * 0.5;
        double d1 = this.points[index].yCoord;
        double d2 = (double)this.points[index].zCoord + (double)((int)(entityIn.field_70130_N + 1.0f)) * 0.5;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public Vec3 getPosition(Entity entityIn) {
        return this.getVectorFromIndex(entityIn, this.currentPathIndex);
    }

    public boolean isSamePath(PathEntitySwimmer pathentityIn) {
        if (pathentityIn == null) {
            return false;
        }
        if (pathentityIn.points.length != this.points.length) {
            return false;
        }
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].xCoord == pathentityIn.points[i].xCoord && this.points[i].yCoord == pathentityIn.points[i].yCoord && this.points[i].zCoord == pathentityIn.points[i].zCoord) continue;
            return false;
        }
        return true;
    }

    public boolean isDestinationSame(Vec3 vec) {
        PathPointSwimmer pathpoint = this.getFinalPathPoint();
        return pathpoint == null ? false : pathpoint.xCoord == (int)vec.field_72450_a && pathpoint.zCoord == (int)vec.field_72449_c;
    }
}

