/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.prismarine.guardian.entity.pathfinding;

import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.NodeProcessor;
import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.PathEntitySwimmer;
import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.PathPointSwimmer;
import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.PathSwimmer;
import astrotibs.villagenames.utility.BlockPos;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;

public class PathFinderSwimmer {
    private PathSwimmer path = new PathSwimmer();
    private PathPointSwimmer[] pathOptions = new PathPointSwimmer[32];
    private NodeProcessor nodeProcessor;

    public PathFinderSwimmer(NodeProcessor nodeProcessorIn) {
        this.nodeProcessor = nodeProcessorIn;
    }

    public PathEntitySwimmer createEntityPathTo(IBlockAccess blockaccess, Entity entityFrom, Entity entityTo, float dist) {
        return this.createEntityPathTo(blockaccess, entityFrom, entityTo.field_70165_t, entityTo.field_70121_D.field_72338_b, entityTo.field_70161_v, dist);
    }

    public PathEntitySwimmer createEntityPathTo(IBlockAccess blockaccess, Entity entityIn, BlockPos targetPos, float dist) {
        return this.createEntityPathTo(blockaccess, entityIn, (float)targetPos.getX() + 0.5f, (float)targetPos.getY() + 0.5f, (float)targetPos.getZ() + 0.5f, dist);
    }

    private PathEntitySwimmer createEntityPathTo(IBlockAccess blockaccess, Entity entityIn, double x, double y, double z, float distance) {
        this.path.clearPath();
        this.nodeProcessor.initProcessor(blockaccess, entityIn);
        PathPointSwimmer pathpoint = this.nodeProcessor.getPathPointTo(entityIn);
        PathPointSwimmer pathpoint1 = this.nodeProcessor.getPathPointToCoords(entityIn, x, y, z);
        PathEntitySwimmer pathentity = this.addToPath(entityIn, pathpoint, pathpoint1, distance);
        this.nodeProcessor.postProcess();
        return pathentity;
    }

    private PathEntitySwimmer addToPath(Entity entityIn, PathPointSwimmer pathpointStart, PathPointSwimmer pathpointEnd, float maxDistance) {
        pathpointStart.totalPathDistance = 0.0f;
        pathpointStart.distanceToTarget = pathpointStart.distanceToNext = pathpointStart.distanceToSquared(pathpointEnd);
        this.path.clearPath();
        this.path.addPoint(pathpointStart);
        PathPointSwimmer pathpoint = pathpointStart;
        while (!this.path.isPathEmpty()) {
            PathPointSwimmer pathpoint1 = this.path.dequeue();
            if (pathpoint1.equals(pathpointEnd)) {
                return this.createEntityPath(pathpointStart, pathpointEnd);
            }
            if (pathpoint1.distanceToSquared(pathpointEnd) < pathpoint.distanceToSquared(pathpointEnd)) {
                pathpoint = pathpoint1;
            }
            pathpoint1.visited = true;
            int i = this.nodeProcessor.findPathOptions(this.pathOptions, entityIn, pathpoint1, pathpointEnd, maxDistance);
            for (int j = 0; j < i; ++j) {
                PathPointSwimmer pathpoint2 = this.pathOptions[j];
                float f = pathpoint1.totalPathDistance + pathpoint1.distanceToSquared(pathpoint2);
                if (!(f < maxDistance * 2.0f) || pathpoint2.isAssigned() && !(f < pathpoint2.totalPathDistance)) continue;
                pathpoint2.previous = pathpoint1;
                pathpoint2.totalPathDistance = f;
                pathpoint2.distanceToNext = pathpoint2.distanceToSquared(pathpointEnd);
                if (pathpoint2.isAssigned()) {
                    this.path.changeDistance(pathpoint2, pathpoint2.totalPathDistance + pathpoint2.distanceToNext);
                    continue;
                }
                pathpoint2.distanceToTarget = pathpoint2.totalPathDistance + pathpoint2.distanceToNext;
                this.path.addPoint(pathpoint2);
            }
        }
        if (pathpoint == pathpointStart) {
            return null;
        }
        return this.createEntityPath(pathpointStart, pathpoint);
    }

    private PathEntitySwimmer createEntityPath(PathPointSwimmer start, PathPointSwimmer end) {
        int i = 1;
        PathPointSwimmer pathpoint = end;
        while (pathpoint.previous != null) {
            ++i;
            pathpoint = pathpoint.previous;
        }
        PathPointSwimmer[] apathpoint = new PathPointSwimmer[i];
        PathPointSwimmer pathpoint1 = end;
        apathpoint[--i] = end;
        while (pathpoint1.previous != null) {
            pathpoint1 = pathpoint1.previous;
            apathpoint[--i] = pathpoint1;
        }
        return new PathEntitySwimmer(apathpoint);
    }
}

