/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.prismarine.guardian.entity.pathfinding;

import astrotibs.villagenames.prismarine.guardian.entity.monster.EntityGuardian;
import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.PathEntitySwimmer;
import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.PathFinderSwimmer;
import astrotibs.villagenames.prismarine.guardian.entity.pathfinding.SwimNodeProcessor;
import astrotibs.villagenames.prismarine.guardian.util.MathHelper1122;
import astrotibs.villagenames.utility.BlockPos;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PathNavigateSwimmer {
    protected EntityGuardian theEntity;
    protected World worldObj;
    protected PathEntitySwimmer currentPath;
    protected double speed;
    private final IAttributeInstance pathSearchRange;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3 lastPosCheck = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private float heightRequirement = 1.0f;
    private final PathFinderSwimmer pathFinder;

    public PathNavigateSwimmer(EntityGuardian entitylivingIn, World worldIn) {
        this.theEntity = entitylivingIn;
        this.worldObj = worldIn;
        this.pathSearchRange = entitylivingIn.func_110148_a(SharedMonsterAttributes.field_111265_b);
        this.pathFinder = this.getPathFinder();
    }

    protected PathFinderSwimmer getPathFinder() {
        return new PathFinderSwimmer(new SwimNodeProcessor());
    }

    public void setSpeed(double speedIn) {
        this.speed = speedIn;
    }

    public float getPathSearchRange() {
        return (float)this.pathSearchRange.func_111126_e();
    }

    public final PathEntitySwimmer getPathToXYZ(double x, double y, double z) {
        return this.getPathToPos(new BlockPos(MathHelper1122.func_76128_c((double)x), (int)y, MathHelper1122.func_76128_c((double)z)));
    }

    public PathEntitySwimmer getPathToPos(BlockPos pos) {
        if (!this.canNavigate()) {
            return null;
        }
        float f = this.getPathSearchRange();
        this.worldObj.field_72984_F.func_76320_a("pathfind");
        BlockPos blockpos = new BlockPos((Entity)this.theEntity);
        int i = (int)(f + 8.0f);
        ChunkCache chunkcache = new ChunkCache(this.worldObj, blockpos.getX() - i, blockpos.getY() - i, blockpos.getZ() - i, blockpos.getX() + i, blockpos.getY() + i, blockpos.getZ() + i, 0);
        PathEntitySwimmer pathentity = this.pathFinder.createEntityPathTo((IBlockAccess)chunkcache, (Entity)this.theEntity, pos, f);
        this.worldObj.field_72984_F.func_76319_b();
        return pathentity;
    }

    public boolean tryMoveToXYZ(double x, double y, double z, double speedIn) {
        PathEntitySwimmer pathentity = this.getPathToXYZ(MathHelper1122.func_76128_c((double)x), (int)y, MathHelper1122.func_76128_c((double)z));
        return this.setPath(pathentity, speedIn);
    }

    public void setHeightRequirement(float jumpHeight) {
        this.heightRequirement = jumpHeight;
    }

    public PathEntitySwimmer getPathToEntityLiving(Entity entityIn) {
        if (!this.canNavigate()) {
            return null;
        }
        float f = this.getPathSearchRange();
        this.worldObj.field_72984_F.func_76320_a("pathfind");
        BlockPos blockpos = new BlockPos((Entity)this.theEntity).up();
        int i = (int)(f + 16.0f);
        ChunkCache chunkcache = new ChunkCache(this.worldObj, blockpos.getX() - i, blockpos.getY() - i, blockpos.getZ() - i, blockpos.getX() + i, blockpos.getY() + i, blockpos.getZ() + i, 0);
        PathEntitySwimmer pathentity = this.pathFinder.createEntityPathTo((IBlockAccess)chunkcache, (Entity)this.theEntity, entityIn, f);
        this.worldObj.field_72984_F.func_76319_b();
        return pathentity;
    }

    public boolean tryMoveToEntityLiving(Entity entityIn, double speedIn) {
        PathEntitySwimmer pathentity = this.getPathToEntityLiving(entityIn);
        return pathentity != null ? this.setPath(pathentity, speedIn) : false;
    }

    public boolean setPath(PathEntitySwimmer pathentityIn, double speedIn) {
        if (pathentityIn == null) {
            this.currentPath = null;
            return false;
        }
        if (!pathentityIn.isSamePath(this.currentPath)) {
            this.currentPath = pathentityIn;
        }
        this.removeSunnyPath();
        if (this.currentPath.getCurrentPathLength() == 0) {
            return false;
        }
        this.speed = speedIn;
        Vec3 vec3 = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck = vec3;
        return true;
    }

    public PathEntitySwimmer getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (!this.noPath()) {
            Vec3 vec32;
            if (this.canNavigate()) {
                this.pathFollow();
            } else if (this.currentPath != null && this.currentPath.getCurrentPathIndex() < this.currentPath.getCurrentPathLength()) {
                Vec3 vec3 = this.getEntityPosition();
                Vec3 vec31 = this.currentPath.getVectorFromIndex((Entity)this.theEntity, this.currentPath.getCurrentPathIndex());
                if (vec3.field_72448_b > vec31.field_72448_b && !this.theEntity.field_70122_E && MathHelper1122.func_76128_c((double)vec3.field_72450_a) == MathHelper1122.func_76128_c((double)vec31.field_72450_a) && MathHelper1122.func_76128_c((double)vec3.field_72449_c) == MathHelper1122.func_76128_c((double)vec31.field_72449_c)) {
                    this.currentPath.setCurrentPathIndex(this.currentPath.getCurrentPathIndex() + 1);
                }
            }
            if (!this.noPath() && (vec32 = this.currentPath.getPosition((Entity)this.theEntity)) != null) {
                AxisAlignedBB axisalignedbb1 = AxisAlignedBB.func_72330_a((double)vec32.field_72450_a, (double)vec32.field_72448_b, (double)vec32.field_72449_c, (double)vec32.field_72450_a, (double)vec32.field_72448_b, (double)vec32.field_72449_c).func_72314_b(0.5, 0.5, 0.5);
                List list = this.worldObj.func_72945_a((Entity)this.theEntity, axisalignedbb1.func_72321_a(0.0, -1.0, 0.0));
                double d0 = -1.0;
                axisalignedbb1 = axisalignedbb1.func_72317_d(0.0, 1.0, 0.0);
                for (AxisAlignedBB axisalignedbb : list) {
                    d0 = axisalignedbb.func_72323_b(axisalignedbb1, d0);
                }
                this.theEntity.field_70765_h.setMoveTo(vec32.field_72450_a, vec32.field_72448_b + d0, vec32.field_72449_c, this.speed);
            }
        }
    }

    protected void pathFollow() {
        Vec3 vec3 = this.getEntityPosition();
        float f = this.theEntity.field_70130_N * this.theEntity.field_70130_N;
        int i = 6;
        if (vec3.func_72436_e(this.currentPath.getVectorFromIndex((Entity)this.theEntity, this.currentPath.getCurrentPathIndex())) < (double)f) {
            this.currentPath.incrementPathIndex();
        }
        for (int j = Math.min(this.currentPath.getCurrentPathIndex() + i, this.currentPath.getCurrentPathLength() - 1); j > this.currentPath.getCurrentPathIndex(); --j) {
            Vec3 vec31 = this.currentPath.getVectorFromIndex((Entity)this.theEntity, j);
            if (!(vec31.func_72436_e(vec3) <= 36.0) || !this.isDirectPathBetweenPoints(vec3, vec31, 0, 0, 0)) continue;
            this.currentPath.setCurrentPathIndex(j);
            break;
        }
        this.checkForStuck(vec3);
    }

    protected void checkForStuck(Vec3 positionVec3) {
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (positionVec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.clearPathEntity();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = positionVec3;
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.isFinished();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    protected Vec3 getEntityPosition() {
        return Vec3.func_72443_a((double)this.theEntity.field_70165_t, (double)(this.theEntity.field_70163_u + (double)this.theEntity.field_70131_O * 0.5), (double)this.theEntity.field_70161_v);
    }

    protected boolean canNavigate() {
        return this.isInLiquid();
    }

    protected boolean isInLiquid() {
        return this.theEntity.func_70090_H() || this.theEntity.func_70058_J();
    }

    protected void removeSunnyPath() {
    }

    protected boolean isDirectPathBetweenPoints(Vec3 posVec31, Vec3 posVec32, int sizeX, int sizeY, int sizeZ) {
        MovingObjectPosition movingobjectposition = this.worldObj.func_147447_a(posVec31, Vec3.func_72443_a((double)posVec32.field_72450_a, (double)(posVec32.field_72448_b + (double)this.theEntity.field_70131_O * 0.5), (double)posVec32.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.MISS;
    }
}

