/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.prismarine.guardian.entity.pathfinding;

import astrotibs.villagenames.prismarine.guardian.util.MathHelper1122;

public class PathPointSwimmer {
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    private final int hash;
    int index = -1;
    float totalPathDistance;
    float distanceToNext;
    float distanceToTarget;
    PathPointSwimmer previous;
    public boolean visited;

    public PathPointSwimmer(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.hash = PathPointSwimmer.makeHash(x, y, z);
    }

    public static int makeHash(int x, int y, int z) {
        return y & 0xFF | (x & Short.MAX_VALUE) << 8 | (z & Short.MAX_VALUE) << 24 | (x < 0 ? Integer.MIN_VALUE : 0) | (z < 0 ? 32768 : 0);
    }

    public float distanceTo(PathPointSwimmer pathpointIn) {
        float f = pathpointIn.xCoord - this.xCoord;
        float f1 = pathpointIn.yCoord - this.yCoord;
        float f2 = pathpointIn.zCoord - this.zCoord;
        return MathHelper1122.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public float distanceToSquared(PathPointSwimmer pathpointIn) {
        float f = pathpointIn.xCoord - this.xCoord;
        float f1 = pathpointIn.yCoord - this.yCoord;
        float f2 = pathpointIn.zCoord - this.zCoord;
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean equals(Object p_equals_1_) {
        if (!(p_equals_1_ instanceof PathPointSwimmer)) {
            return false;
        }
        PathPointSwimmer pathpoint = (PathPointSwimmer)p_equals_1_;
        return this.hash == pathpoint.hash && this.xCoord == pathpoint.xCoord && this.yCoord == pathpoint.yCoord && this.zCoord == pathpoint.zCoord;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAssigned() {
        return this.index >= 0;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord;
    }
}

