/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.prismarine.guardian.spawning;

import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.prismarine.guardian.entity.monster.EntityGuardian;
import astrotibs.villagenames.prismarine.monument.StructureOceanMonument;
import astrotibs.villagenames.utility.LogHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.world.WorldEvent;

public class SpawnEventListener {
    public static final EnumCreatureType waterMonster = EnumHelper.addCreatureType((String)"waterMonster", IMob.class, (int)EnumCreatureType.monster.func_75601_b(), (Material)Material.field_151586_h, (boolean)false, (boolean)false);
    private HashMap eligibleChunksForSpawning = new HashMap();

    @SubscribeEvent(receiveCanceled=true)
    public void guardianSpawnerAndCap(WorldEvent.PotentialSpawns event) {
        int countMonsterType = event.world.countEntities(EnumCreatureType.monster, true);
        int countWaterMonsterType = event.world.countEntities(waterMonster, true);
        if ((event.type == EnumCreatureType.monster || event.type == waterMonster) && this.capMonsterSpawns(event.world, countMonsterType, countWaterMonsterType, true, true)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
        if (event.world.func_72912_H().func_76076_i() == 0 && event.world.func_72912_H().func_76089_r() && event.type == waterMonster && GeneralConfigHandler.addOceanMonuments && this.isIntersectingWithAnyMonument(event)) {
            this.getPossibleMonumentCreatures(event);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void retroGenElders(WorldEvent.Load event) {
        block6: {
            if (event.world.field_73011_w.field_76574_g == 0) {
                World world = event.world;
                try {
                    MapGenStructureData structureData = (MapGenStructureData)event.world.perWorldStorage.func_75742_a(MapGenStructureData.class, "Monument");
                    NBTTagCompound nbttagcompound = structureData.func_143041_a();
                    for (Object element : nbttagcompound.func_150296_c()) {
                        try {
                            NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                            if (nbtbase.func_74732_a() != 10) continue;
                            NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                            int[] boundingBoxIA = nbttagcompound2.func_74759_k("BB");
                            StructureBoundingBox boundingBox = new StructureBoundingBox(boundingBoxIA);
                            boolean hasHadElders = nbttagcompound2.func_74767_n("ElderGen");
                            if (hasHadElders) continue;
                            int coordBaseMode = nbttagcompound2.func_150295_c("Children", 10).func_150305_b(0).func_74762_e("O");
                            int chunkXPos = nbttagcompound2.func_74762_e("ChunkX");
                            int chunkZPos = nbttagcompound2.func_74762_e("ChunkZ");
                            int i = (chunkXPos << 4) + 8;
                            int j = (chunkZPos << 4) + 8;
                            double monumentXCenter = (double)(boundingBox.field_78893_d + boundingBox.field_78897_a) / 2.0;
                            double monumentZCenter = (double)(boundingBox.field_78892_f + boundingBox.field_78896_c) / 2.0;
                            this.spawnElder(event.world, boundingBox, monumentXCenter, 53.0, monumentZCenter);
                            int seedOffset = (int)world.func_72905_C() % 2;
                            this.spawnElder(event.world, boundingBox, monumentXCenter + (coordBaseMode % 2 == 0 ? 16.5 : 13.5) * (coordBaseMode > 1 ? -1.0 : 1.0), seedOffset == 0 ? 45.0 : 41.0, monumentZCenter + (coordBaseMode % 2 == 0 ? 13.5 : 16.5) * (Math.abs(2 * coordBaseMode - 3) > 2 ? -1.0 : 1.0));
                            this.spawnElder(event.world, boundingBox, monumentXCenter + (coordBaseMode % 2 == 0 ? 16.5 : 13.5) * (Math.abs(2 * coordBaseMode - 3) > 2 ? -1.0 : 1.0), seedOffset == 0 ? 41.0 : 45.0, monumentZCenter + (coordBaseMode % 2 == 0 ? 13.5 : 16.5) * (coordBaseMode < 2 ? -1.0 : 1.0));
                            nbttagcompound2.func_74757_a("ElderGen", true);
                            structureData.func_76186_a(true);
                        }
                        catch (Exception e) {
                            LogHelper.warn("Failed to evaluate Elder Guardian status of Monument");
                        }
                    }
                }
                catch (Exception e) {
                    if (!GeneralConfigHandler.debugMessages) break block6;
                    LogHelper.warn("Failed to load Monument list, or none exists.");
                }
            }
        }
    }

    protected boolean spawnElder(World worldIn, StructureBoundingBox bb, double x, double y, double z) {
        if (bb.func_78890_b((int)x, (int)y, (int)z)) {
            EntityGuardian elderGuardian = new EntityGuardian(worldIn);
            elderGuardian.setElder(true);
            elderGuardian.func_70691_i(elderGuardian.func_110138_aP());
            elderGuardian.func_70012_b(x + 0.5, y, z + 0.5, 0.0f, 0.0f);
            elderGuardian.func_110161_a(null);
            int i = MathHelper.func_76128_c((double)(elderGuardian.field_70165_t / 16.0));
            int j = MathHelper.func_76128_c((double)(elderGuardian.field_70161_v / 16.0));
            boolean flag = elderGuardian.field_98038_p;
            worldIn.func_72964_e(i, j).func_76612_a((Entity)elderGuardian);
            worldIn.field_72996_f.add(elderGuardian);
            worldIn.func_72923_a((Entity)elderGuardian);
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("Elder Guardian retroactively spawned at " + (x + 0.5) + " " + y + " " + (z + 0.5));
            }
            return true;
        }
        return false;
    }

    public boolean isIntersectingWithAnyMonument(WorldEvent.PotentialSpawns event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            try {
                MapGenStructureData structureData = (MapGenStructureData)event.world.perWorldStorage.func_75742_a(MapGenStructureData.class, "Monument");
                NBTTagCompound nbttagcompound = structureData.func_143041_a();
                for (Object element : nbttagcompound.func_150296_c()) {
                    NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                    if (nbtbase.func_74732_a() != 10) continue;
                    NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                    try {
                        int[] boundingBox = nbttagcompound2.func_74759_k("BB");
                        if (event.x < boundingBox[0] || event.y < boundingBox[1] || event.z < boundingBox[2] || event.x > boundingBox[3] || event.y > boundingBox[4] || event.z > boundingBox[5]) continue;
                        return true;
                    }
                    catch (Exception e) {
                        LogHelper.warn("Failed to evaluate Monument bounding box");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void getPossibleMonumentCreatures(WorldEvent.PotentialSpawns event) {
        List<BiomeGenBase.SpawnListEntry> monumentMonsters = StructureOceanMonument.getMonsters();
        event.list.clear();
        for (int i = 0; i < monumentMonsters.size(); ++i) {
            event.list.add(monumentMonsters.get(i));
        }
    }

    public boolean capMonsterSpawns(World worldIn, int typeMonsterCount, int typeWaterMonsterCount, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return true;
        }
        this.eligibleChunksForSpawning.clear();
        for (int playerInd = 0; playerInd < worldIn.field_73010_i.size(); ++playerInd) {
            EntityPlayer entityplayer = (EntityPlayer)worldIn.field_73010_i.get(playerInd);
            int playerChunkX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int playerChunkZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int chunkRadius = 8;
            for (int searchCX = -chunkRadius; searchCX <= chunkRadius; ++searchCX) {
                for (int searchCZ = -chunkRadius; searchCZ <= chunkRadius; ++searchCZ) {
                    boolean isOnSearchBoundary = searchCX == -chunkRadius || searchCX == chunkRadius || searchCZ == -chunkRadius || searchCZ == chunkRadius;
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(searchCX + playerChunkX, searchCZ + playerChunkZ);
                    if (!isOnSearchBoundary) {
                        this.eligibleChunksForSpawning.put(chunkcoordintpair, false);
                        continue;
                    }
                    if (this.eligibleChunksForSpawning.containsKey(chunkcoordintpair)) continue;
                    this.eligibleChunksForSpawning.put(chunkcoordintpair, true);
                }
            }
        }
        return spawnHostileMobs && typeMonsterCount + typeWaterMonsterCount > EnumCreatureType.monster.func_75601_b() * this.eligibleChunksForSpawning.size() / 256;
    }
}

