/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.prismarine.monument;

import astrotibs.villagenames.prismarine.guardian.entity.monster.EntityGuardian;
import astrotibs.villagenames.prismarine.minecraft.EnumFacing189;
import astrotibs.villagenames.prismarine.monument.StructureOceanMonumentPieces;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;

public class StructureOceanMonument
extends MapGenStructure {
    private static int field_175800_f;
    private static int field_175801_g;
    public static final List<BiomeGenBase> field_175802_d;
    public static final int[] waterBiomesInt;
    private static final List<BiomeGenBase.SpawnListEntry> MONUMENT_ENEMIES;

    public StructureOceanMonument() {
        field_175800_f = 32;
        field_175801_g = 5;
    }

    public StructureOceanMonument(Map<String, String> p_i45608_1_) {
        this();
        for (Map.Entry<String, String> entry : p_i45608_1_.entrySet()) {
            if (entry.getKey().equals("spacing")) {
                field_175800_f = MathHelper.func_82714_a((String)entry.getValue(), (int)field_175800_f, (int)1);
                continue;
            }
            if (!entry.getKey().equals("separation")) continue;
            field_175801_g = MathHelper.func_82714_a((String)entry.getValue(), (int)field_175801_g, (int)1);
        }
    }

    public String func_143025_a() {
        return "Monument";
    }

    protected static boolean canSpawnStructureAtCoords(World worldIn, int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= field_175800_f - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= field_175800_f - 1;
        }
        int k = chunkX / field_175800_f;
        int l = chunkZ / field_175800_f;
        Random random = worldIn.func_72843_D(k, l, 10387313);
        k *= field_175800_f;
        l *= field_175800_f;
        if (i == (k += (random.nextInt(field_175800_f - field_175801_g) + random.nextInt(field_175800_f - field_175801_g)) / 2) && j == (l += (random.nextInt(field_175800_f - field_175801_g) + random.nextInt(field_175800_f - field_175801_g)) / 2)) {
            if (!StructureOceanMonument.areBiomesViableVN(i * 16 + 8, j * 16 + 8, 16, new String[]{"deepocean", "deep ocean"}, worldIn)) {
                return false;
            }
            boolean flag = StructureOceanMonument.areBiomesViableVN(i * 16 + 8, j * 16 + 8, 29, new String[]{"ocean", "river"}, worldIn);
            if (flag) {
                return true;
            }
        }
        return false;
    }

    public static boolean areBiomesViableVN(int xChunkCenter, int zChunkCenter, int radius, String[] allowedBiomes, World worldIn) {
        IntCache.func_76446_a();
        int l = xChunkCenter - (radius >> 2);
        int i1 = zChunkCenter - (radius >> 2);
        int j1 = xChunkCenter + (radius >> 2);
        int k1 = zChunkCenter + (radius >> 2);
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int strNumber = 0;
        String biomeStr = "";
        int breakFlag = -1;
        try {
            for (int ind = 0; ind < l1 * i2; ++ind) {
                breakFlag = -1;
                biomeStr = worldIn.func_72807_a((int)(l + ind / l1), (int)(i1 + ind % i2)).field_76791_y.toLowerCase();
                for (strNumber = 0; strNumber < allowedBiomes.length; ++strNumber) {
                    int biomeSearchCompare = Math.max(biomeStr.indexOf(allowedBiomes[strNumber]), breakFlag);
                    if (breakFlag >= 0) break;
                    breakFlag = biomeSearchCompare;
                }
                if (breakFlag >= 0) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("x", (Object)xChunkCenter);
            crashreportcategory.func_71507_a("z", (Object)zChunkCenter);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            throw new ReportedException(crashreport);
        }
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new StartMonument(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static List<BiomeGenBase.SpawnListEntry> getMonsters() {
        return MONUMENT_ENEMIES;
    }

    public boolean func_75047_a(int chunkX, int chunkZ) {
        return StructureOceanMonument.canSpawnStructureAtCoords(this.field_75039_c, chunkX, chunkZ);
    }

    static {
        field_175802_d = Arrays.asList(BiomeGenBase.field_76771_b, BiomeGenBase.field_150575_M, BiomeGenBase.field_76781_i, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m);
        waterBiomesInt = new int[]{BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_76776_l.field_76756_M, BiomeGenBase.field_76777_m.field_76756_M};
        MONUMENT_ENEMIES = Lists.newArrayList();
        MONUMENT_ENEMIES.add(new BiomeGenBase.SpawnListEntry(EntityGuardian.class, 1, 2, 4));
    }

    public static class StartMonument
    extends StructureStart {
        private Set<ChunkCoordIntPair> field_175791_c = Sets.newHashSet();
        private boolean field_175790_d;
        private boolean func_175788_a_toggle = true;

        public StartMonument() {
        }

        public StartMonument(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.func_175789_b(worldIn, random, chunkX, chunkZ);
        }

        private void func_175789_b(World worldIn, Random random, int chunkX, int chunkZ) {
            random.setSeed(worldIn.func_72905_C());
            long i = random.nextLong();
            long j = random.nextLong();
            long k = (long)chunkX * i;
            long l = (long)chunkZ * j;
            random.setSeed(k ^ l ^ worldIn.func_72905_C());
            int i1 = chunkX * 16 + 8 - 29;
            int j1 = chunkZ * 16 + 8 - 29;
            EnumFacing189 enumfacing = EnumFacing189.Plane.HORIZONTAL.random(random);
            this.field_75075_a.add(new StructureOceanMonumentPieces.MonumentBuilding(random, i1, j1, enumfacing));
            this.func_75072_c();
            this.field_175790_d = true;
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            ChunkCoordIntPair chunkCoord = new ChunkCoordIntPair(structurebb.field_78897_a - 8 >> 4, structurebb.field_78896_c - 8 >> 4);
            if (!this.field_175790_d) {
                this.field_75075_a.clear();
                this.func_175789_b(worldIn, rand, this.func_143019_e(), this.func_143018_f());
            }
            this.func_175787_b(chunkCoord);
            super.func_75068_a(worldIn, rand, structurebb);
        }

        public boolean func_75069_d() {
            return this.func_175788_a_toggle;
        }

        public boolean func_175788_a(ChunkCoordIntPair pair) {
            return !this.field_175791_c.contains(pair);
        }

        public void func_175787_b(ChunkCoordIntPair pair) {
            this.field_175791_c.add(pair);
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            NBTTagList nbttaglist = new NBTTagList();
            for (ChunkCoordIntPair chunkcoordintpair : this.field_175791_c) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("X", chunkcoordintpair.field_77276_a);
                nbttagcompound.func_74768_a("Z", chunkcoordintpair.field_77275_b);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            tagCompound.func_74782_a("Processed", (NBTBase)nbttaglist);
            tagCompound.func_74757_a("ElderGen", true);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            if (tagCompound.func_150297_b("Processed", 9)) {
                NBTTagList nbttaglist = tagCompound.func_150295_c("Processed", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    this.field_175791_c.add(new ChunkCoordIntPair(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Z")));
                }
            }
        }
    }
}

