/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.sounds;

import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventSounds {
    float witchVol = 1.0f;
    float squidvol = -1.0f;
    private double enderEyeSoundRadius = 18.0;

    @SubscribeEvent
    public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && GeneralConfigHandler.witchSounds) {
            if (event.name.equals("mob.witch.idle")) {
                event.entity.func_85030_a("VillageNames:entity.witch.ambient", this.witchVol, 1.0f);
            } else if (event.name.equals("mob.witch.hurt")) {
                event.entity.func_85030_a("VillageNames:entity.witch.hurt", this.witchVol, 1.0f);
            } else if (event.name.equals("mob.witch.death")) {
                event.entity.func_85030_a("VillageNames:entity.witch.death", this.witchVol, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K) {
            if (event.source.field_76373_n.equals("thorns") && GeneralConfigHandler.thornsSound) {
                event.source.func_76346_g().func_85030_a("VillageNames:enchant.thorns", 0.5f, 1.0f);
            } else if (event.entity instanceof EntitySquid && ((EntityLiving)event.entity).func_110143_aJ() - event.ammount > 0.0f && GeneralConfigHandler.squidSounds) {
                if (this.squidvol < 0.0f || this.squidvol > 1.0f) {
                    this.getSquidVolume((LivingEvent)event);
                }
                event.entity.func_85030_a("VillageNames:entity.squid.hurt", this.squidvol, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K && event.entity instanceof EntitySquid && GeneralConfigHandler.squidSounds) {
            if (this.squidvol < 0.0f || this.squidvol > 1.0f) {
                this.getSquidVolume((LivingEvent)event);
            }
            event.entity.func_85030_a("VillageNames:entity.squid.death", this.squidvol, 1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K) {
            if (event.entity instanceof EntitySquid && GeneralConfigHandler.squidSounds) {
                Random rand;
                block13: {
                    if (this.squidvol < 0.0f || this.squidvol > 1.0f) {
                        this.getSquidVolume((LivingEvent)event);
                    }
                    try {
                        rand = (Random)ReflectionHelper.getPrivateValue(Entity.class, (Object)event.entity, (String[])new String[]{"rand", "field_70146_Z"});
                    }
                    catch (Exception e) {
                        rand = event.entity.field_70170_p.field_73012_v;
                        if (!GeneralConfigHandler.debugMessages) break block13;
                        LogHelper.warn("Could not reflect Entity.rand field");
                    }
                }
                if (event.entity.func_70089_S() && rand.nextInt(1000) < ((EntityLiving)event.entityLiving).field_70757_a++) {
                    event.entity.func_85030_a("VillageNames:entity.squid.ambient", this.squidvol, 1.0f);
                    ((EntityLiving)event.entityLiving).field_70757_a = -((EntityLiving)event.entityLiving).func_70627_aG();
                }
            } else if (GeneralConfigHandler.enderSounds && event.entity instanceof EntityPlayerMP) {
                ArrayList allPlayers = Lists.newArrayList();
                for (Object entity : event.entity.field_70170_p.field_73010_i) {
                    if (!EntityPlayerMP.class.isAssignableFrom(entity.getClass())) continue;
                    allPlayers.add((EntityPlayerMP)entity);
                }
                for (EntityPlayerMP entityplayermp : allPlayers) {
                    World world = event.entity.field_70170_p;
                    List listEnderEyesInRange = world.func_72872_a(EntityEnderEye.class, AxisAlignedBB.func_72330_a((double)(entityplayermp.field_70165_t - this.enderEyeSoundRadius), (double)(entityplayermp.field_70163_u - this.enderEyeSoundRadius), (double)(entityplayermp.field_70161_v - this.enderEyeSoundRadius), (double)(entityplayermp.field_70165_t + this.enderEyeSoundRadius), (double)(entityplayermp.field_70163_u + this.enderEyeSoundRadius), (double)(entityplayermp.field_70161_v + this.enderEyeSoundRadius)));
                    if (listEnderEyesInRange == null) continue;
                    for (EntityEnderEye entityendereye : listEnderEyesInRange) {
                        List listPlayersInRange;
                        double eyeX = entityendereye.field_70165_t;
                        double eyeY = entityendereye.field_70163_u;
                        double eyeZ = entityendereye.field_70161_v;
                        int despawnTimer = -1;
                        if (!((entityplayermp.field_70165_t - eyeX) * (entityplayermp.field_70165_t - eyeX) + (entityplayermp.field_70163_u - eyeY) * (entityplayermp.field_70163_u - eyeY) + (entityplayermp.field_70161_v - eyeZ) * (entityplayermp.field_70161_v - eyeZ) <= this.enderEyeSoundRadius * this.enderEyeSoundRadius)) continue;
                        try {
                            despawnTimer = (Integer)ReflectionHelper.getPrivateValue(EntityEnderEye.class, (Object)entityendereye, (String[])new String[]{"despawnTimer", "field_70223_e"});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (despawnTimer != 80 || entityplayermp != (listPlayersInRange = world.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)(eyeX - this.enderEyeSoundRadius), (double)(eyeY - this.enderEyeSoundRadius), (double)(eyeZ - this.enderEyeSoundRadius), (double)(eyeX + this.enderEyeSoundRadius), (double)(eyeY + this.enderEyeSoundRadius), (double)(eyeZ + this.enderEyeSoundRadius)))).get(0)) continue;
                        entityplayermp.field_70170_p.func_72908_a(eyeX + 0.5, eyeY + 0.5, eyeZ + 0.5, "VillageNames:entity.endereye.dead", 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttackEntityEvent(AttackEntityEvent event) {
        if (!event.target.field_70170_p.field_72995_K) {
            if (event.target instanceof EntityItemFrame && GeneralConfigHandler.hangingSounds) {
                EntityItemFrame itemframe = (EntityItemFrame)event.target;
                if (itemframe.func_82335_i() != null) {
                    event.target.func_85030_a("VillageNames:entity.itemframe.remove_item", 1.0f, 1.0f);
                } else {
                    event.target.func_85030_a("VillageNames:entity.itemframe.break", 1.0f, 1.0f);
                }
            } else if (event.target instanceof EntityLeashKnot && GeneralConfigHandler.hangingSounds) {
                event.target.func_85030_a("VillageNames:entity.leashknot.break", 1.0f, 1.0f);
            } else if (event.target instanceof EntityHanging && GeneralConfigHandler.hangingSounds) {
                event.target.func_85030_a("VillageNames:entity.painting.break", 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            if (EventSounds.isPlayerLeadingAnimal(event.entityPlayer, event.world, event.x, event.y, event.z) && GeneralConfigHandler.hangingSounds && event.world.func_147439_a(event.x, event.y, event.z).func_149645_b() == 11 && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                event.world.func_72908_a((double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, "VillageNames:entity.leashknot.place", 1.0f, 1.0f);
            } else if (event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() == Items.field_151160_bD && GeneralConfigHandler.hangingSounds && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.face >= 2 && event.face <= 5) {
                event.entity.field_70170_p.func_72908_a((double)event.x + 0.5 + (event.face == 4 ? -0.6 : (event.face == 5 ? 0.6 : 0.0)), (double)event.y + 0.5, (double)event.z + 0.5 + (event.face == 2 ? -0.6 : (event.face == 3 ? 0.6 : 0.0)), "VillageNames:entity.itemframe.place", 1.0f, 1.0f);
            } else if (event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() == Items.field_151159_an && GeneralConfigHandler.hangingSounds && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.face >= 2 && event.face <= 5) {
                event.entity.field_70170_p.func_72908_a((double)event.x + 0.5 + (event.face == 4 ? -0.6 : (event.face == 5 ? 0.6 : 0.0)), (double)event.y + 0.5, (double)event.z + 0.5 + (event.face == 2 ? -0.6 : (event.face == 3 ? 0.6 : 0.0)), "VillageNames:entity.painting.place", 1.0f, 1.0f);
            } else if (event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() == Items.field_151061_bv && GeneralConfigHandler.enderSounds && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.world.func_147439_a(event.x, event.y, event.z) == Blocks.field_150378_br) {
                BlockEndPortalFrame cfr_ignored_0 = (BlockEndPortalFrame)event.world.func_147439_a(event.x, event.y, event.z);
                if (!BlockEndPortalFrame.func_150020_b((int)event.world.func_72805_g(event.x, event.y, event.z))) {
                    event.entity.field_70170_p.func_72908_a((double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, "VillageNames:block.end_portal.eyeplace", 1.0f, 1.0f);
                    Integer[] portalCenter = this.endPortalTriggering(event.world, event.x, event.y, event.z);
                    if (portalCenter != null) {
                        event.world.func_72908_a((double)portalCenter[0].intValue() + 0.5, (double)portalCenter[1].intValue() + 0.5, (double)portalCenter[2].intValue() + 0.5, "VillageNames:block.end_portal.endportal", 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(EntityInteractEvent event) {
        if (!event.target.field_70170_p.field_72995_K) {
            if (event.target instanceof EntityCow && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() == Items.field_151133_ar && !event.entityPlayer.field_71075_bZ.field_75098_d && GeneralConfigHandler.bucketSounds) {
                event.target.field_70170_p.func_72908_a(event.target.field_70165_t, event.target.field_70163_u, event.target.field_70161_v, "VillageNames:entity.cow.milk", 1.0f, 1.0f);
            } else if (event.target instanceof EntityItemFrame && GeneralConfigHandler.hangingSounds) {
                EntityItemFrame itemframe = (EntityItemFrame)event.target;
                if (event.entityPlayer.func_70694_bm() != null && itemframe.func_82335_i() == null) {
                    event.target.field_70170_p.func_72908_a(event.target.field_70165_t + 0.5, event.target.field_70163_u + 0.5, event.target.field_70161_v + 0.5, "VillageNames:entity.itemframe.add_item", 1.0f, 1.0f);
                } else if (itemframe.func_82335_i() != null) {
                    event.target.field_70170_p.func_72908_a(event.target.field_70165_t + 0.5, event.target.field_70163_u + 0.5, event.target.field_70161_v + 0.5, "VillageNames:entity.itemframe.rotate_item", 1.0f, 1.0f);
                }
            } else if (event.target instanceof EntityLeashKnot && GeneralConfigHandler.hangingSounds) {
                event.target.field_70170_p.func_72908_a(event.target.field_70165_t + 0.5, event.target.field_70163_u + 0.5, event.target.field_70161_v + 0.5, "VillageNames:entity.leashknot.break", 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && GeneralConfigHandler.enderSounds && event.entity instanceof EntityEnderEye) {
            event.world.func_72908_a(event.entity.field_70165_t + 0.5, event.entity.field_70163_u + 0.5, event.entity.field_70161_v + 0.5, "VillageNames:entity.endereye.endereye_launch", 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onFillBucketEvent(FillBucketEvent event) {
        Block isFull = Blocks.field_150350_a;
        try {
            isFull = (Block)ReflectionHelper.getPrivateValue(ItemBucket.class, (Object)((ItemBucket)event.current.func_77973_b()), (String[])new String[]{"isFull", "field_77876_a"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!event.world.field_72995_K) {
            if (GeneralConfigHandler.bucketSounds && event.current.func_77973_b() == Items.field_151131_as) {
                event.world.func_72908_a((double)event.target.field_72311_b + 0.5, (double)event.target.field_72312_c + 0.5, (double)event.target.field_72309_d + 0.5, "VillageNames:item.bucket.pour_water", 1.0f, 1.0f);
            } else if (GeneralConfigHandler.bucketSounds && isFull != Blocks.field_150350_a) {
                event.world.func_72908_a((double)event.target.field_72311_b + 0.5, (double)event.target.field_72312_c + 0.5, (double)event.target.field_72309_d + 0.5, "VillageNames:item.bucket.pour_lava", 1.0f, 1.0f);
            } else if (GeneralConfigHandler.bucketSounds && event.current.func_77973_b() == Items.field_151133_ar && event.world.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d).func_149688_o() == Material.field_151586_h) {
                event.world.func_72908_a((double)event.target.field_72311_b + 0.5, (double)event.target.field_72312_c + 0.5, (double)event.target.field_72309_d + 0.5, "VillageNames:item.bucket.fill_water", 1.0f, 1.0f);
            } else if (GeneralConfigHandler.bucketSounds && event.current.func_77973_b() == Items.field_151133_ar && event.world.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d).func_149688_o().func_76224_d()) {
                event.world.func_72908_a((double)event.target.field_72311_b + 0.5, (double)event.target.field_72312_c + 0.5, (double)event.target.field_72309_d + 0.5, "VillageNames:item.bucket.fill_lava", 1.0f, 1.0f);
            }
        }
    }

    public static boolean isPlayerLeadingAnimal(EntityPlayer player, World world, int posX, int posY, int posZ) {
        EntityLeashKnot entityleashknot = EntityLeashKnot.func_110130_b((World)world, (int)posX, (int)posY, (int)posZ);
        boolean flag = false;
        double boxRadius = 7.0;
        List list = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)((double)posX - boxRadius), (double)((double)posY - boxRadius), (double)((double)posZ - boxRadius), (double)((double)posX + boxRadius), (double)((double)posY + boxRadius), (double)((double)posZ + boxRadius)));
        if (list != null) {
            for (EntityLiving entityliving : list) {
                if (!entityliving.func_110167_bD() || entityliving.func_110166_bE() != player) continue;
                if (entityleashknot == null) {
                    flag = true;
                    continue;
                }
                flag = false;
            }
        }
        return flag;
    }

    private void getSquidVolume(LivingEvent event) {
        block2: {
            try {
                Method squidvolm = ReflectionHelper.findMethod(EntitySquid.class, (Object)((EntitySquid)event.entity), (String[])new String[]{"getSoundVolume", "func_70599_aP"}, (Class[])new Class[0]);
                this.squidvol = ((Float)squidvolm.invoke((Object)((EntitySquid)event.entity), new Object[0])).floatValue();
            }
            catch (Exception e) {
                this.squidvol = 0.4f;
                if (!GeneralConfigHandler.debugMessages) break block2;
                LogHelper.warn("Could not reflect EntitySquid.getSoundVolume method");
            }
        }
    }

    private Integer[] endPortalTriggering(World world, int blockX, int blockY, int blockZ) {
        Block targetBlock = world.func_147439_a(blockX, blockY, blockZ);
        int targetMeta = world.func_72805_g(blockX, blockY, blockZ);
        if (targetBlock == Blocks.field_150378_br && (targetMeta & 4) == 0) {
            int portalCenterOffsetX;
            Integer[] xOffsetsToScan = new Integer[]{0, 1, 2, 2, 2, 1, 0, -1, -2, -2, -2, -1};
            Integer[] zOffsetsToScan = new Integer[]{-2, -2, -1, 0, 1, 2, 2, 2, 1, 0, -1, -2};
            Integer[] metaRequired = new Integer[]{4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 4};
            int n = targetMeta == 3 ? 2 : (portalCenterOffsetX = targetMeta == 1 ? -2 : 0);
            int portalCenterOffsetZ = targetMeta == 0 ? 2 : (targetMeta == 2 ? -2 : 0);
            Block possibleFrameBlock = null;
            int possibleFrameMeta = -1;
            for (int nudge = -1; nudge <= 1; ++nudge) {
                int portalCenterOffsetNudgeX = targetMeta % 2 == 0 ? nudge : 0;
                int portalCenterOffsetNudgeZ = (targetMeta + 1) % 2 == 0 ? nudge : 0;
                int eyedCorrectFramePieces = 0;
                int uneyedCorrectFramePieces = 0;
                for (int i = 0; i < xOffsetsToScan.length; ++i) {
                    possibleFrameBlock = world.func_147439_a(blockX + portalCenterOffsetX + xOffsetsToScan[i] + portalCenterOffsetNudgeX, blockY, blockZ + portalCenterOffsetZ + zOffsetsToScan[i] + portalCenterOffsetNudgeZ);
                    possibleFrameMeta = world.func_72805_g(blockX + portalCenterOffsetX + xOffsetsToScan[i] + portalCenterOffsetNudgeX, blockY, blockZ + portalCenterOffsetZ + zOffsetsToScan[i] + portalCenterOffsetNudgeZ);
                    if (possibleFrameBlock != Blocks.field_150378_br) continue;
                    if (possibleFrameMeta == metaRequired[i]) {
                        ++eyedCorrectFramePieces;
                        continue;
                    }
                    if (possibleFrameMeta != metaRequired[i] - 4) break;
                    ++uneyedCorrectFramePieces;
                }
                if (eyedCorrectFramePieces != 11 || uneyedCorrectFramePieces != true) continue;
                return new Integer[]{blockX + portalCenterOffsetX + portalCenterOffsetNudgeX, blockY, blockZ + portalCenterOffsetZ + portalCenterOffsetNudgeZ};
            }
        }
        return null;
    }
}

