/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.structure;

import astrotibs.villagenames.structure.IStructureGenProvider;
import astrotibs.villagenames.structure.IStructureNamer;
import astrotibs.villagenames.utility.LogHelper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenStructure;

public class StructureRegistry {
    public static final StructureRegistry instance = new StructureRegistry();
    private List<IStructureNamer> names = Lists.newArrayList();
    private List<IStructureGenProvider> providers;

    private static <T> void addMapGen(Collection<MapGenStructure> output, Class<T> klazz, T provider, String ... names) {
        try {
            MapGenStructure struct = (MapGenStructure)ReflectionHelper.getPrivateValue(klazz, provider, (String[])names);
            if (struct != null) {
                output.add(struct);
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            LogHelper.warn("Can't access fields %s from provider %s. Some structures may not be detected");
        }
    }

    private StructureRegistry() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new IStructureGenProvider(){

            @Override
            public boolean canUseOnProvider(IChunkProvider provider) {
                return provider instanceof ChunkProviderGenerate;
            }

            @Override
            public Collection<MapGenStructure> listProviders(IChunkProvider provider) {
                ChunkProviderGenerate cp = (ChunkProviderGenerate)provider;
                ArrayList result = Lists.newArrayList();
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"strongholdGenerator", "field_73225_u"});
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"villageGenerator", "field_73224_v"});
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"mineshaftGenerator", "field_73223_w"});
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"scatteredFeatureGenerator", "field_73233_x"});
                return result;
            }
        });
        builder.add((Object)new IStructureGenProvider(){

            @Override
            public boolean canUseOnProvider(IChunkProvider provider) {
                return provider instanceof ChunkProviderFlat;
            }

            @Override
            public Collection<MapGenStructure> listProviders(IChunkProvider provider) {
                ChunkProviderFlat cp = (ChunkProviderFlat)provider;
                ArrayList result = Lists.newArrayList();
                try {
                    List gen = (List)ReflectionHelper.getPrivateValue(ChunkProviderFlat.class, (Object)cp, (String[])new String[]{"structureGenerators", "field_82696_f"});
                    if (gen != null) {
                        result.addAll(gen);
                    }
                }
                catch (ReflectionHelper.UnableToAccessFieldException e) {
                    LogHelper.warn("Can't access map gen list from provider %s. Some structures may not be detected");
                }
                return result;
            }
        });
        builder.add((Object)new IStructureGenProvider(){

            @Override
            public boolean canUseOnProvider(IChunkProvider provider) {
                return provider instanceof ChunkProviderHell;
            }

            @Override
            public Collection<MapGenStructure> listProviders(IChunkProvider provider) {
                ChunkProviderHell cp = (ChunkProviderHell)provider;
                ArrayList result = Lists.newArrayList();
                StructureRegistry.addMapGen(result, ChunkProviderHell.class, cp, new String[]{"genNetherBridge", "field_73172_c"});
                return result;
            }
        });
        this.providers = builder.build();
    }

    private static IChunkProvider getWrappedChunkProvider(ChunkProviderServer provider) {
        try {
            return provider.field_73246_d;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            LogHelper.error("Can't access chunk provider data. No structures will be detected");
            return null;
        }
    }

    private void visitStructures(WorldServer world, IStructureVisitor visitor) {
        ChunkProviderServer provider = world.field_73059_b;
        IChunkProvider inner = StructureRegistry.getWrappedChunkProvider(provider);
        if (inner != null) {
            for (IStructureGenProvider p : this.providers) {
                if (!p.canUseOnProvider(inner)) continue;
                for (MapGenStructure struct : p.listProviders(inner)) {
                    visitor.visit(struct);
                }
            }
        }
    }

    private String identifyStructure(MapGenStructure structure) {
        for (IStructureNamer n : this.names) {
            String name = n.identify(structure);
            if (Strings.isNullOrEmpty((String)name)) continue;
            return name;
        }
        return structure.func_143025_a();
    }

    public Map<String, ChunkPosition> getNearestStructures(final WorldServer world, final int x, final int y, final int z) {
        final ImmutableMap.Builder result = ImmutableMap.builder();
        this.visitStructures(world, new IStructureVisitor(){

            @Override
            public void visit(MapGenStructure structure) {
                try {
                    String structType;
                    ChunkPosition structPos = structure.func_151545_a((World)world, x, y, z);
                    if (structPos != null && !Strings.isNullOrEmpty((String)(structType = StructureRegistry.this.identifyStructure(structure)))) {
                        result.put((Object)structType, (Object)structPos);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        return result.build();
    }

    public Set<ChunkPosition> getNearestInstance(final String name, final WorldServer world, final int x, final int y, final int z) {
        final ImmutableSet.Builder result = ImmutableSet.builder();
        this.visitStructures(world, new IStructureVisitor(){

            @Override
            public void visit(MapGenStructure structure) {
                String structType = StructureRegistry.this.identifyStructure(structure);
                if (name.equals(structType)) {
                    try {
                        ChunkPosition structPos = structure.func_151545_a((World)world, x, y, z);
                        if (structPos != null) {
                            result.add((Object)structPos);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        });
        return result.build();
    }

    private static interface IStructureVisitor {
        public void visit(MapGenStructure var1);
    }
}

