/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.tracker;

import astrotibs.villagenames.common.ExtendedVillageGuard;
import astrotibs.villagenames.common.ExtendedVillager;
import astrotibs.villagenames.common.ExtendedVillagerZombie;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.prismarine.minecraft.Vec3i;
import astrotibs.villagenames.tracker.ServerInfoTracker;
import astrotibs.villagenames.utility.LogHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class EventTracker {
    private final Vec3i eventPos;
    private final String customName;
    private final Object extraInfo;
    private int tickWhenAdded;
    private final int entityID;

    public Vec3i getPosition() {
        return this.eventPos;
    }

    public String getCustomName() {
        return this.customName;
    }

    public Object getExtraInfo() {
        return this.extraInfo;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public void setBirthTick(int tick) {
        this.tickWhenAdded = tick;
    }

    public int getBirthTick() {
        return this.tickWhenAdded;
    }

    public void expireNow() {
        this.tickWhenAdded = -1;
    }

    private EventTracker(int entityID, Vec3i pos, String customName, Object extraInfo) {
        this.entityID = entityID;
        this.customName = customName;
        this.eventPos = pos;
        this.extraInfo = extraInfo;
        this.tickWhenAdded = 0;
    }

    public EventTracker(EntityVillager villager) {
        this(villager.func_145782_y(), new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v), villager.func_94057_bL(), new Object[]{villager.func_70946_n(), GeneralConfigHandler.villagerCareers ? ExtendedVillager.get(villager).getCareer() : 0, villager.func_70631_g_()});
    }

    public EventTracker(EntityLiving guard) {
        this(guard.func_145782_y(), new Vec3i(guard.field_70165_t, guard.field_70163_u + 0.5, guard.field_70161_v), guard.func_94057_bL(), new Object[0]);
    }

    public EventTracker(EntityZombie zombie, ExtendedVillagerZombie properties) {
        this(zombie.func_145782_y(), new Vec3i(zombie.field_70165_t, zombie.field_70163_u + 0.5, zombie.field_70161_v), zombie.func_94057_bL(), properties);
    }

    public void updateZombie(EntityJoinWorldEvent event, ExtendedVillagerZombie properties) {
        EntityZombie zombie = (EntityZombie)event.entity;
        if (GeneralConfigHandler.debugMessages) {
            LogHelper.info("EventTracker.updateZombie called with this.getCustomName(): " + this.getCustomName() + ", this.getObject(): " + this.getExtraInfo());
        }
        Object[] extraInfo = (Object[])this.getExtraInfo();
        int profession = (Integer)extraInfo[0];
        int career = (Integer)extraInfo[1];
        boolean isBaby = (Boolean)extraInfo[2];
        String customName = this.getCustomName();
        String PMTMUnloc = "Traveling Merchant";
        String PMTMUnlocModern = "Traveling Merchant";
        String PMShUnloc = "Sheepman";
        String PMShUnlocModern = "Sheepman";
        String PMSSUnloc = "Sheepman Smith";
        if (!(customName.equals("") || customName.equals(null) || customName.equals(PMTMUnloc) || customName.equals(PMTMUnlocModern) || customName.equals(PMShUnloc) || customName.equals(PMShUnlocModern) || customName.equals(PMSSUnloc))) {
            zombie.func_94058_c(this.getCustomName());
            zombie.func_110163_bv();
        }
        zombie.func_82227_f(isBaby);
        if (customName.equals(PMSSUnloc)) {
            properties.setProfession(3);
        } else if (profession >= 0) {
            properties.setProfession(profession);
        } else {
            properties.setProfession(-1);
        }
        if (career > 0) {
            properties.setCareer(career);
        } else {
            properties.setCareer(0);
        }
        for (int slot = 0; slot <= 4; ++slot) {
            zombie.func_70062_b(slot, null);
        }
    }

    public void updateGuard(LivingEvent.LivingUpdateEvent event, ExtendedVillageGuard properties) {
        EntityLiving guard = (EntityLiving)event.entity;
        NBTTagCompound compound = new NBTTagCompound();
        guard.func_70014_b(compound);
        int targetAge = compound.func_74762_e("Age");
        if (GeneralConfigHandler.debugMessages) {
            LogHelper.info("EventTracker.updateGuard called with this.getCustomName(): " + this.getCustomName() + ", this.getObject(): " + this.getExtraInfo());
        }
        Object[] extraInfo = (Object[])this.getExtraInfo();
        String customName = this.getCustomName();
        if (!customName.equals("") && !customName.equals(null)) {
            for (int i = ServerInfoTracker.EventType.GUARD.getTracker().size() - 1; i >= 0; --i) {
                if (ServerInfoTracker.EventType.GUARD.getTracker().get((int)i).customName != customName) continue;
                ServerInfoTracker.EventType.GUARD.getTracker().remove(i);
            }
            if (customName.indexOf("(") != -1) {
                customName = customName.substring(0, customName.indexOf("(")).trim();
            }
            if (GeneralConfigHandler.addJobToName && (!(guard instanceof EntityVillager) || targetAge >= 0)) {
                customName = customName + " " + NameGenerator.getCareerTag(guard.getClass().toString().substring(6), 0, 0);
                customName = customName.trim();
            }
            guard.func_94058_c(customName);
            guard.func_110163_bv();
        }
    }

    public void updateVillager(EntityVillager villager) {
        if (GeneralConfigHandler.debugMessages) {
            LogHelper.info("EventTracker.updateVillager called with this.getCustomName(): " + this.getCustomName());
        }
        ExtendedVillagerZombie properties = (ExtendedVillagerZombie)this.getExtraInfo();
        if (!this.getCustomName().equals("") && !this.getCustomName().equals(null)) {
            villager.func_94058_c(this.getCustomName());
        }
        if (properties.getProfession() >= 0) {
            villager.func_70938_b(properties.getProfession());
        }
        if (properties.getCareer() > 0 && GeneralConfigHandler.villagerCareers) {
            ExtendedVillager.get(villager).setCareer(properties.getCareer());
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Entity ID = ");
        r.append(this.getEntityID());
        r.append(", Position = ");
        if (this.getPosition() == null) {
            r.append("NULL");
        } else {
            r.append(this.getPosition().toString());
        }
        r.append(", Tick of Birth = ");
        r.append(this.getBirthTick());
        r.append(", Custom Name = ");
        r.append(this.getCustomName());
        r.append(", Extra Info = ");
        if (this.getExtraInfo() == null) {
            r.append("NULL");
        } else {
            r.append(this.getExtraInfo().getClass().getName());
            r.append(":");
            r.append(this.getExtraInfo().toString());
        }
        return r.toString();
    }
}

