/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames;

import astrotibs.villagenames.block.ModBlocksVN;
import astrotibs.villagenames.command.CommandName;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.init.InventoryRender;
import astrotibs.villagenames.init.ModConfiguration;
import astrotibs.villagenames.init.Recipes;
import astrotibs.villagenames.integration.ModChecker;
import astrotibs.villagenames.item.ModItems;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.name.NamePieces;
import astrotibs.villagenames.nbt.VNWorldDataVillage;
import astrotibs.villagenames.proxy.CommonProxy;
import astrotibs.villagenames.utility.LogHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="VillageNames", name="Village Names", version="2.0", acceptedMinecraftVersions="[1.8.9]")
public final class VillageNames {
    @SidedProxy(clientSide="astrotibs.villagenames.proxy.ClientProxy", serverSide="astrotibs.villagenames.proxy.ServerProxy")
    public static CommonProxy PROXY;
    public static final Block FLAG_ID;
    Random random = new Random();
    public static final HashSet<Integer> globalDimensionBlacklist;
    public static File configDirectory;
    @Mod.Instance(value="VillageNames")
    public static VillageNames instance;
    public static ModChecker modChecker;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        modChecker = new ModChecker();
        ModChecker.printSuccessMessage();
        configDirectory = new File(event.getModConfigurationDirectory(), "VillageNames");
        ModConfiguration.init(configDirectory);
        ModItems.init();
        ModBlocksVN.init();
        PROXY.preInit(event);
        LogHelper.info("Pre-initialization complete!");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Recipes.init();
        if (event.getSide() == Side.CLIENT) {
            InventoryRender.init();
        }
        PROXY.init(event);
        LogHelper.info("Registering replacer for village generation");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandName());
    }

    @SubscribeEvent
    public void onPopulating(PopulateChunkEvent.Post event) {
        HashSet<Integer> globalDimensionBlacklist = new HashSet<Integer>();
        String[] blackList = GeneralConfigHandler.blackList;
        boolean wellSlabs = GeneralConfigHandler.wellSlabs;
        boolean nameSign = GeneralConfigHandler.nameSign;
        boolean addConcrete = GeneralConfigHandler.addConcrete;
        boolean concreteWell = GeneralConfigHandler.concreteWell;
        for (String text : blackList) {
            String[] results22;
            if (text == null || text.isEmpty()) continue;
            boolean done = false;
            if (text.contains("[") && text.contains("]") && (results22 = text.substring(text.indexOf("[") + 1, text.indexOf("]")).split(";")).length == 2) {
                try {
                    int a = Integer.parseInt(results22[0]);
                    int b = Integer.parseInt(results22[1]);
                    boolean remove = text.startsWith("-");
                    for (int x = a; x <= b; ++x) {
                        if (remove) {
                            globalDimensionBlacklist.remove(x);
                            continue;
                        }
                        globalDimensionBlacklist.add(x);
                    }
                    done = true;
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
            }
            if (done) continue;
            try {
                globalDimensionBlacklist.add(Integer.parseInt(text.trim()));
            }
            catch (NumberFormatException results22) {
                // empty catch block
            }
        }
        if (event.hasVillageGenerated && !globalDimensionBlacklist.contains(event.world.field_73011_w.func_177502_q())) {
            int i = (event.chunkX << 4) + 8;
            int k = (event.chunkZ << 4) + 8;
            int signCornerAndFacing = this.random.nextInt(8);
            int signOrientation = signCornerAndFacing / 2 * 4;
            int signLocation = (signCornerAndFacing + 1) / 2 % 4;
            int signXOffset = (1 - Math.abs((signLocation + 1) / 2 - 1) * 2) * 2;
            int signZOffset = (signLocation / 2 * 2 - 1) * 2;
            int signHeightOffGround = 2;
            Block signBase = Blocks.field_150347_e;
            int isWellCorner = 0;
            for (int x = i; x < i + 16; ++x) {
                for (int z = k; z < k + 16; ++z) {
                    int y = event.world.func_175645_m(new BlockPos(x, 64, z)).func_177956_o();
                    if (y <= 1) continue;
                    Block id = event.world.func_180495_p(new BlockPos(x, --y, z)).func_177230_c();
                    while (id.isAir((IBlockAccess)event.world, new BlockPos(x, y, z)) || id.isLeaves((IBlockAccess)event.world, new BlockPos(x, y, z))) {
                        id = event.world.func_180495_p(new BlockPos(x, --y, z)).func_177230_c();
                    }
                    if (!id.func_149662_c()) continue;
                    id = event.world.func_180495_p(new BlockPos(x, y - 4, z)).func_177230_c();
                    Block id2 = event.world.func_180495_p(new BlockPos(x, y - 5, z)).func_177230_c();
                    Block id3 = event.world.func_180495_p(new BlockPos(x, y - 6, z)).func_177230_c();
                    if (!VillageNames.isWaterId(id) || !VillageNames.isWaterId(id2) || !VillageNames.isWaterId(id3)) continue;
                    int[] field = new int[]{x, y -= 4, z};
                    int[] field2 = new int[]{x, y - 1, z};
                    int[] field3 = new int[]{x, y - 2, z};
                    List<int[]> listWater = VillageNames.getBorder(event.world, id, field);
                    List<int[]> listWater2 = VillageNames.getBorder(event.world, id2, field2);
                    List<int[]> listWater3 = VillageNames.getBorder(event.world, id3, field3);
                    List<int[]> listOpaque = VillageNames.getOpaqueBorder(event.world, field);
                    if (listWater.size() != 3 || listWater2.size() != 3 || listWater3.size() != 3 || listOpaque.size() != 5) continue;
                    if (1 - Math.abs(++isWellCorner / 2 - 1) + (isWellCorner - 1) % 2 * 2 == signLocation) {
                        String[] newVillageName = NameGenerator.newVillageName();
                        String headerTags = newVillageName[0];
                        String namePrefix = newVillageName[1];
                        String nameRoot = newVillageName[2];
                        String nameSuffix = newVillageName[3];
                        if (event.world.func_180495_p(new BlockPos(x + signXOffset, y + 2, z + signZOffset)).func_177230_c().isAir((IBlockAccess)event.world, new BlockPos(x + signXOffset, y + 2, z + signZOffset)) || event.world.func_180495_p(new BlockPos(x + signXOffset, y + 2, z + signZOffset)).func_177230_c().isLeaves((IBlockAccess)event.world, new BlockPos(x + signXOffset, y + 2, z + signZOffset))) {
                            int[] codeColor_a = NamePieces.codeColors_default;
                            int townColorMeta = codeColor_a[this.random.nextInt(codeColor_a.length)];
                            if (townColorMeta == -1) {
                                int[] codeColors_remaining_a = NamePieces.codeColors_remaining;
                                townColorMeta = codeColors_remaining_a[this.random.nextInt(codeColors_remaining_a.length)];
                            }
                            String[] towntype = new String[]{"Welcome to", "Hamlet of", "Village of", "Town of"};
                            String topLine = towntype[this.random.nextInt(towntype.length)];
                            topLine = topLine.replaceAll("\\^", " ");
                            int signX = x + signXOffset;
                            int signY = y + 2;
                            int signZ = z + signZOffset;
                            VNWorldDataVillage data = VNWorldDataVillage.forWorld(event.world);
                            NBTTagCompound tagCompound = data.getData();
                            Set tagmapKeyset = tagCompound.func_150296_c();
                            Iterator itr = tagmapKeyset.iterator();
                            boolean signLocated = false;
                            while (itr.hasNext()) {
                                int radiussearch;
                                int townZ;
                                int townY;
                                Object element = itr.next();
                                String townSignEntry = element.toString();
                                NBTTagCompound tagList = tagCompound.func_150295_c(townSignEntry, (int)tagCompound.func_74732_a()).func_150305_b(0);
                                int townX = tagList.func_74762_e("signX");
                                if ((signX - townX) * (signX - townX) + (signY - (townY = tagList.func_74762_e("signY"))) * (signY - townY) + (signZ - (townZ = tagList.func_74762_e("signZ"))) * (signZ - townZ) > (radiussearch = 32) * radiussearch) continue;
                                townColorMeta = tagList.func_74762_e("townColor");
                                namePrefix = tagList.func_74779_i("namePrefix");
                                nameRoot = tagList.func_74779_i("nameRoot");
                                nameSuffix = tagList.func_74779_i("nameSuffix");
                                break;
                            }
                            if (nameSign) {
                                int pedY;
                                event.world.func_175656_a(new BlockPos(x + signXOffset, y + 1, z + signZOffset), Blocks.field_150463_bK.func_176223_P());
                                event.world.func_175656_a(new BlockPos(x + signXOffset, y + 2, z + signZOffset), Blocks.field_150472_an.func_176203_a(signOrientation));
                                Block concreteBlock = ModBlocksVN.blockConcrete;
                                Block roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaWhite;
                                switch (townColorMeta) {
                                    case 1: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaOrange;
                                        break;
                                    }
                                    case 2: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaMagenta;
                                        break;
                                    }
                                    case 3: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaLightBlue;
                                        break;
                                    }
                                    case 4: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaYellow;
                                        break;
                                    }
                                    case 5: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaLime;
                                        break;
                                    }
                                    case 6: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaPink;
                                        break;
                                    }
                                    case 7: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaGray;
                                        break;
                                    }
                                    case 8: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaSilver;
                                        break;
                                    }
                                    case 9: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaCyan;
                                        break;
                                    }
                                    case 10: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaPurple;
                                        break;
                                    }
                                    case 11: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaBlue;
                                        break;
                                    }
                                    case 12: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaBrown;
                                        break;
                                    }
                                    case 13: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaGreen;
                                        break;
                                    }
                                    case 14: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaRed;
                                        break;
                                    }
                                    case 15: {
                                        roofGlazedBlock = ModBlocksVN.blockGlazedTerracottaBlack;
                                    }
                                }
                                if (addConcrete && concreteWell) {
                                    for (pedY = y - 3; pedY <= y; ++pedY) {
                                        for (int rimi = 2; rimi > -3; --rimi) {
                                            event.world.func_175656_a(new BlockPos(x + signXOffset / 2 * rimi, pedY, z + signZOffset), concreteBlock.func_176203_a(townColorMeta));
                                            event.world.func_175656_a(new BlockPos(x + signXOffset, pedY, z + -signZOffset / 2 * (1 + rimi)), concreteBlock.func_176203_a(townColorMeta));
                                            event.world.func_175656_a(new BlockPos(x - signXOffset * 3 / 2, pedY, z + signZOffset / 2 * rimi), concreteBlock.func_176203_a(townColorMeta));
                                            event.world.func_175656_a(new BlockPos(x + -signXOffset / 2 * (1 + rimi), pedY, z - signZOffset * 3 / 2), concreteBlock.func_176203_a(townColorMeta));
                                        }
                                    }
                                    int metaSpin = this.random.nextInt(4) + 4;
                                    int metaChirality = this.random.nextBoolean() ? 1 : -1;
                                    event.world.func_175656_a(new BlockPos(x, y + 4, z), roofGlazedBlock.func_176203_a(metaSpin));
                                    event.world.func_175656_a(new BlockPos(x, y + 4, z - signZOffset / 2), roofGlazedBlock.func_176203_a((metaSpin + metaChirality) % 4));
                                    event.world.func_175656_a(new BlockPos(x - signXOffset / 2, y + 4, z - signZOffset / 2), roofGlazedBlock.func_176203_a((metaSpin + metaChirality * 2) % 4));
                                    event.world.func_175656_a(new BlockPos(x - signXOffset / 2, y + 4, z), roofGlazedBlock.func_176203_a((metaSpin + metaChirality * 3) % 4));
                                } else {
                                    for (pedY = y - 3; pedY <= y; ++pedY) {
                                        event.world.func_175656_a(new BlockPos(x + signXOffset, pedY, z + signZOffset), Blocks.field_150406_ce.func_176203_a(townColorMeta));
                                    }
                                }
                            }
                            TileEntitySign signContents = new TileEntitySign();
                            if (namePrefix.length() + 1 + nameRoot.length() > 15) {
                                signContents.field_145915_a[0] = new ChatComponentText(headerTags + topLine.trim());
                                signContents.field_145915_a[1] = new ChatComponentText(namePrefix.trim());
                                if (nameRoot.length() + 1 + nameSuffix.length() > 15) {
                                    signContents.field_145915_a[2] = new ChatComponentText(nameRoot.trim());
                                    signContents.field_145915_a[3] = new ChatComponentText(nameSuffix.trim());
                                } else {
                                    signContents.field_145915_a[2] = new ChatComponentText((nameRoot + " " + nameSuffix).trim());
                                }
                            } else if (namePrefix.length() + 1 + nameRoot.length() + 1 + nameSuffix.length() <= 15) {
                                signContents.field_145915_a[1] = new ChatComponentText(headerTags + topLine);
                                signContents.field_145915_a[2] = new ChatComponentText((namePrefix + " " + nameRoot + " " + nameSuffix).trim());
                            } else {
                                signContents.field_145915_a[1] = new ChatComponentText(headerTags + topLine.trim());
                                signContents.field_145915_a[2] = new ChatComponentText((namePrefix + " " + nameRoot).trim());
                                signContents.field_145915_a[3] = new ChatComponentText(nameSuffix.trim());
                            }
                            event.world.func_175690_a(new BlockPos(x + signXOffset, y + 2, z + signZOffset), (TileEntity)signContents);
                            NBTTagList nbttaglist = new NBTTagList();
                            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                            nbttagcompound1.func_74768_a("signX", signX);
                            nbttagcompound1.func_74768_a("signY", signY);
                            nbttagcompound1.func_74768_a("signZ", signZ);
                            nbttagcompound1.func_74768_a("townColor", townColorMeta);
                            nbttagcompound1.func_74778_a("namePrefix", namePrefix);
                            nbttagcompound1.func_74778_a("nameRoot", nameRoot);
                            nbttagcompound1.func_74778_a("nameSuffix", nameSuffix);
                            nbttagcompound1.func_74778_a("sign0", signContents.field_145915_a[0].func_150254_d());
                            nbttagcompound1.func_74778_a("sign1", signContents.field_145915_a[1].func_150254_d());
                            nbttagcompound1.func_74778_a("sign2", signContents.field_145915_a[2].func_150254_d());
                            nbttagcompound1.func_74778_a("sign3", signContents.field_145915_a[3].func_150254_d());
                            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                            data.getData().func_74782_a("x" + signX + "y" + signY + "z" + signZ, (NBTBase)nbttaglist);
                            data.func_76185_a();
                        } else {
                            NBTTagList nbttaglist = new NBTTagList();
                            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                            int signX = x + signXOffset;
                            int signY = y + 2;
                            int signZ = z + signZOffset;
                            VNWorldDataVillage data = VNWorldDataVillage.forWorld(event.world);
                            LogHelper.info("Tried to generate a sign inside a well's post at x=" + signX + " y=" + signY + " z=" + signZ);
                        }
                    }
                    if (wellSlabs) {
                        field = listOpaque.remove(1);
                        event.world.func_175656_a(new BlockPos(field[0], field[1] + 1, field[2]), Blocks.field_150333_U.func_176223_P());
                        field = listOpaque.remove(2);
                        event.world.func_175656_a(new BlockPos(field[0], field[1] + 1, field[2]), Blocks.field_150333_U.func_176223_P());
                    }
                    while (event.world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == id) {
                        --y;
                    }
                    field = new int[]{x, y, z};
                    listOpaque = VillageNames.getOpaqueBorder(event.world, field);
                }
            }
        }
    }

    private static boolean hasAround(World world, Block id, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x - 1, y, z)).func_177230_c() == id && world.func_180495_p(new BlockPos(x + 1, y, z)).func_177230_c() == id && world.func_180495_p(new BlockPos(x, y, z - 1)).func_177230_c() == id && world.func_180495_p(new BlockPos(x, y, z + 1)).func_177230_c() == id;
    }

    private static List<int[]> getBorder(World world, Block id, int[] field) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int x = field[0] - 1; x < field[0] + 2; ++x) {
            for (int z = field[2] - 1; z < field[2] + 2; ++z) {
                if (x == field[0] && z == field[2] || world.func_180495_p(new BlockPos(x, field[1], z)).func_177230_c() != id) continue;
                list.add(new int[]{x, field[1], z});
            }
        }
        return list;
    }

    private static List<int[]> getOpaqueBorder(World world, int[] field) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int x = field[0] - 1; x < field[0] + 2; ++x) {
            for (int z = field[2] - 1; z < field[2] + 2; ++z) {
                if (x == field[0] && z == field[2] || !world.func_180495_p(new BlockPos(x, field[1], z)).func_177230_c().func_149662_c()) continue;
                list.add(new int[]{x, field[1], z});
            }
        }
        return list;
    }

    private static boolean isCorner(World world, Block id, int[] pos) {
        int[] b;
        List<int[]> list = VillageNames.getBorder(world, id, pos);
        if (list.size() < 2) {
            return false;
        }
        int[] a = list.get(0);
        return a[0] != (b = list.get(1))[0] && a[2] != b[2];
    }

    private static boolean isWaterId(Block id) {
        return id.func_149688_o() == Material.field_151586_h;
    }

    public File getConfigDirectory() {
        return configDirectory;
    }

    public static String mapColorMetaToStringFormat(int colorMeta) {
        HashMap<Integer, String> signColorToFormat = new HashMap<Integer, String>();
        signColorToFormat.put(0, "\u00a7f");
        signColorToFormat.put(1, "\u00a76");
        signColorToFormat.put(2, "\u00a7d");
        signColorToFormat.put(3, "\u00a79");
        signColorToFormat.put(4, "\u00a7e");
        signColorToFormat.put(5, "\u00a7a");
        signColorToFormat.put(6, "\u00a7c");
        signColorToFormat.put(7, "\u00a78");
        signColorToFormat.put(8, "\u00a77");
        signColorToFormat.put(9, "\u00a73");
        signColorToFormat.put(10, "\u00a75");
        signColorToFormat.put(11, "\u00a71");
        signColorToFormat.put(12, "\u00a70");
        signColorToFormat.put(13, "\u00a72");
        signColorToFormat.put(14, "\u00a74");
        signColorToFormat.put(15, "\u00a70");
        return (String)signColorToFormat.get(colorMeta);
    }

    static {
        FLAG_ID = Blocks.field_150344_f;
        globalDimensionBlacklist = new HashSet();
    }
}

