/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import astrotibs.villagenames.name.NamePieces;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FortressConfigHandler {
    public static Configuration config;
    public static String[] fortress_prefix;
    public static String[] fortress_suffix;
    public static String[] fortress_oneSylBegin;
    public static String[] fortress_oneSylEnd;
    public static String[] fortress_syl1Trans;
    public static String[] fortress_syl2Term;
    public static String[] fortress_syl2Trans;
    public static String[] fortress_syl3Term;
    public static String[] fortress_syl3Trans;
    public static String[] fortress_syl4Term;
    public static String[] fortress_syl4Trans;
    public static String[] fortress_syl5Term;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            FortressConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        fortress_prefix = config.getStringList("fortress_prefix", "Prefix/Suffix", fortress_prefix, "Prefixes that can occur before name\nCheck out https://en.wikipedia.org/wiki/List_of_Unicode_characters\nfor unicode keys.\n");
        fortress_suffix = config.getStringList("fortress_suffix", "Prefix/Suffix", fortress_suffix, "Suffixes that can occur after name");
        fortress_oneSylBegin = config.getStringList("fortress_oneSylBegin", "Fortress Syllable 1", fortress_oneSylBegin, "First half of one-syllable town name");
        fortress_oneSylEnd = config.getStringList("fortress_oneSylEnd", "Fortress Syllable 1", fortress_oneSylEnd, "Second half of one-syllable town name");
        fortress_syl1Trans = config.getStringList("fortress_syl1Trans", "Fortress Syllable 1", fortress_syl1Trans, "Transitional first syllable");
        fortress_syl2Trans = config.getStringList("fortress_syl2Trans", "Fortress Syllable 2", fortress_syl2Trans, "Transitional second syllable (use ^ for leading/ending spaces)");
        fortress_syl2Term = config.getStringList("fortress_syl2Term", "Fortress Syllable 2", fortress_syl2Term, "Terminating second syllable (use ^ for leading/ending spaces)");
        fortress_syl3Trans = config.getStringList("fortress_syl3Trans", "Fortress Syllable 3", fortress_syl3Trans, "Transitional third syllable (use ^ for leading/ending spaces)");
        fortress_syl3Term = config.getStringList("fortress_syl3Term", "Fortress Syllable 3", fortress_syl3Term, "Terminating third syllable (use ^ for leading/ending spaces)");
        fortress_syl4Trans = config.getStringList("fortress_syl4Trans", "Fortress Syllable 4", fortress_syl4Trans, "Transitional fourth syllable (use ^ for leading/ending spaces)");
        fortress_syl4Term = config.getStringList("fortress_syl4Term", "Fortress Syllable 4", fortress_syl4Term, "Terminating fourth syllable (use ^ for leading/ending spaces)");
        fortress_syl5Term = config.getStringList("fortress_syl5Term", "Fortress Syllable 5", fortress_syl5Term, "Terminating fifth syllable (use ^ for leading/ending spaces)");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("VillageNames")) {
            FortressConfigHandler.loadConfiguration();
        }
    }

    static {
        fortress_prefix = NamePieces.fortress_prefix_default;
        fortress_suffix = NamePieces.fortress_suffix_default;
        fortress_oneSylBegin = NamePieces.fortress_oneSylBegin_default;
        fortress_oneSylEnd = NamePieces.fortress_oneSylEnd_default;
        fortress_syl1Trans = NamePieces.fortress_syl1Trans_default;
        fortress_syl2Term = NamePieces.fortress_syl2Term_default;
        fortress_syl2Trans = NamePieces.fortress_syl2Trans_default;
        fortress_syl3Term = NamePieces.fortress_syl3Term_default;
        fortress_syl3Trans = NamePieces.fortress_syl3Trans_default;
        fortress_syl4Term = NamePieces.fortress_syl4Term_default;
        fortress_syl4Trans = NamePieces.fortress_syl4Trans_default;
        fortress_syl5Term = NamePieces.fortress_syl5Term_default;
    }
}

