/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GeneralConfigHandler {
    public static Configuration config;
    public static String[] blackList;
    public static boolean wellSlabs;
    public static boolean nameSign;
    public static boolean nameVillagers;
    public static String headerTags;
    public static boolean villagerDropBook;
    public static boolean addJobToName;
    public static boolean addConcrete;
    public static boolean concreteWell;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            GeneralConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        blackList = config.getString("Dimension blacklist", "general", "-1,1", "Prevent well decorations on a per-world basis, by dimension ids. Use [id1;id2] to add a range of id, prefix with - to exclude.").split(",");
        nameSign = config.getBoolean("Name sign", "general", true, "Villages display their name on a sign near the well. You can still discover the name by right-clicking a book onto a villager.");
        nameVillagers = config.getBoolean("Name villagers", "general", true, "Villagers reveal their names when you right-click them. If this is false, you can name villagers with name tags.");
        wellSlabs = config.getBoolean("Well slabs", "general", true, "Replace the cobblestone rims of wells with stone slabs, making it easier for players and villagers to escape if they fall in.");
        villagerDropBook = config.getBoolean("Villager drops book", "general", false, "Village books are dropped by the villager rather than going directly into your inventory.");
        addJobToName = config.getBoolean("addJobToName", "Profession/Career", false, "A villager's name also includes its profession. Turn this on/off and talk to a villager to add/remove the career tag to their name.");
        addConcrete = config.getBoolean("addConcrete", "Concrete", true, "Whether to add 1.12 style Concrete, Concrete Powder, and Glazed Terracotta");
        concreteWell = config.getBoolean("concreteWell", "Concrete", true, "Whether to decorate wells with Concrete and Glazed Terracotta instead of stained clay (addConcrete must be true)");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("VillageNames")) {
            GeneralConfigHandler.loadConfiguration();
        }
    }

    static {
        headerTags = "\u00a78\u00a7o";
    }
}

