/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import astrotibs.villagenames.name.NamePieces;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MansionConfigHandler {
    public static Configuration config;
    public static String[] mansion_prefix;
    public static String[] mansion_suffix;
    public static String[] mansion_oneSylBegin;
    public static String[] mansion_oneSylEnd;
    public static String[] mansion_syl1Trans;
    public static String[] mansion_syl2Term;
    public static String[] mansion_syl2Trans;
    public static String[] mansion_syl3Term;
    public static String[] mansion_syl3Trans;
    public static String[] mansion_syl4Term;
    public static String[] mansion_syl4Trans;
    public static String[] mansion_syl5Term;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            MansionConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        mansion_prefix = config.getStringList("mansion_prefix", "Prefix/Suffix", mansion_prefix, "Prefixes that can occur before name\nCheck out https://en.wikipedia.org/wiki/List_of_Unicode_characters\nfor unicode keys.\n");
        mansion_suffix = config.getStringList("mansion_suffix", "Prefix/Suffix", mansion_suffix, "Suffixes that can occur after name");
        mansion_oneSylBegin = config.getStringList("mansion_oneSylBegin", "Mansion Syllable 1", mansion_oneSylBegin, "First half of one-syllable town name");
        mansion_oneSylEnd = config.getStringList("mansion_oneSylEnd", "Mansion Syllable 1", mansion_oneSylEnd, "Second half of one-syllable town name");
        mansion_syl1Trans = config.getStringList("mansion_syl1Trans", "Mansion Syllable 1", mansion_syl1Trans, "Transitional first syllable");
        mansion_syl2Trans = config.getStringList("mansion_syl2Trans", "Mansion Syllable 2", mansion_syl2Trans, "Transitional second syllable (use ^ for leading/ending spaces)");
        mansion_syl2Term = config.getStringList("mansion_syl2Term", "Mansion Syllable 2", mansion_syl2Term, "Terminating second syllable (use ^ for leading/ending spaces)");
        mansion_syl3Trans = config.getStringList("mansion_syl3Trans", "Mansion Syllable 3", mansion_syl3Trans, "Transitional third syllable (use ^ for leading/ending spaces)");
        mansion_syl3Term = config.getStringList("mansion_syl3Term", "Mansion Syllable 3", mansion_syl3Term, "Terminating third syllable (use ^ for leading/ending spaces)");
        mansion_syl4Trans = config.getStringList("mansion_syl4Trans", "Mansion Syllable 4", mansion_syl4Trans, "Transitional fourth syllable (use ^ for leading/ending spaces)");
        mansion_syl4Term = config.getStringList("mansion_syl4Term", "Mansion Syllable 4", mansion_syl4Term, "Terminating fourth syllable (use ^ for leading/ending spaces)");
        mansion_syl5Term = config.getStringList("mansion_syl5Term", "Mansion Syllable 5", mansion_syl5Term, "Terminating fifth syllable (use ^ for leading/ending spaces)");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("VillageNames")) {
            MansionConfigHandler.loadConfiguration();
        }
    }

    static {
        mansion_prefix = NamePieces.mansion_prefix_default;
        mansion_suffix = NamePieces.mansion_suffix_default;
        mansion_oneSylBegin = NamePieces.mansion_oneSylBegin_default;
        mansion_oneSylEnd = NamePieces.mansion_oneSylEnd_default;
        mansion_syl1Trans = NamePieces.mansion_syl1Trans_default;
        mansion_syl2Term = NamePieces.mansion_syl2Term_default;
        mansion_syl2Trans = NamePieces.mansion_syl2Trans_default;
        mansion_syl3Term = NamePieces.mansion_syl3Term_default;
        mansion_syl3Trans = NamePieces.mansion_syl3Trans_default;
        mansion_syl4Term = NamePieces.mansion_syl4Term_default;
        mansion_syl4Trans = NamePieces.mansion_syl4Trans_default;
        mansion_syl5Term = NamePieces.mansion_syl5Term_default;
    }
}

