/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import astrotibs.villagenames.name.NamePieces;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MineshaftConfigHandler {
    public static Configuration config;
    public static String[] mineshaft_prefix;
    public static String[] mineshaft_suffix;
    public static String[] mineshaft_oneSylBegin;
    public static String[] mineshaft_oneSylEnd;
    public static String[] mineshaft_syl1Trans;
    public static String[] mineshaft_syl2Term;
    public static String[] mineshaft_syl2Trans;
    public static String[] mineshaft_syl3Term;
    public static String[] mineshaft_syl3Trans;
    public static String[] mineshaft_syl4Term;
    public static String[] mineshaft_syl4Trans;
    public static String[] mineshaft_syl5Term;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            MineshaftConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        mineshaft_prefix = config.getStringList("mineshaft_prefix", "Prefix/Suffix", mineshaft_prefix, "Prefixes that can occur before name\nCheck out https://en.wikipedia.org/wiki/List_of_Unicode_characters\nfor unicode keys.\n");
        mineshaft_suffix = config.getStringList("mineshaft_suffix", "Prefix/Suffix", mineshaft_suffix, "Suffixes that can occur after name");
        mineshaft_oneSylBegin = config.getStringList("mineshaft_oneSylBegin", "Mineshaft Syllable 1", mineshaft_oneSylBegin, "First half of one-syllable town name");
        mineshaft_oneSylEnd = config.getStringList("mineshaft_oneSylEnd", "Mineshaft Syllable 1", mineshaft_oneSylEnd, "Second half of one-syllable town name");
        mineshaft_syl1Trans = config.getStringList("mineshaft_syl1Trans", "Mineshaft Syllable 1", mineshaft_syl1Trans, "Transitional first syllable");
        mineshaft_syl2Trans = config.getStringList("mineshaft_syl2Trans", "Mineshaft Syllable 2", mineshaft_syl2Trans, "Transitional second syllable (use ^ for leading/ending spaces)");
        mineshaft_syl2Term = config.getStringList("mineshaft_syl2Term", "Mineshaft Syllable 2", mineshaft_syl2Term, "Terminating second syllable (use ^ for leading/ending spaces)");
        mineshaft_syl3Trans = config.getStringList("mineshaft_syl3Trans", "Mineshaft Syllable 3", mineshaft_syl3Trans, "Transitional third syllable (use ^ for leading/ending spaces)");
        mineshaft_syl3Term = config.getStringList("mineshaft_syl3Term", "Mineshaft Syllable 3", mineshaft_syl3Term, "Terminating third syllable (use ^ for leading/ending spaces)");
        mineshaft_syl4Trans = config.getStringList("mineshaft_syl4Trans", "Mineshaft Syllable 4", mineshaft_syl4Trans, "Transitional fourth syllable (use ^ for leading/ending spaces)");
        mineshaft_syl4Term = config.getStringList("mineshaft_syl4Term", "Mineshaft Syllable 4", mineshaft_syl4Term, "Terminating fourth syllable (use ^ for leading/ending spaces)");
        mineshaft_syl5Term = config.getStringList("mineshaft_syl5Term", "Mineshaft Syllable 5", mineshaft_syl5Term, "Terminating fifth syllable (use ^ for leading/ending spaces)");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("VillageNames")) {
            MineshaftConfigHandler.loadConfiguration();
        }
    }

    static {
        mineshaft_prefix = NamePieces.mineshaft_prefix_default;
        mineshaft_suffix = NamePieces.mineshaft_suffix_default;
        mineshaft_oneSylBegin = NamePieces.mineshaft_oneSylBegin_default;
        mineshaft_oneSylEnd = NamePieces.mineshaft_oneSylEnd_default;
        mineshaft_syl1Trans = NamePieces.mineshaft_syl1Trans_default;
        mineshaft_syl2Term = NamePieces.mineshaft_syl2Term_default;
        mineshaft_syl2Trans = NamePieces.mineshaft_syl2Trans_default;
        mineshaft_syl3Term = NamePieces.mineshaft_syl3Term_default;
        mineshaft_syl3Trans = NamePieces.mineshaft_syl3Trans_default;
        mineshaft_syl4Term = NamePieces.mineshaft_syl4Term_default;
        mineshaft_syl4Trans = NamePieces.mineshaft_syl4Trans_default;
        mineshaft_syl5Term = NamePieces.mineshaft_syl5Term_default;
    }
}

