/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import astrotibs.villagenames.name.NamePieces;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MonumentConfigHandler {
    public static Configuration config;
    public static String[] monument_prefix;
    public static String[] monument_suffix;
    public static String[] monument_oneSylBegin;
    public static String[] monument_oneSylEnd;
    public static String[] monument_syl1Trans;
    public static String[] monument_syl2Term;
    public static String[] monument_syl2Trans;
    public static String[] monument_syl3Term;
    public static String[] monument_syl3Trans;
    public static String[] monument_syl4Term;
    public static String[] monument_syl4Trans;
    public static String[] monument_syl5Term;
    public static String[] monument_syl5Trans;
    public static String[] monument_syl6Term;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            MonumentConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        monument_prefix = config.getStringList("prefix", "Prefix/Suffix", monument_prefix, "Prefixes that can occur before name\nCheck out https://en.wikipedia.org/wiki/List_of_Unicode_characters\nfor unicode keys.\n");
        monument_suffix = config.getStringList("suffix", "Prefix/Suffix", monument_suffix, "Suffixes that can occur after name");
        monument_oneSylBegin = config.getStringList("oneSylBegin", "Monument Syllable 1", monument_oneSylBegin, "First half of one-syllable town name");
        monument_oneSylEnd = config.getStringList("oneSylEnd", "Monument Syllable 1", monument_oneSylEnd, "Second half of one-syllable town name");
        monument_syl1Trans = config.getStringList("syl1Trans", "Monument Syllable 1", monument_syl1Trans, "Transitional first syllable");
        monument_syl2Trans = config.getStringList("syl2Trans", "Monument Syllable 2", monument_syl2Trans, "Transitional second syllable (use ^ for leading/ending spaces)");
        monument_syl2Term = config.getStringList("syl2Term", "Monument Syllable 2", monument_syl2Term, "Terminating second syllable (use ^ for leading/ending spaces)");
        monument_syl3Trans = config.getStringList("syl3Trans", "Monument Syllable 3", monument_syl3Trans, "Transitional third syllable (use ^ for leading/ending spaces)");
        monument_syl3Term = config.getStringList("syl3Term", "Monument Syllable 3", monument_syl3Term, "Terminating third syllable (use ^ for leading/ending spaces)");
        monument_syl4Trans = config.getStringList("syl4Trans", "Monument Syllable 4", monument_syl4Trans, "Transitional fourth syllable (use ^ for leading/ending spaces)");
        monument_syl4Term = config.getStringList("syl4Term", "Monument Syllable 4", monument_syl4Term, "Terminating fourth syllable (use ^ for leading/ending spaces)");
        monument_syl5Trans = config.getStringList("syl5Trans", "Monument Syllable 5", monument_syl5Trans, "Transitional fifth syllable (use ^ for leading/ending spaces)");
        monument_syl5Term = config.getStringList("syl5Term", "Monument Syllable 5", monument_syl5Term, "Terminating fifth syllable (use ^ for leading/ending spaces)");
        monument_syl6Term = config.getStringList("syl6Term", "Monument Syllable 6", monument_syl6Term, "Terminating sixth syllable (use ^ for leading/ending spaces)");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("VillageNames")) {
            MonumentConfigHandler.loadConfiguration();
        }
    }

    static {
        monument_prefix = NamePieces.monument_prefix_default;
        monument_suffix = NamePieces.monument_suffix_default;
        monument_oneSylBegin = NamePieces.monument_oneSylBegin_default;
        monument_oneSylEnd = NamePieces.monument_oneSylEnd_default;
        monument_syl1Trans = NamePieces.monument_syl1Trans_default;
        monument_syl2Term = NamePieces.monument_syl2Term_default;
        monument_syl2Trans = NamePieces.monument_syl2Trans_default;
        monument_syl3Term = NamePieces.monument_syl3Term_default;
        monument_syl3Trans = NamePieces.monument_syl3Trans_default;
        monument_syl4Term = NamePieces.monument_syl4Term_default;
        monument_syl4Trans = NamePieces.monument_syl4Trans_default;
        monument_syl5Term = NamePieces.monument_syl5Term_default;
        monument_syl5Trans = NamePieces.monument_syl5Trans_default;
        monument_syl6Term = NamePieces.monument_syl6Term_default;
    }
}

