/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config;

import astrotibs.villagenames.name.NamePieces;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TempleConfigHandler {
    public static Configuration config;
    public static String[] temple_prefix;
    public static String[] temple_suffix;
    public static String[] temple_oneSylBegin;
    public static String[] temple_oneSylEnd;
    public static String[] temple_syl1Trans;
    public static String[] temple_syl2Term;
    public static String[] temple_syl2Trans;
    public static String[] temple_syl3Term;
    public static String[] temple_syl3Trans;
    public static String[] temple_syl4Term;
    public static String[] temple_syl4Trans;
    public static String[] temple_syl5Term;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            TempleConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        temple_prefix = config.getStringList("temple_prefix", "Prefix/Suffix", temple_prefix, "Prefixes that can occur before name\nCheck out https://en.wikipedia.org/wiki/List_of_Unicode_characters\nfor unicode keys.\n");
        temple_suffix = config.getStringList("temple_suffix", "Prefix/Suffix", temple_suffix, "Suffixes that can occur after name");
        temple_oneSylBegin = config.getStringList("temple_oneSylBegin", "Temple Syllable 1", temple_oneSylBegin, "First half of one-syllable town name");
        temple_oneSylEnd = config.getStringList("temple_oneSylEnd", "Temple Syllable 1", temple_oneSylEnd, "Second half of one-syllable town name");
        temple_syl1Trans = config.getStringList("temple_syl1Trans", "Temple Syllable 1", temple_syl1Trans, "Transitional first syllable");
        temple_syl2Trans = config.getStringList("temple_syl2Trans", "Temple Syllable 2", temple_syl2Trans, "Transitional second syllable (use ^ for leading/ending spaces)");
        temple_syl2Term = config.getStringList("temple_syl2Term", "Temple Syllable 2", temple_syl2Term, "Terminating second syllable (use ^ for leading/ending spaces)");
        temple_syl3Trans = config.getStringList("temple_syl3Trans", "Temple Syllable 3", temple_syl3Trans, "Transitional third syllable (use ^ for leading/ending spaces)");
        temple_syl3Term = config.getStringList("temple_syl3Term", "Temple Syllable 3", temple_syl3Term, "Terminating third syllable (use ^ for leading/ending spaces)");
        temple_syl4Trans = config.getStringList("temple_syl4Trans", "Temple Syllable 4", temple_syl4Trans, "Transitional fourth syllable (use ^ for leading/ending spaces)");
        temple_syl4Term = config.getStringList("temple_syl4Term", "Temple Syllable 4", temple_syl4Term, "Terminating fourth syllable (use ^ for leading/ending spaces)");
        temple_syl5Term = config.getStringList("temple_syl5Term", "Temple Syllable 5", temple_syl5Term, "Terminating fifth syllable (use ^ for leading/ending spaces)");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("VillageNames")) {
            TempleConfigHandler.loadConfiguration();
        }
    }

    static {
        temple_prefix = NamePieces.temple_prefix_default;
        temple_suffix = NamePieces.temple_suffix_default;
        temple_oneSylBegin = NamePieces.temple_oneSylBegin_default;
        temple_oneSylEnd = NamePieces.temple_oneSylEnd_default;
        temple_syl1Trans = NamePieces.temple_syl1Trans_default;
        temple_syl2Term = NamePieces.temple_syl2Term_default;
        temple_syl2Trans = NamePieces.temple_syl2Trans_default;
        temple_syl3Term = NamePieces.temple_syl3Term_default;
        temple_syl3Trans = NamePieces.temple_syl3Trans_default;
        temple_syl4Term = NamePieces.temple_syl4Term_default;
        temple_syl4Trans = NamePieces.temple_syl4Trans_default;
        temple_syl5Term = NamePieces.temple_syl5Term_default;
    }
}

