/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames;

import astrotibs.villagenames.block.ModBlocksVN;
import astrotibs.villagenames.command.CommandName;
import astrotibs.villagenames.config.ConfigInit;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.handler.DevVersionWarning;
import astrotibs.villagenames.handler.EntityMonitorHandler;
import astrotibs.villagenames.handler.ReputationHandler;
import astrotibs.villagenames.handler.ServerCleanExpired;
import astrotibs.villagenames.handler.ServerTrackerStarter;
import astrotibs.villagenames.handler.VersionChecker;
import astrotibs.villagenames.handler.VillagerTradeHandler;
import astrotibs.villagenames.init.InventoryRender;
import astrotibs.villagenames.init.Recipes;
import astrotibs.villagenames.integration.ModChecker;
import astrotibs.villagenames.item.ModItems;
import astrotibs.villagenames.nbt.NBTUpdater;
import astrotibs.villagenames.network.MessageVillageGuard;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import astrotibs.villagenames.network.NetworkHelper;
import astrotibs.villagenames.proxy.CommonProxy;
import astrotibs.villagenames.sounds.EventSounds;
import astrotibs.villagenames.utility.LogHelper;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="VillageNames", name="Village Names", version="3.0", guiFactory="astrotibs.villagenames.gui.VNGuiFactory", acceptedMinecraftVersions="[1.9.4]")
public final class VillageNames {
    @SidedProxy(clientSide="astrotibs.villagenames.proxy.ClientProxy", serverSide="astrotibs.villagenames.proxy.ServerProxy")
    public static CommonProxy PROXY;
    public static SimpleNetworkWrapper VNNetworkWrapper;
    public static final Block FLAG_ID;
    public static File configDirectory;
    @Mod.Instance(value="VillageNames")
    public static VillageNames instance;
    public static String currentConfigFolder;
    public static String oldConfigFolder;
    public static String obsoleteConfigFolder;
    public static Achievement maxrep;
    public static Achievement minrep;
    public static Achievement ghosttown;
    public static Achievement archaeologist;
    public static Achievement laputa;
    public static VersionChecker versionChecker;
    public static boolean haveWarnedVersionOutOfDate;
    public static boolean devVersionWarned;
    public static int numberStructuresArchaeologist;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModChecker.printDetectedMods();
        configDirectory = new File(event.getModConfigurationDirectory(), currentConfigFolder);
        ConfigInit.init(configDirectory);
        File oldConfigDirectory = new File(event.getModConfigurationDirectory(), oldConfigFolder);
        if (new File(event.getModConfigurationDirectory(), oldConfigFolder).exists()) {
            LogHelper.warn("ATTENTION! The old configuration folder " + oldConfigFolder + " exists. It will NOT BE USED in this version of Village Names! A new " + currentConfigFolder + " folder has been created.");
            if (new File(event.getModConfigurationDirectory(), obsoleteConfigFolder).exists()) {
                LogHelper.error("For some reason, you have both a " + oldConfigFolder + " and " + obsoleteConfigFolder + " folder. Note that NEITHER FOLDER IS USED!");
            } else {
                try {
                    oldConfigDirectory.renameTo(new File(event.getModConfigurationDirectory(), obsoleteConfigFolder));
                    LogHelper.warn("The previous config folder has been renamed to " + obsoleteConfigFolder + ". It will NOT BE USED anymore.");
                }
                catch (Exception e) {
                    LogHelper.error("Failed to rename " + oldConfigFolder + " folder to " + obsoleteConfigFolder);
                }
            }
        } else if (new File(event.getModConfigurationDirectory(), obsoleteConfigFolder).exists()) {
            LogHelper.info("Old config files are located in config/" + obsoleteConfigFolder + ". They will NOT BE USED anymore.");
        }
        ModItems.init();
        ModBlocksVN.init();
        MinecraftForge.EVENT_BUS.register((Object)new EventSounds());
        MinecraftForge.EVENT_BUS.register((Object)new NBTUpdater());
        MinecraftForge.EVENT_BUS.register((Object)new ServerTrackerStarter());
        MinecraftForge.EVENT_BUS.register((Object)new EntityMonitorHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ServerCleanExpired());
        MinecraftForge.EVENT_BUS.register((Object)new ReputationHandler());
        if (GeneralConfigHandler.versionChecker) {
            MinecraftForge.EVENT_BUS.register((Object)versionChecker);
        }
        if ("3.0".contains("DEV")) {
            MinecraftForge.EVENT_BUS.register((Object)new DevVersionWarning());
        }
        EventSounds.registerSounds();
        PROXY.preInit(event);
        int clientMessageID = 2;
        VNNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("vnChannel");
        VNNetworkWrapper.registerMessage(NetworkHelper.VillagerProfessionHandler.class, MessageZombieVillagerProfession.class, 0, Side.CLIENT);
        VNNetworkWrapper.registerMessage(NetworkHelper.VillageGuardHandler.class, MessageVillageGuard.class, 1, Side.CLIENT);
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().name = TextFormatting.GOLD + "Village Names";
        event.getModMetadata().version = TextFormatting.YELLOW + "3.0";
        event.getModMetadata().credits = TextFormatting.AQUA + "Thanks to Pahimar, MineMaarten, and Jabelar for their tutorials; to Darian Stephens for playtesting; and to whrrgarbl for her help and support.";
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.add(TextFormatting.BLUE + "AstroTibs");
        event.getModMetadata().url = "minecraft.curseforge.com/projects/village-names";
        event.getModMetadata().description = TextFormatting.GREEN + "Generates random names for villages, villagers, and other structures and entities.";
        event.getModMetadata().logoFile = "assets/villagenames/vn_banner.png";
        if (GeneralConfigHandler.enableCartographer) {
            VillagerRegistry.VillagerProfession profLibrarian = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:librarian"));
            VillagerRegistry.VillagerCareer carLibrarian = profLibrarian.getCareer(1);
            VillagerRegistry.VillagerCareer carCartographer = new VillagerRegistry.VillagerCareer(profLibrarian, "cartographer");
            EntityVillager.ITradeList[] iTradeListArray = new EntityVillager.ITradeList[1];
            iTradeListArray[0] = new VillagerTradeHandler.CartographerLevel1(new VillagerTradeHandler());
            carCartographer.addTrade(1, iTradeListArray);
            EntityVillager.ITradeList[] iTradeListArray2 = new EntityVillager.ITradeList[1];
            iTradeListArray2[0] = new VillagerTradeHandler.CartographerLevel2(new VillagerTradeHandler());
            carCartographer.addTrade(2, iTradeListArray2);
            EntityVillager.ITradeList[] iTradeListArray3 = new EntityVillager.ITradeList[1];
            iTradeListArray3[0] = new VillagerTradeHandler.CartographerLevel3(new VillagerTradeHandler());
            carCartographer.addTrade(3, iTradeListArray3);
            if (GeneralConfigHandler.treasureTrades) {
                for (int i = 0; i < 3; ++i) {
                    EntityVillager.ITradeList[] iTradeListArray4 = new EntityVillager.ITradeList[1];
                    iTradeListArray4[0] = new VillagerTradeHandler.LibrarianVN(new VillagerTradeHandler());
                    carLibrarian.addTrade(i + 7, iTradeListArray4);
                    EntityVillager.ITradeList[] iTradeListArray5 = new EntityVillager.ITradeList[1];
                    iTradeListArray5[0] = new VillagerTradeHandler.CartographerVN(new VillagerTradeHandler());
                    carCartographer.addTrade(i + 4, iTradeListArray5);
                }
            }
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Recipes.init();
        if (event.getSide() == Side.CLIENT) {
            InventoryRender.init();
        }
        PROXY.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandName());
    }

    static {
        FLAG_ID = Blocks.field_150344_f;
        currentConfigFolder = "VillageNames3";
        oldConfigFolder = "VillageNames";
        obsoleteConfigFolder = "VillageNamesOLD";
        versionChecker = new VersionChecker();
        haveWarnedVersionOutOfDate = false;
        devVersionWarned = false;
        numberStructuresArchaeologist = 7;
    }
}

