/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.common;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ExtendedVillagerZombie {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("VillageNames", "villagerinfo");
    protected static final ResourceLocation PROFESSIONKEY = new ResourceLocation("VillageNames", "profession");
    protected static final ResourceLocation CAREERKEY = new ResourceLocation("VillageNames", "career");
    @CapabilityInject(value=ZombieProfession.class)
    private static Capability<ZombieProfession> ZOMBIE_PROFESSION;
    private static Capability<ZombieCareer> ZOMBIE_CAREER;

    public static void registerZombieCapabilities() {
        CapabilityManager.INSTANCE.register(ZombieProfession.class, (Capability.IStorage)new Capability.IStorage<ZombieProfession>(){

            public NBTBase writeNBT(Capability<ZombieProfession> capability, ZombieProfession instance, EnumFacing side) {
                return new NBTTagInt(instance.profession);
            }

            public void readNBT(Capability<ZombieProfession> capability, ZombieProfession instance, EnumFacing side, NBTBase nbt) {
                instance.profession = ((NBTTagInt)nbt).func_150287_d();
            }
        }, (Callable)new Callable<ZombieProfession>(){

            @Override
            public ZombieProfession call() throws Exception {
                return new ZombieProfession();
            }
        });
        CapabilityManager.INSTANCE.register(ZombieCareer.class, (Capability.IStorage)new Capability.IStorage<ZombieCareer>(){

            public NBTBase writeNBT(Capability<ZombieCareer> capability, ZombieCareer instance, EnumFacing side) {
                return new NBTTagInt(instance.career);
            }

            public void readNBT(Capability<ZombieCareer> capability, ZombieCareer instance, EnumFacing side, NBTBase nbt) {
                instance.career = ((NBTTagInt)nbt).func_150287_d();
            }
        }, (Callable)new Callable<ZombieCareer>(){

            @Override
            public ZombieCareer call() throws Exception {
                return new ZombieCareer();
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityInjector());
    }

    private static ZombieProfession getProfession(EntityZombie entity) {
        return ZOMBIE_PROFESSION != null ? (ZombieProfession)entity.getCapability(ZOMBIE_PROFESSION, null) : null;
    }

    private static ZombieCareer getCareer(EntityZombie entity) {
        return ZOMBIE_CAREER != null ? (ZombieCareer)entity.getCapability(ZOMBIE_CAREER, null) : null;
    }

    private static class CapabilityInjector {
        private CapabilityInjector() {
        }

        @SubscribeEvent
        public void attachCapability(AttachCapabilitiesEvent.Entity evt) {
            if (evt.getObject() instanceof EntityZombie) {
                evt.addCapability(PROFESSIONKEY, (ICapabilityProvider)new ICapabilitySerializable<NBTTagInt>(){
                    private final ZombieProfession state = new ZombieProfession();

                    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == ZOMBIE_PROFESSION;
                    }

                    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == ZOMBIE_PROFESSION) {
                            return (T)this.state;
                        }
                        return null;
                    }

                    public NBTTagInt serializeNBT() {
                        return new NBTTagInt(this.state.profession);
                    }

                    public void deserializeNBT(NBTTagInt nbt) {
                        this.state.profession = nbt.func_150287_d();
                    }
                });
                evt.addCapability(CAREERKEY, (ICapabilityProvider)new ICapabilitySerializable<NBTTagInt>(){
                    private final ZombieCareer state = new ZombieCareer();

                    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == ZOMBIE_CAREER;
                    }

                    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == ZOMBIE_CAREER) {
                            return (T)this.state;
                        }
                        return null;
                    }

                    public NBTTagInt serializeNBT() {
                        return new NBTTagInt(this.state.career);
                    }

                    public void deserializeNBT(NBTTagInt nbt) {
                        this.state.career = nbt.func_150287_d();
                    }
                });
            }
        }
    }

    public static class ZombieCareer {
        private int career;
    }

    public static class ZombieProfession {
        private int profession;
    }
}

