/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.gui;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.config.AlienConfigHandler;
import astrotibs.villagenames.config.AlienVillageConfigHandler;
import astrotibs.villagenames.config.AngelConfigHandler;
import astrotibs.villagenames.config.ConfigReloader;
import astrotibs.villagenames.config.CustomConfigHandler;
import astrotibs.villagenames.config.DemonConfigHandler;
import astrotibs.villagenames.config.DragonConfigHandler;
import astrotibs.villagenames.config.EndCityConfigHandler;
import astrotibs.villagenames.config.FortressConfigHandler;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.config.GoblinConfigHandler;
import astrotibs.villagenames.config.GolemConfigHandler;
import astrotibs.villagenames.config.MansionConfigHandler;
import astrotibs.villagenames.config.MineshaftConfigHandler;
import astrotibs.villagenames.config.MonumentConfigHandler;
import astrotibs.villagenames.config.StrongholdConfigHandler;
import astrotibs.villagenames.config.TempleConfigHandler;
import astrotibs.villagenames.config.VillageConfigHandler;
import astrotibs.villagenames.config.VillagerConfigHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public class VNGuiConfig
extends GuiConfig {
    public VNGuiConfig(GuiScreen guiScreen) {
        super(guiScreen, VNGuiConfig.getElements(), "VillageNames", false, false, VNGuiConfig.getHeader());
    }

    private static String getHeader() {
        return TextFormatting.YELLOW + VillageNames.configDirectory.getAbsolutePath();
    }

    private static List<IConfigElement> getElements() {
        ArrayList<IConfigElement> topCats = new ArrayList<IConfigElement>();
        ArrayList<ConfigElement> subCats = new ArrayList<ConfigElement>();
        ConfigCategory cc = GeneralConfigHandler.config.getCategory("general");
        cc.setComment("Change things like well decorations, name formats, and Codex/book settings");
        subCats.add(new ConfigElement(cc));
        cc = GeneralConfigHandler.config.getCategory("well kill switch");
        cc.setComment("Disable well decorations outright");
        subCats.add(new ConfigElement(cc));
        cc = GeneralConfigHandler.config.getCategory("entity names");
        cc.setComment("Name generation for vanilla and modded entities");
        subCats.add(new ConfigElement(cc));
        cc = GeneralConfigHandler.config.getCategory("world of color");
        cc.setComment("Add Concrete and Glazed Terracotta from 1.12");
        cc.setRequiresWorldRestart(true);
        cc.setRequiresMcRestart(true);
        subCats.add(new ConfigElement(cc));
        cc = GeneralConfigHandler.config.getCategory("sounds");
        cc.setComment("Add in sound effects backported from various Minecraft versions");
        subCats.add(new ConfigElement(cc));
        cc = GeneralConfigHandler.config.getCategory("mod naming");
        cc.setComment("Naming certain mod structures, and associating non-vanilla villagers with vanilla professions for the purposes of generating hint pages");
        subCats.add(new ConfigElement(cc));
        cc = GeneralConfigHandler.config.getCategory("villager professions");
        cc.setComment("Profession and career assignment");
        subCats.add(new ConfigElement(cc));
        cc.setRequiresMcRestart(true);
        cc = GeneralConfigHandler.config.getCategory("miscellaneous");
        cc.setComment("Activate debug messages here");
        subCats.add(new ConfigElement(cc));
        topCats.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("General Settings", "config.villagenames.global", subCats));
        subCats = new ArrayList();
        cc = VillagerConfigHandler.config.getCategory("villager syllable pool");
        cc.setComment("Syllables for naming villagers");
        subCats.add(new ConfigElement(cc));
        cc = VillageConfigHandler.config.getCategory("village syllable pool");
        cc.setComment("Syllables for naming villages");
        subCats.add(new ConfigElement(cc));
        cc = TempleConfigHandler.config.getCategory("temple syllable pool");
        cc.setComment("Syllables for naming temples, pyramids, swamp huts, and igloos");
        subCats.add(new ConfigElement(cc));
        cc = MineshaftConfigHandler.config.getCategory("mineshaft syllable pool");
        cc.setComment("Syllables for naming mineshafts");
        subCats.add(new ConfigElement(cc));
        cc = FortressConfigHandler.config.getCategory("fortress syllable pool");
        cc.setComment("Syllables for naming Nether fortresses");
        subCats.add(new ConfigElement(cc));
        cc = StrongholdConfigHandler.config.getCategory("stronghold syllable pool");
        cc.setComment("Syllables for naming strongholds");
        subCats.add(new ConfigElement(cc));
        cc = MonumentConfigHandler.config.getCategory("monument syllable pool");
        cc.setComment("Syllables for naming ocean monuments");
        subCats.add(new ConfigElement(cc));
        cc = EndCityConfigHandler.config.getCategory("end city syllable pool");
        cc.setComment("Syllables for naming End cities");
        subCats.add(new ConfigElement(cc));
        cc = MansionConfigHandler.config.getCategory("mansion syllable pool");
        cc.setComment("Syllables for naming woodland mansions");
        subCats.add(new ConfigElement(cc));
        cc = GolemConfigHandler.config.getCategory("golem syllable pool");
        cc.setComment("Syllables for naming golems");
        subCats.add(new ConfigElement(cc));
        cc = DragonConfigHandler.config.getCategory("dragon syllable pool");
        cc.setComment("Syllables for naming dragons");
        subCats.add(new ConfigElement(cc));
        cc = AngelConfigHandler.config.getCategory("angel syllable pool");
        cc.setComment("Syllables to generate angel names");
        subCats.add(new ConfigElement(cc));
        cc = DemonConfigHandler.config.getCategory("demon syllable pool");
        cc.setComment("Syllables to generate demon names");
        subCats.add(new ConfigElement(cc));
        cc = GoblinConfigHandler.config.getCategory("goblin syllable pool");
        cc.setComment("Syllables to generate fairy/goblin names");
        subCats.add(new ConfigElement(cc));
        cc = AlienConfigHandler.config.getCategory("alien syllable pool");
        cc.setComment("Syllables to generate alien names");
        subCats.add(new ConfigElement(cc));
        cc = AlienVillageConfigHandler.config.getCategory("alien village syllable pool");
        cc.setComment("Syllables to generate alien village names");
        subCats.add(new ConfigElement(cc));
        cc = CustomConfigHandler.config.getCategory("custom syllable pool");
        cc.setComment("Dedicated section for players to assign names to using their own syllable pools");
        subCats.add(new ConfigElement(cc));
        topCats.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Syllable Pools", "config.villagenames.syllables", subCats));
        return topCats;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2000) {
            boolean flag = true;
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof VNGuiConfig)) && this.entryList.hasChangedEntry(true)) {
                    boolean requiresMcRestart = this.entryList.saveConfigElements();
                    if (Loader.isModLoaded((String)this.modID)) {
                        ConfigChangedEvent event = new ConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        FMLCommonHandler.instance().bus().post((Event)event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            FMLCommonHandler.instance().bus().post((Event)new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        ConfigReloader.reloadConfigs();
                        if (requiresMcRestart) {
                            flag = false;
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof VNGuiConfig) {
                            ((VNGuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (flag) {
                this.field_146297_k.func_147108_a(this.parentScreen);
            }
        }
    }
}

