/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.handler.AchievementReward;
import astrotibs.villagenames.handler.EntityInteractHandler;
import astrotibs.villagenames.handler.ReputationHandler;
import astrotibs.villagenames.tracker.EventTracker;
import astrotibs.villagenames.tracker.ServerInfoTracker;
import astrotibs.villagenames.utility.GenericHelper;
import astrotibs.villagenames.utility.LogHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityMonitorHandler {
    protected static int tickRate = 50;
    protected final int failuresToForceAcceptance = 100;

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityVillager && GenericHelper.isVanillaZombie(event.getSource().func_76346_g())) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            ServerInfoTracker.add(villager, villager.field_70170_p);
            if (GeneralConfigHandler.debugMessages) {
                LogHelper.info("EntityMonitorHandler > A zombie just killed villager " + (villager.func_95999_t().equals("") || villager.func_95999_t().equals(null) ? "(None)" : villager.func_95999_t()) + " [" + villager.func_145782_y() + "] at [" + new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v) + "], profession [" + villager.func_70946_n() + "]");
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (GenericHelper.isVanillaZombie(event.getEntity())) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            if (!event.getWorld().field_72995_K && zombie.func_82231_m()) {
                EventTracker eventTracker = ServerInfoTracker.seek(ServerInfoTracker.EventType.VILLAGER, new Vec3i(zombie.field_70165_t, zombie.field_70163_u + 0.5, zombie.field_70161_v), zombie.field_70170_p);
            }
        } else if (event.getEntity() instanceof EntityVillager && !event.getWorld().field_72995_K) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            EventTracker tracked = ServerInfoTracker.seek(ServerInfoTracker.EventType.ZOMBIE, new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v), villager.field_70170_p);
            if (tracked != null) {
                if (GeneralConfigHandler.debugMessages) {
                    LogHelper.info("EntityMonitorHandler > Found info on the tracker--must copy to villager");
                }
                tracked.updateVillager(villager);
                ServerInfoTracker.endedCuringZombie(tracked.getEntityID(), villager.func_145782_y(), villager.field_70170_p);
                ServerInfoTracker.removeCuredZombiesFromTracker(event.getWorld(), tracked.getEntityID());
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (GenericHelper.isVanillaZombie(event.getEntity())) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            if (!zombie.field_70170_p.field_72995_K && zombie.func_82230_o()) {
                double checkfactor = 10.0;
                int vanillaRollbackTicks = 0;
                if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < (double)0.01f * checkfactor) {
                    int countedBedsOrBars = 0;
                    for (int k = (int)zombie.field_70165_t - 4; k < (int)zombie.field_70165_t + 4 && countedBedsOrBars < 14; ++k) {
                        for (int l = (int)zombie.field_70163_u - 4; l < (int)zombie.field_70163_u + 4 && countedBedsOrBars < 14; ++l) {
                            for (int i1 = (int)zombie.field_70161_v - 4; i1 < (int)zombie.field_70161_v + 4 && countedBedsOrBars < 14; ++i1) {
                                Block block = zombie.field_70170_p.func_180495_p(new BlockPos(k, l, i1)).func_177230_c();
                                if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                                if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < (double)0.3f / checkfactor) {
                                    --vanillaRollbackTicks;
                                }
                                ++countedBedsOrBars;
                            }
                        }
                    }
                }
                Map<String, ArrayList> zombieCureCatalysts = GeneralConfigHandler.unpackZombieCureCatalysts(GeneralConfigHandler.zombieCureCatalysts);
                Map<String, ArrayList> zombieCureGroups = GeneralConfigHandler.unpackZombieCureGroups(GeneralConfigHandler.zombieCureGroups);
                int modTickAdjustment = 0;
                if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < (double)0.01f * checkfactor) {
                    for (int groupi = 0; groupi < zombieCureGroups.get("Groups").size(); ++groupi) {
                        String group = (String)zombieCureGroups.get("Groups").get(groupi);
                        int groupLimit = (Integer)zombieCureGroups.get("Limits").get(groupi);
                        double groupSpeedup = (Double)zombieCureGroups.get("Speedups").get(groupi) / checkfactor;
                        int speedupSign = groupSpeedup < 0.0 ? -1 : 1;
                        groupSpeedup = Math.abs(groupSpeedup);
                        int countedGroupBlocks = 0;
                        for (int k = (int)zombie.field_70165_t - 4; k < (int)zombie.field_70165_t + 4 && countedGroupBlocks < groupLimit; ++k) {
                            for (int l = (int)zombie.field_70163_u - 4; l < (int)zombie.field_70163_u + 4 && countedGroupBlocks < groupLimit; ++l) {
                                block16: for (int i1 = (int)zombie.field_70161_v - 4; i1 < (int)zombie.field_70161_v + 4 && countedGroupBlocks < groupLimit; ++i1) {
                                    IBlockState blockState = zombie.field_70170_p.func_180495_p(new BlockPos(k, l, i1));
                                    Block block = blockState.func_177230_c();
                                    int blockmeta = block.func_176201_c(blockState);
                                    String blockClassPath = block.getClass().toString().substring(6);
                                    String blockUnlocName = block.func_149739_a();
                                    for (int blocki = 0; blocki < zombieCureCatalysts.get("Groups").size(); ++blocki) {
                                        String catalystGroup = (String)zombieCureCatalysts.get("Groups").get(blocki);
                                        String catalystClassPath = (String)zombieCureCatalysts.get("ClassPaths").get(blocki);
                                        String catalystUnlocName = (String)zombieCureCatalysts.get("UnlocNames").get(blocki);
                                        int catalystMeta = (Integer)zombieCureCatalysts.get("Metas").get(blocki);
                                        if (!catalystGroup.equals(group) || !catalystClassPath.equals(blockClassPath) || !catalystUnlocName.equals("") && !catalystUnlocName.equals(blockUnlocName) || catalystMeta != -1 && blockmeta != catalystMeta) continue;
                                        int i = 1;
                                        while ((double)i < groupSpeedup) {
                                            modTickAdjustment += speedupSign;
                                            ++i;
                                        }
                                        if ((double)zombie.field_70170_p.field_73012_v.nextFloat() < groupSpeedup % 1.0) {
                                            modTickAdjustment += speedupSign;
                                        }
                                        ++countedGroupBlocks;
                                        continue block16;
                                    }
                                }
                            }
                        }
                    }
                }
                int conversionTime = 0;
                try {
                    conversionTime = (Integer)ReflectionHelper.getPrivateValue(EntityZombie.class, (Object)((EntityZombie)event.getEntity()), (String[])new String[]{"conversionTime", "field_82234_d"});
                    conversionTime -= vanillaRollbackTicks + modTickAdjustment;
                    conversionTime = Math.min(conversionTime, 6000);
                    ReflectionHelper.setPrivateValue(EntityZombie.class, (Object)((EntityZombie)event.getEntity()), (Object)conversionTime, (String[])new String[]{"conversionTime", "field_82234_d"});
                }
                catch (Exception group) {
                    // empty catch block
                }
                Method getConversionTimeBoost_m = ReflectionHelper.findMethod(EntityZombie.class, (Object)((EntityZombie)event.getEntity()), (String[])new String[]{"getConversionTimeBoost", "func_82233_q"}, (Class[])new Class[0]);
                int getConversionTimeBoost = 0;
                try {
                    getConversionTimeBoost = (Integer)getConversionTimeBoost_m.invoke((Object)((EntityZombie)event.getEntity()), new Object[0]);
                }
                catch (Exception groupSpeedup) {
                    // empty catch block
                }
                int nextConversionTime = conversionTime - getConversionTimeBoost;
                if (GeneralConfigHandler.debugMessages && nextConversionTime <= 500 && nextConversionTime % 20 == 0) {
                    LogHelper.info("EntityMonitorHandler > Zombie [" + zombie.func_145782_y() + "] being cured in " + conversionTime + " ticks");
                }
                if (nextConversionTime <= 0 && conversionTime > 0) {
                    if (GeneralConfigHandler.debugMessages) {
                        LogHelper.info("EntityMonitorHandler > Zombie " + zombie.toString() + " is about to be cured in tick " + event.getEntity().func_184102_h().func_71259_af());
                    }
                    ServerInfoTracker.add(zombie, event.getEntity().field_70170_p);
                }
            }
        } else if (Loader.isModLoaded((String)"witchery") && event.getEntity() instanceof EntityLiving && event.getEntity().getClass().toString().substring(6).equals("com.emoniph.witchery.entity.EntityVillageGuard") && ServerInfoTracker.EventType.GUARD.getTracker().size() > 0) {
            EntityLiving guard = (EntityLiving)event.getEntity();
            if (!event.getEntity().field_70170_p.field_72995_K) {
                EventTracker checkfactor = ServerInfoTracker.seek(ServerInfoTracker.EventType.GUARD, new Vec3i(guard.field_70165_t, guard.field_70163_u + 0.5, guard.field_70161_v), event.getEntity().field_70170_p);
            }
        } else if (event.getEntity() instanceof EntityVillager && !event.getEntity().field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            NBTTagCompound compound = new NBTTagCompound();
            villager.func_70014_b(compound);
            int profession = compound.func_74762_e("Profession");
            int career = compound.func_74762_e("Career");
            int careerLevel = compound.func_74762_e("CareerLevel");
            if (profession == 1) {
                int i;
                MerchantRecipeList buyingList2;
                if (career == 1 && careerLevel >= 3 && GeneralConfigHandler.writtenBookTrade) {
                    try {
                        buyingList2 = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"buyingList", "field_70963_i"});
                        for (i = 5; i < buyingList2.size(); ++i) {
                            MerchantRecipe extractedRecipe = (MerchantRecipe)buyingList2.get(i);
                            ItemStack itemToBuy1 = extractedRecipe.func_77394_a();
                            ItemStack itemToBuy2 = extractedRecipe.func_77396_b();
                            ItemStack itemToSell = extractedRecipe.func_77397_d();
                            if (itemToBuy1.func_77973_b() != Items.field_151164_bB || itemToBuy1.field_77994_a != 2 || itemToBuy2 != null || itemToSell.func_77973_b() != Items.field_151166_bC) continue;
                            buyingList2.set(i, (Object)new MerchantRecipe(new ItemStack(Items.field_151164_bB, 1), null, new ItemStack(Items.field_151166_bC, 1)));
                            if (GeneralConfigHandler.debugMessages) {
                                LogHelper.info("Replacing malformed written book trade for Librarian with ID " + villager.func_145782_y());
                            }
                            break;
                        }
                    }
                    catch (Exception buyingList2) {
                        // empty catch block
                    }
                }
                if ((career == 2 && careerLevel > 3 || career == 1 && careerLevel > 6) && GeneralConfigHandler.enableCartographer) {
                    try {
                        buyingList2 = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"buyingList", "field_70963_i"});
                        if (buyingList2.size() > careerLevel + (career == 2 ? 0 : 5)) {
                            int n = i = career == 2 ? 3 : 11;
                            while (i < buyingList2.size()) {
                                ItemStack stackBuyToCompare = ((MerchantRecipe)buyingList2.get(i)).func_77394_a();
                                ItemStack stackSellToCompare = ((MerchantRecipe)buyingList2.get(i)).func_77397_d();
                                for (int j = buyingList2.size() - 1; j > i; --j) {
                                    ItemStack stackBuyToEvaluate = ((MerchantRecipe)buyingList2.get(j)).func_77394_a();
                                    ItemStack stackSellToEvaluate = ((MerchantRecipe)buyingList2.get(j)).func_77397_d();
                                    Set enchantmentCompare = EnchantmentHelper.func_82781_a((ItemStack)stackSellToCompare).keySet();
                                    Set enchantmentEvaluate = EnchantmentHelper.func_82781_a((ItemStack)stackSellToEvaluate).keySet();
                                    if (stackBuyToCompare.func_77973_b() != stackBuyToEvaluate.func_77973_b() || stackSellToCompare.func_77973_b() != stackSellToEvaluate.func_77973_b() || !enchantmentCompare.equals(enchantmentEvaluate)) continue;
                                    buyingList2.remove(j);
                                }
                                ++i;
                            }
                            int loopKiller = 0;
                            while (buyingList2.size() > careerLevel + (career == 2 ? 0 : 5)) {
                                int indexToRemove = careerLevel - 1 + (career == 2 ? 0 : 5) + villager.field_70170_p.field_73012_v.nextInt(buyingList2.size() - (careerLevel - 1 + (career == 2 ? 0 : 5)));
                                buyingList2.remove(indexToRemove);
                                if (++loopKiller < 100) continue;
                                if (!GeneralConfigHandler.debugMessages) break;
                                LogHelper.warn("Infinite loop suspected while pruning librarian trade list.");
                                break;
                            }
                        }
                        ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)buyingList2, (String[])new String[]{"buyingList", "field_70963_i"});
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (event.getEntity() instanceof EntityPlayerMP && !event.getEntity().field_70170_p.field_72995_K && event.getEntity().field_71093_bK == 0 && event.getEntity().field_70173_aa % tickRate == 0) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            World world = player.field_70170_p;
            try {
                String villageTopTagPlayerIsIn = ReputationHandler.getVillageTagPlayerIsIn(player);
                Village villageObjPlayerIsIn = world.field_72982_D.func_176056_a(player.func_180425_c(), EntityInteractHandler.villageRadiusBuffer);
                if (!villageTopTagPlayerIsIn.equals("none") || villageObjPlayerIsIn != null) {
                    int playerRep = ReputationHandler.getVNReputationForPlayer(player, villageTopTagPlayerIsIn, villageObjPlayerIsIn);
                    if (playerRep <= -30 && !player.func_147099_x().func_77443_a(VillageNames.minrep)) {
                        player.func_71029_a((StatBase)VillageNames.minrep);
                        AchievementReward.allFiveAchievements(player);
                    } else if (playerRep >= 10 && !player.func_147099_x().func_77443_a(VillageNames.maxrep)) {
                        player.func_71029_a((StatBase)VillageNames.maxrep);
                        AchievementReward.allFiveAchievements(player);
                    }
                    if (tickRate < 50) {
                        tickRate += 2;
                    } else if (tickRate > 50) {
                        tickRate = 50;
                    }
                } else {
                    tickRate = 100;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

