/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.nbt;

import astrotibs.villagenames.config.GeneralConfigHandler;
import astrotibs.villagenames.nbt.VNWorldDataStructure;
import astrotibs.villagenames.utility.LogHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NBTUpdater {
    @SubscribeEvent(receiveCanceled=true)
    public void retroGenElders(WorldEvent.Load event) {
        block14: {
            World world = event.getWorld();
            if (!world.field_72995_K) {
                boolean warnPlayer = false;
                HashMap<String, String> old_dataname_map = new HashMap<String, String>();
                old_dataname_map.put("villagenames", "Villages");
                old_dataname_map.put("villagenames_te", "Temples");
                old_dataname_map.put("villagenames_mi", "Mineshafts");
                old_dataname_map.put("villagenames_st", "Strongholds");
                old_dataname_map.put("villagenames_mo", "Monuments");
                old_dataname_map.put("villagenames_ma", "Mansions");
                old_dataname_map.put("villagenames_fo", "Fortresses");
                old_dataname_map.put("villagenames_ec", "EndCities");
                old_dataname_map.put("villagenames_gcab", "AbandonedBases");
                old_dataname_map.put("villagenames_heei", "hardcoreenderdragon_EndIsland");
                old_dataname_map.put("villagenames_heet", "hardcoreenderdragon_EndTower");
                old_dataname_map.put("villagenames_mpfv", "FronosVillages");
                old_dataname_map.put("villagenames_mpkv", "KoentusVillages");
                old_dataname_map.put("villagenames_gcmv", "MoonVillages");
                old_dataname_map.put("villagenames_mpnv", "NibiruVillages");
                String[] new_titleTags = new String[]{"Village", "Temple", "Mineshaft", "Stronghold", "Monument", "Mansion", "Fortress", "EndCity", "GC_AbandonedBase", "hardcoreenderdragon_EndIsland", "hardcoreenderdragon_EndTower", "FronosVillage", "KoentusVillage", "MoonVillage", "NibiruVillage", "DUMMY"};
                String[] old_topTags = new String[]{"Villages", "Temples", "Mineshafts", "Strongholds", "Monuments", "Mansions", "Fortresses", "EndCities", "AbandonedBases", "hardcoreenderdragon_EndIsland", "hardcoreenderdragon_EndTower", "FronosVillages", "KoentusVillages", "MoonVillages", "NibiruVillages", "NamedStructures"};
                String[] old_filenames = new String[]{"villagenames", "villagenames_te", "villagenames_mi", "villagenames_st", "villagenames_mo", "villagenames_ma", "villagenames_fo", "villagenames_ec", "villagenames_gcab", "villagenames_heei", "villagenames_heet", "villagenames_mpfv", "villagenames_mpkv", "villagenames_gcmv", "villagenames_mpnv", "villagenames_DUMMY"};
                for (int i = 0; i < old_filenames.length; ++i) {
                    VNWorldDataStructure data_old = VNWorldDataStructure.forWorld(world, old_filenames[i], old_topTags[i]);
                    NBTTagCompound tagCompound_old = data_old.getData();
                    Set tagmapKeyset_old = tagCompound_old.func_150296_c();
                    VNWorldDataStructure data_new = VNWorldDataStructure.forWorld(world, "villagenames3_" + new_titleTags[i], "NamedStructures");
                    NBTTagCompound tagCompound_new = data_new.getData();
                    Set tagmapKeyset_new = tagCompound_new.func_150296_c();
                    if (tagmapKeyset_new.size() <= 0) {
                        if (tagmapKeyset_old.size() <= 0) continue;
                        warnPlayer = true;
                        Iterator itr = tagmapKeyset_old.iterator();
                        LogHelper.info("ATTENTION! The old data file " + old_filenames[i] + ".nat will no longer be used. Its data has been moved into the new file villagenames3_" + new_titleTags[i] + ".dat");
                        while (itr.hasNext()) {
                            Object element = itr.next();
                            String townSignEntry_old = element.toString();
                            NBTTagCompound tagList_old = tagCompound_old.func_150295_c(townSignEntry_old, (int)tagCompound_old.func_74732_a()).func_150305_b(0);
                            NBTTagList nbttaglist_new = new NBTTagList();
                            NBTTagCompound nbttagcompound1 = tagList_old;
                            if (townSignEntry_old.indexOf("_nosign") != -1) {
                                nbttagcompound1.func_74757_a("preVN", true);
                            }
                            if (townSignEntry_old.indexOf("_fromvillager") != -1) {
                                nbttagcompound1.func_74757_a("fromEntity", true);
                            }
                            if (townSignEntry_old.indexOf("_fromcodex") != -1) {
                                nbttagcompound1.func_74757_a("fromCodex", true);
                            }
                            nbttaglist_new.func_74742_a((NBTBase)nbttagcompound1);
                            String namePrefix = tagList_old.func_74779_i("namePrefix");
                            String nameRoot = tagList_old.func_74779_i("nameRoot");
                            String nameSuffix = tagList_old.func_74779_i("nameSuffix");
                            String signX = tagList_old.func_74779_i("signX");
                            String signY = tagList_old.func_74779_i("signY");
                            String signZ = tagList_old.func_74779_i("signZ");
                            data_new.getData().func_74782_a((namePrefix + " " + nameRoot + " " + nameSuffix).trim() + ", x" + signX + " y" + signY + " z" + signZ, (NBTBase)nbttaglist_new);
                        }
                        data_new.func_76185_a();
                        continue;
                    }
                    if (tagmapKeyset_old.size() <= tagmapKeyset_new.size()) continue;
                    LogHelper.error("ATTENTION! The new data file" + new_titleTags[i] + ".dat has entries, but the old " + old_filenames[i] + ".dathas MORE entries.");
                    LogHelper.error("This could happen if you switched to an older version of Village Names after running a newer one. Either way, those new names will be ignored.");
                }
                if (GeneralConfigHandler.swampHutMushroomPot && world.field_73011_w.getDimension() == 0) {
                    try {
                        MapGenStructureData structureData = (MapGenStructureData)event.getWorld().getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Temple");
                        NBTTagCompound nbttagcompound = structureData.func_143041_a();
                        for (Object element : nbttagcompound.func_150296_c()) {
                            try {
                                NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                                if (nbtbase.func_74732_a() != 10) continue;
                                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                                int[] boundingBoxIA = nbttagcompound2.func_74759_k("BB");
                                StructureBoundingBox boundingBox = new StructureBoundingBox(boundingBoxIA);
                                boolean hasHadWoolReplaced = nbttagcompound2.func_74767_n("VNMushroomPotFixed");
                                String templeType = nbttagcompound2.func_150295_c("Children", 10).func_150305_b(0).func_74779_i("id");
                                if (!templeType.equals("TeSH") || hasHadWoolReplaced) continue;
                                int ChunkX = nbttagcompound2.func_74762_e("ChunkX");
                                int ChunkZ = nbttagcompound2.func_74762_e("ChunkZ");
                                double swampHutXCenter = (double)(boundingBox.field_78893_d + boundingBox.field_78897_a) / 2.0;
                                double swampHutZCenter = (double)(boundingBox.field_78892_f + boundingBox.field_78896_c) / 2.0;
                                this.updateSwampHutPot(event, ChunkX, ChunkZ);
                                if (GeneralConfigHandler.debugMessages) {
                                    LogHelper.info("Updating swamp hut mushroom pot at " + (int)swampHutXCenter + " " + (int)swampHutZCenter);
                                }
                                nbttagcompound2.func_74757_a("VNMushroomPotFixed", true);
                                structureData.func_76186_a(true);
                            }
                            catch (Exception e) {
                                LogHelper.warn("Failed to evaluate flower pot status of Swamp Hut");
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!GeneralConfigHandler.debugMessages) break block14;
                        LogHelper.warn("Failed to load Temple list, or none exists.");
                    }
                }
            }
        }
    }

    private void updateSwampHutPot(WorldEvent.Load event, int ChunkX, int ChunkZ) {
        for (int k = 50; k <= 80; ++k) {
            for (int i = -16; i < 16; ++i) {
                for (int j = -16; j < 16; ++j) {
                    int potmeta;
                    BlockPos potPos = new BlockPos((ChunkX << 4) + i, k, (ChunkZ << 4) + j);
                    IBlockState iblockstate = event.getWorld().func_180495_p(potPos);
                    Block blocktoscan = iblockstate.func_177230_c();
                    if (blocktoscan != Blocks.field_150457_bL || (potmeta = blocktoscan.func_176201_c(iblockstate)) == 7) continue;
                    TileEntity flowerPotWithRedMushroom = new BlockFlowerPot().func_149915_a(event.getWorld(), 7);
                    event.getWorld().func_175656_a(potPos, Blocks.field_150457_bL.func_176223_P());
                    event.getWorld().func_175690_a(potPos, flowerPotWithRedMushroom);
                    return;
                }
            }
        }
    }
}

