/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class StringFunctions {
    public static void sendMessage(CommandSource source, String m, TextFormatting colour) {
        StringFunctions.sendMessage(source, m, colour, false);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour) {
        StringFunctions.sendMessage(player, m, colour, false);
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour, boolean emptyline) {
        if (emptyline) {
            source.func_197030_a((ITextComponent)new StringTextComponent(""), true);
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_150256_b().func_150238_a(colour);
        source.func_197030_a((ITextComponent)message, true);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour, boolean emptyline) {
        if (emptyline) {
            player.func_145747_a((ITextComponent)new StringTextComponent(""));
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_150256_b().func_150238_a(colour);
        player.func_145747_a((ITextComponent)message);
    }

    public static void broadcastMessage(World world, String m, TextFormatting colour) {
        StringTextComponent message = new StringTextComponent(m);
        message.func_150256_b().func_150238_a(colour);
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return;
        }
        server.func_184103_al().func_148539_a((ITextComponent)message);
    }

    public static String capitalizeFirst(String string) {
        StringBuffer sb = new StringBuffer(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    private static String escapeSpecialRegexChars(String str) {
        return Pattern.compile("[{}()\\[\\].+*?^$\\\\|]").matcher(str).replaceAll("\\\\$0");
    }

    public static String getRandomName(boolean malenames, boolean femalenames) {
        List<String> allnames;
        if (malenames && femalenames) {
            allnames = Stream.concat(GlobalVariables.femalenames.stream(), GlobalVariables.malenames.stream()).collect(Collectors.toList());
        } else if (femalenames) {
            allnames = GlobalVariables.femalenames;
        } else if (malenames) {
            allnames = GlobalVariables.malenames;
        } else {
            return "";
        }
        String name = allnames.get(GlobalVariables.random.nextInt(allnames.size())).toLowerCase();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String getPCLocalTime(boolean twentyfour, boolean showseconds) {
        String time = "";
        LocalDateTime now = LocalDateTime.now();
        time = showseconds ? (twentyfour ? now.format(DateTimeFormatter.ofPattern("HH:mm:ss")) : now.format(DateTimeFormatter.ofPattern("hh:mm:ss a"))) : (twentyfour ? now.format(DateTimeFormatter.ofPattern("HH:mm")) : now.format(DateTimeFormatter.ofPattern("hh:mm a")));
        return time;
    }
}

