/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModModels;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.compat.CommonProxyCompat;
import com.ferreusveritas.dynamictrees.proxy.CommonProxy;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import net.minecraft.block.BlockPlanks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="dynamictrees", version="1.10.2-0.7.2d", dependencies="after:ComputerCraft;after:Quark", acceptedMinecraftVersions="[1.10.2]")
public class DynamicTrees {
    @Mod.Instance(value="dynamictrees")
    public static DynamicTrees instance;
    @SidedProxy(clientSide="com.ferreusveritas.dynamictrees.proxy.ClientProxy", serverSide="com.ferreusveritas.dynamictrees.proxy.CommonProxy")
    public static CommonProxy proxy;
    @SidedProxy(clientSide="com.ferreusveritas.dynamictrees.compat.ClientProxyCompat", serverSide="com.ferreusveritas.dynamictrees.compat.CommonProxyCompat")
    public static CommonProxyCompat compatProxy;
    public static final CreativeTabs dynamicTreesTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            ModConfigs.preInit(event);
            TreeGenerator.preInit();
            ModBlocks.preInit();
            ModItems.preInit();
            ModTrees.preInit();
            proxy.preInit();
            compatProxy.preInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RegistrationHandler.registerBlocks();
        RegistrationHandler.registerItems();
        proxy.registerModels();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TreeGenerator.init();
        RegistrationHandler.registerRecipes();
        proxy.init();
        compatProxy.init();
    }

    static {
        dynamicTreesTab = new CreativeTabs("dynamictrees"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return TreeRegistry.findSpeciesSloppy(BlockPlanks.EnumType.OAK.func_176610_l()).getSeedStack(1).func_77973_b();
            }
        };
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        public static void registerBlocks() {
            ModBlocks.registerBlocks();
        }

        public static void registerItems() {
            ModItems.registerItems();
        }

        public static void registerRecipes() {
            ModRecipes.registerRecipes();
        }

        public static void registerModels() {
            ModModels.registerModels();
        }

        @SubscribeEvent
        public static void newRegistry(RegistryEvent.NewRegistry event) {
            Species.newRegistry(event);
        }
    }
}

