/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.IAgeable;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.blocks.NullTreePart;
import com.ferreusveritas.dynamictrees.inspectors.NodeTwinkle;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeHelper {
    private static HashMap<String, HashMap<Integer, BlockDynamicLeaves>> modLeavesArray = new HashMap();
    public static final ITreePart nullTreePart = new NullTreePart();

    public static BlockDynamicLeaves getLeavesBlockForSequence(String modid, int seq) {
        int leavesBlockNum;
        int key;
        HashMap<Integer, BlockDynamicLeaves> leavesMap = TreeHelper.getLeavesMapForModId(modid);
        if (leavesMap.containsKey(key = (leavesBlockNum = seq / 4))) {
            return leavesMap.get(key);
        }
        BlockDynamicLeaves leavesBlock = new BlockDynamicLeaves();
        leavesBlock.setRegistryName(modid, "leaves" + leavesBlockNum);
        leavesBlock.func_149663_c("leaves" + leavesBlockNum);
        leavesMap.put(key, leavesBlock);
        return leavesBlock;
    }

    public static HashMap<Integer, BlockDynamicLeaves> getLeavesMapForModId(String modid) {
        HashMap<Integer, BlockDynamicLeaves> leavesMap;
        if (modLeavesArray.containsKey(modid)) {
            leavesMap = modLeavesArray.get(modid);
        } else {
            leavesMap = new HashMap();
            modLeavesArray.put(modid, leavesMap);
        }
        return leavesMap;
    }

    public static void growPulse(World world, BlockPos rootPos) {
        BlockRootyDirt dirt = TreeHelper.getRootyDirt((IBlockAccess)world, rootPos);
        if (dirt != null) {
            dirt.updateTree(world, rootPos, world.field_73012_v, true);
            TreeHelper.ageVolume(world, rootPos, 1);
        }
    }

    public static void ageVolume(World world, BlockPos pos, int iterations) {
        TreeHelper.ageVolume(world, pos, 8, 32, null, iterations);
    }

    public static void ageVolume(World world, BlockPos treePos, int halfWidth, int height, SimpleVoxmap leafMap, int iterations) {
        Iterable iterable = leafMap != null ? leafMap.getAllNonZero((byte)15) : BlockPos.func_177980_a((BlockPos)treePos.func_177971_a((Vec3i)new BlockPos(-halfWidth, 0, -halfWidth)), (BlockPos)treePos.func_177971_a((Vec3i)new BlockPos(halfWidth, height, halfWidth)));
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos iPos : iterable) {
                IBlockState blockState = world.func_180495_p(iPos);
                Block block = blockState.func_177230_c();
                if (!(block instanceof IAgeable) || !((IAgeable)block).age(world, iPos, blockState, world.field_73012_v, true) || leafMap == null) continue;
                leafMap.setVoxel(iPos, (byte)0);
            }
        }
    }

    public static void treeParticles(World world, BlockPos rootPos, EnumParticleTypes type, int num) {
        if (world.field_72995_K) {
            TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(new NodeTwinkle(type, num)));
        }
    }

    public static boolean startAnalysisFromRoot(World world, BlockPos rootPos, MapSignal signal) {
        BlockRootyDirt dirt = TreeHelper.getRootyDirt((IBlockAccess)world, rootPos);
        if (dirt != null) {
            dirt.startAnalysis(world, rootPos, signal);
            return true;
        }
        return false;
    }

    public static BlockPos findGround(World world, BlockPos pos) {
        while (world.func_180495_p(pos).func_185917_h()) {
            pos = pos.func_177984_a();
        }
        while (!world.func_180495_p(pos).func_185917_h() && pos.func_177956_o() > 50) {
            pos = pos.func_177977_b();
        }
        return pos;
    }

    public static boolean isTreePart(Block block) {
        return block instanceof ITreePart;
    }

    public static boolean isTreePart(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isTreePart(blockAccess.func_180495_p(pos).func_177230_c());
    }

    public static ITreePart getTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (ITreePart)block : null;
    }

    public static ITreePart getTreePart(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getTreePart(blockAccess.func_180495_p(pos).func_177230_c());
    }

    public static ITreePart getTreePart(IBlockState state) {
        return TreeHelper.getTreePart(state.func_177230_c());
    }

    public static ITreePart getSafeTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (ITreePart)block : nullTreePart;
    }

    public static ITreePart getSafeTreePart(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getSafeTreePart(blockAccess.func_180495_p(pos));
    }

    public static ITreePart getSafeTreePart(IBlockState blockState) {
        return TreeHelper.getSafeTreePart(blockState.func_177230_c());
    }

    public static boolean isBranch(Block block) {
        return block instanceof BlockBranch;
    }

    public static boolean isBranch(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isBranch(blockAccess.func_180495_p(pos).func_177230_c());
    }

    public static boolean isBranch(IBlockState state) {
        return TreeHelper.isBranch(state.func_177230_c());
    }

    public static BlockBranch getBranch(Block block) {
        return TreeHelper.isBranch(block) ? (BlockBranch)block : null;
    }

    public static BlockBranch getBranch(ITreePart treepart) {
        return treepart instanceof BlockBranch ? (BlockBranch)treepart : null;
    }

    public static BlockBranch getBranch(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getBranch(blockAccess.func_180495_p(pos));
    }

    public static BlockBranch getBranch(IBlockState state) {
        return TreeHelper.getBranch(state.func_177230_c());
    }

    public static boolean isLeaves(Block block) {
        return block instanceof BlockDynamicLeaves;
    }

    public static boolean isLeaves(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isLeaves(blockAccess.func_180495_p(pos).func_177230_c());
    }

    public static boolean isLeaves(IBlockState blockState) {
        return TreeHelper.isLeaves(blockState.func_177230_c());
    }

    public static boolean isRootyDirt(Block block) {
        return block instanceof BlockRootyDirt;
    }

    public static boolean isRootyDirt(IBlockState soilBlockState) {
        return TreeHelper.isRootyDirt(soilBlockState.func_177230_c());
    }

    public static boolean isRootyDirt(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isRootyDirt(blockAccess.func_180495_p(pos));
    }

    public static BlockRootyDirt getRootyDirt(Block block) {
        return TreeHelper.isRootyDirt(block) ? (BlockRootyDirt)block : null;
    }

    public static BlockRootyDirt getRootyDirt(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getRootyDirt(blockAccess.func_180495_p(pos).func_177230_c());
    }
}

