/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBonsaiPot
extends Block {
    protected Map<Integer, DynamicTree> trees = new HashMap<Integer, DynamicTree>();
    public static final String name = "bonsaipot";
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public BlockBonsaiPot() {
        this(name);
    }

    public BlockBonsaiPot(String name) {
        super(Blocks.field_150457_bL.func_149688_o(Blocks.field_150457_bL.func_176223_P()));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.OAK));
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    public void setupVanillaTree(DynamicTree tree) {
        this.trees.put(((BlockPlanks.EnumType)tree.getPrimitiveSapling().func_177229_b((IProperty)BlockSapling.field_176480_a)).ordinal(), tree);
    }

    public DynamicTree getTree(IBlockState state) {
        if (state.func_177230_c() == this) {
            return this.trees.get(((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockSapling.field_176480_a)).ordinal());
        }
        return this.trees.get(0);
    }

    public boolean setTree(World world, DynamicTree tree, BlockPos pos) {
        IBlockState primitiveSapling = tree.getPrimitiveSapling();
        if (primitiveSapling.func_177230_c() == Blocks.field_150345_g) {
            BlockPlanks.EnumType woodType = (BlockPlanks.EnumType)primitiveSapling.func_177229_b((IProperty)BlockSapling.field_176480_a);
            world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)woodType));
            return true;
        }
        return false;
    }

    public boolean setSpecies(World world, Species species, BlockPos pos) {
        if (species == species.getTree().getCommonSpecies()) {
            return this.setTree(world, species.getTree(), pos);
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && heldItem == null) {
            DynamicTree tree = this.getTree(state);
            if (!world.field_72995_K) {
                ItemStack seedStack = tree.getCommonSpecies().getSeedStack(1);
                ItemStack saplingStack = new ItemStack(tree.getPrimitiveSapling().func_177230_c(), 1, ((BlockPlanks.EnumType)tree.getPrimitiveSapling().func_177229_b((IProperty)BlockSapling.field_176480_a)).func_176839_a());
                CompatHelper.spawnEntity(world, (Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.func_70093_af() ? saplingStack : seedStack));
            }
            world.func_175656_a(pos, Blocks.field_150457_bL.func_176223_P());
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Items.field_151162_bE);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151162_bE;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List ret = super.getDrops(world, pos, state, fortune);
        DynamicTree tree = this.getTree(state);
        ret.add(tree.getCommonSpecies().getSeedStack(1));
        return ret;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.func_176837_a((int)(meta & 0xF)));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockSapling.field_176480_a)).func_176839_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockSapling.field_176480_a});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

