/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.IBurningListener;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.inspectors.NodeDestroyer;
import com.ferreusveritas.dynamictrees.inspectors.NodeNetVolume;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockBranch
extends Block
implements ITreePart,
IBurningListener {
    private DynamicTree tree;
    public static final PropertyInteger RADIUS = PropertyInteger.func_177719_a((String)"radius", (int)1, (int)8);
    public static final IUnlistedProperty<Integer> RADIUSD = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusd", (int)0, (int)8));
    public static final IUnlistedProperty<Integer> RADIUSU = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusu", (int)0, (int)8));
    public static final IUnlistedProperty<Integer> RADIUSN = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusn", (int)0, (int)8));
    public static final IUnlistedProperty<Integer> RADIUSS = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuss", (int)0, (int)8));
    public static final IUnlistedProperty<Integer> RADIUSW = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusw", (int)0, (int)8));
    public static final IUnlistedProperty<Integer> RADIUSE = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuse", (int)0, (int)8));
    public static final IUnlistedProperty[] CONNECTIONS = new IUnlistedProperty[]{RADIUSD, RADIUSU, RADIUSN, RADIUSS, RADIUSW, RADIUSE};

    public BlockBranch(String name) {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf(1)));
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{RADIUS};
        return new ExtendedBlockState((Block)this, listedProperties, CONNECTIONS);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf((meta & 7) + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)RADIUS) - 1;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            int thisRadius = this.getRadius(state);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                retval = retval.withProperty(CONNECTIONS[dir.func_176745_a()], (Object)this.getSideConnectionRadius(world, pos, thisRadius, dir));
            }
            return retval;
        }
        return state;
    }

    public void setTree(DynamicTree tree) {
        this.tree = tree;
    }

    public DynamicTree getTree() {
        return this.tree;
    }

    @Override
    public DynamicTree getTree(IBlockAccess blockAccess, BlockPos pos) {
        return this.getTree();
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isSameWood(ITreePart treepart) {
        return this.isSameWood(TreeHelper.getBranch(treepart));
    }

    public boolean isSameWood(BlockBranch branch) {
        return branch != null && this.getTree() == branch.getTree();
    }

    @Override
    public int branchSupport(IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return this.isSameWood(branch) ? 17 : 0;
    }

    public boolean checkForRot(World world, BlockPos pos, int radius, Random rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.nextFloat() > chance)) {
            return false;
        }
        int neigh = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            if ((neigh += TreeHelper.getSafeTreePart((IBlockAccess)world, deltaPos).branchSupport((IBlockAccess)world, this, deltaPos, dir, radius)) < 16 || (neigh & 0xF) < 2) continue;
            return false;
        }
        boolean didRot = this.getTree().rot(world, pos, neigh & 0xF, radius, rand);
        if (rapid && didRot) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos neighPos = pos.func_177972_a(dir);
                IBlockState state = world.func_180495_p(neighPos);
                if (state.func_177230_c() != this) continue;
                this.checkForRot(world, neighPos, this.getRadius(state), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        DynamicTree tree = TreeHelper.getSafeTreePart((IBlockAccess)world, pos).getTree((IBlockAccess)world, pos);
        if (tree != null) {
            return tree.onTreeActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        int radius = this.getRadius((IBlockAccess)world, pos);
        return this.getTree().getPrimitiveLog().func_177230_c().func_176195_g(blockState, world, pos) * (float)(radius * radius) / 64.0f * 8.0f;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTree().getPrimitiveLog().func_177230_c().getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        int radius = this.getRadius(world, pos);
        return this.getTree().getPrimitiveLog().func_177230_c().getFireSpreadSpeed(world, pos, face) * radius / 8;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.getRadius(state) == 8;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (this.getRadius(blockState) == 8) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        return true;
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, DynamicTree leavesTree) {
        DynamicTree thisTree = this.getTree();
        if (leavesTree == thisTree) {
            return thisTree.getCellForBranch(blockAccess, pos, blockState, dir, this);
        }
        return Cells.nullCell;
    }

    @Override
    public int getRadius(IBlockAccess blockAccess, BlockPos pos) {
        return this.getRadius(blockAccess.func_180495_p(pos));
    }

    public int getRadius(IBlockState blockState) {
        if (blockState.func_177230_c() == this) {
            return (Integer)blockState.func_177229_b((IProperty)RADIUS);
        }
        return 0;
    }

    public void setRadius(World world, BlockPos pos, int radius) {
        world.func_180501_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf(MathHelper.clamp(radius, 1, 8))), 2);
    }

    @Override
    public int probabilityForBlock(IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return this.isSameWood(from) ? this.getRadius(blockAccess, pos) + 2 : 0;
    }

    public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal, int fromRadius) {
        DynamicTree tree = signal.getSpecies().getTree();
        BlockDynamicLeaves leaves = tree.getDynamicLeaves();
        if (leaves != null) {
            if (fromRadius == 1) {
                signal.success = leaves.growLeaves(world, tree, pos, 0);
            } else {
                return leaves.branchOut(world, pos, signal);
            }
        }
        return signal;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            Species species = signal.getSpecies();
            EnumFacing originDir = signal.dir.func_176734_d();
            EnumFacing targetDir = this.tree.getCommonSpecies().selectNewDirection(world, pos, this, signal);
            signal.doTurn(targetDir);
            BlockPos deltaPos = pos.func_177972_a(targetDir);
            ITreePart treepart = TreeHelper.getTreePart((IBlockAccess)world, deltaPos);
            if (treepart != null) {
                signal = treepart.growSignal(world, deltaPos, signal);
            } else if (world.func_175623_d(deltaPos)) {
                signal = this.growIntoAir(world, deltaPos, signal, this.getRadius((IBlockAccess)world, pos));
            }
            float areaAccum = signal.radius * signal.radius;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos deltaPos2;
                ITreePart treepart2;
                if (dir.equals((Object)originDir) || dir.equals((Object)targetDir) || !this.isSameWood(treepart2 = TreeHelper.getTreePart((IBlockAccess)world, deltaPos2 = pos.func_177972_a(dir)))) continue;
                int branchRadius = treepart2.getRadius((IBlockAccess)world, deltaPos2);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            signal.radius = MathHelper.clamp((float)Math.sqrt(areaAccum) + species.getTapering(), (float)this.getRadius((IBlockAccess)world, pos), 8.0f);
            this.setRadius(world, pos, (int)Math.floor(signal.radius));
        }
        return signal;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return field_185506_k;
        }
        int thisRadius = this.getRadius(state);
        boolean connectionMade = false;
        double radius = (double)thisRadius / 16.0;
        double gap = 0.5 - radius;
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.getSideConnectionRadius(blockAccess, pos, thisRadius, dir) <= 0) continue;
            connectionMade = true;
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap);
        }
        if (connectionMade) {
            return aabb.func_72317_d(0.5, 0.5, 0.5);
        }
        return new AxisAlignedBB(0.5 - radius, 0.5 - radius, 0.5 - radius, 0.5 + radius, 0.5 + radius, 0.5 + radius);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        int thisRadius = this.getRadius(state);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connRadius = this.getSideConnectionRadius((IBlockAccess)worldIn, pos, thisRadius, dir);
            if (connRadius <= 0) continue;
            double radius = (double)MathHelper.clamp(connRadius, 1, thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
            aabb = aabb.func_72317_d((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap).func_72317_d(0.5, 0.5, 0.5);
            BlockBranch.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    @Override
    public int getRadiusForConnection(IBlockAccess world, BlockPos pos, BlockBranch from, int fromRadius) {
        return this.getRadius(world, pos);
    }

    public int getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        return TreeHelper.getSafeTreePart(blockAccess, deltaPos).getRadiusForConnection(blockAccess, deltaPos, this, radius);
    }

    @Override
    public MapSignal analyse(World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        if (signal.depth++ < 32) {
            signal.run(world, this, pos, fromDir);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir == fromDir) continue;
                BlockPos deltaPos = pos.func_177972_a(dir);
                signal = TreeHelper.getSafeTreePart((IBlockAccess)world, deltaPos).analyse(world, deltaPos, dir.func_176734_d(), signal);
                if (!signal.found || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(world, this, pos, fromDir);
        } else {
            world.func_175698_g(pos);
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    public Species getSpeciesFromSignal(World world, MapSignal signal) {
        Species species;
        if (signal.found) {
            BlockRootyDirt rootyDirt = (BlockRootyDirt)world.func_180495_p(signal.root).func_177230_c();
            species = rootyDirt.getSpecies(world, signal.root);
        } else {
            species = this.getTree().getCommonSpecies();
        }
        return species;
    }

    public int destroyTreeFromNode(World world, BlockPos pos) {
        MapSignal signal = this.analyse(world, pos, null, new MapSignal());
        Species species = this.getSpeciesFromSignal(world, signal);
        NodeNetVolume volumeSum = new NodeNetVolume();
        this.analyse(world, pos, signal.localRootDir, new MapSignal(volumeSum, new NodeDestroyer(species)));
        return volumeSum.getVolume();
    }

    public int destroyEntireTree(World world, BlockPos pos) {
        MapSignal signal = this.analyse(world, pos, null, new MapSignal());
        Species species = this.getSpeciesFromSignal(world, signal);
        NodeNetVolume volumeSum = new NodeNetVolume();
        this.analyse(world, pos, null, new MapSignal(volumeSum, new NodeDestroyer(species)));
        return volumeSum.getVolume();
    }

    public List<ItemStack> getWoodDrops(World world, BlockPos pos, int volume) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        volume = (int)((float)volume * ModConfigs.treeHarvestMultiplier);
        DynamicTree tree = this.getTree();
        ItemStack logStack = tree.getPrimitiveLogItemStack(volume / 4096);
        ItemStack stickStack = tree.getStick(volume % 4096 / 512);
        ret.add(logStack);
        ret.add(stickStack);
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        ItemStack heldItem = player.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        int woodVolume = this.destroyTreeFromNode(world, pos);
        List<ItemStack> items = this.getWoodDrops(world, pos, (int)((float)woodVolume * fortuneFactor));
        float chance = ForgeEventFactory.fireBlockHarvesting(items, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        for (ItemStack item : items) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            BlockBranch.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
        }
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        int woodVolume = this.destroyTreeFromNode(world, pos);
        for (ItemStack item : this.getWoodDrops(world, pos, woodVolume)) {
            BlockBranch.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
        }
    }

    @Override
    public void onBurned(World world, IBlockState oldState, BlockPos burnedPos) {
        if (oldState.func_177230_c() == this) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos rootPos;
                BlockPos neighPos = burnedPos.func_177972_a(dir);
                if (!TreeHelper.isBranch((IBlockAccess)world, neighPos) || (rootPos = DynamicTree.findRootNode(world, neighPos)) != null) continue;
                this.analyse(world, neighPos, null, new MapSignal(new NodeDestroyer(this.getTree().getCommonSpecies())));
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos neighbor = pos.func_177972_a(dir);
            IBlockState neighBlockState = world.func_180495_p(neighbor);
            if (neighBlockState.func_185904_a() != Material.field_151581_o || neighBlockState.func_177230_c() == ModBlocks.blockVerboseFire) continue;
            int age = neighBlockState.func_177230_c() == Blocks.field_150480_ab ? (Integer)neighBlockState.func_177229_b((IProperty)BlockFire.field_176543_a) : 0;
            world.func_175656_a(neighbor, ModBlocks.blockVerboseFire.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(age)));
        }
    }

    @Override
    public boolean isBranch() {
        return true;
    }

    @Override
    public boolean isRootNode() {
        return false;
    }
}

