/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.tileentity.TileEntityDendroCoil;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.Circle;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.worldgen.CircleHelper;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockDendroCoil
extends BlockContainer
implements IPeripheralProvider {
    public BlockDendroCoil() {
        this("dendrocoil");
    }

    public BlockDendroCoil(String name) {
        super(Material.field_151573_f);
        this.func_149663_c(name);
        this.func_149647_a(DynamicTrees.dynamicTreesTab);
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)this);
        this.setRegistryName(name);
        GameRegistry.registerTileEntity(TileEntityDendroCoil.class, (String)name);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (world.func_175687_A(pos) != 0) {
            this.growPulse(world, pos);
        }
    }

    public String getCode(World world, BlockPos pos) {
        if (TreeHelper.isRootyDirt((IBlockAccess)world, pos = pos.func_177984_a())) {
            return new JoCode().buildFromTree(world, pos).toString();
        }
        return "";
    }

    public void setCode(World world, BlockPos pos, String treeName, String JoCode2) {
        JoCode jo = new JoCode(JoCode2);
        Species species = TreeRegistry.findSpeciesSloppy(treeName);
        if (species != null) {
            jo.setCareful(true).generate(world, species, pos.func_177984_a(), world.func_180494_b(pos), EnumFacing.NORTH, 8);
        } else {
            Logger.getLogger("dynamictrees").log(Level.WARNING, "Tree: " + treeName + " not found.");
        }
    }

    public void createStaff(World world, BlockPos pos, String treeName, String JoCode2, String rgb, boolean readOnly) {
        ItemStack stack = new ItemStack((Item)ModItems.treeStaff, 1, 0);
        Species tree = TreeRegistry.findSpeciesSloppy(treeName);
        ModItems.treeStaff.setSpecies(stack, tree).setCode(stack, JoCode2).setColor(stack, rgb).setReadOnly(stack, readOnly);
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, stack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        CompatHelper.spawnEntity(world, (Entity)entityItem);
    }

    public String getSpecies(World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart((IBlockAccess)world, pos.func_177984_a());
        if (part.isRootNode()) {
            return DynamicTree.getExactSpecies(world, pos.func_177984_a()).toString();
        }
        return "";
    }

    public void plantTree(World world, BlockPos pos, String treeName) {
        Species species = TreeRegistry.findSpeciesSloppy(treeName);
        if (species != null) {
            species.getSeed().plantSapling(world, pos.func_177981_b(2), species.getSeedStack(1));
        }
    }

    public void growPulse(World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart((IBlockAccess)world, pos.func_177984_a());
        if (part.isRootNode()) {
            TreeHelper.growPulse(world, pos.func_177984_a());
        }
    }

    public void killTree(World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart((IBlockAccess)world, pos.func_177984_a());
        if (part.isRootNode()) {
            ((BlockRootyDirt)part).destroyTree(world, pos.func_177984_a());
        }
    }

    public int getSoilLife(World world, BlockPos pos) {
        ITreePart part = TreeHelper.getSafeTreePart((IBlockAccess)world, pos.func_177984_a());
        if (part.isRootNode()) {
            return ((BlockRootyDirt)part).getSoilLife((IBlockAccess)world, pos.func_177984_a());
        }
        return 0;
    }

    public void setSoilLife(World world, BlockPos pos, int life) {
        ITreePart part = TreeHelper.getSafeTreePart((IBlockAccess)world, pos.func_177984_a());
        if (part.isRootNode()) {
            ((BlockRootyDirt)part).setSoilLife(world, pos.func_177984_a(), life);
        }
    }

    public void testPoisson(World world, BlockPos pos, int rad1, int rad2, double angle) {
        pos = pos.func_177984_a();
        for (int y = 0; y < 2; ++y) {
            for (int z = -28; z <= 28; ++z) {
                for (int x = -28; x <= 28; ++x) {
                    world.func_175698_g(pos.func_177982_a(x, y, z));
                }
            }
        }
        if (rad1 >= 2 && rad2 >= 2 && rad1 <= 8 && rad2 <= 8) {
            Circle circleA = new Circle(pos, rad1);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleA, pos.func_177956_o(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            Circle circleB = CircleHelper.findSecondCircle(circleA, rad2, angle);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleB, pos.func_177956_o(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            world.func_175656_a(new BlockPos(circleB.x, pos.func_177984_a().func_177956_o(), circleB.z), circleB.isLoose() ? Blocks.field_150347_e.func_176223_P() : Blocks.field_150484_ah.func_176223_P());
        }
    }

    public void testPoisson2(World world, BlockPos pos, int rad1, int rad2, double angle, int rad3) {
        pos = pos.func_177984_a();
        for (int y = 0; y < 2; ++y) {
            for (int z = -28; z <= 28; ++z) {
                for (int x = -28; x <= 28; ++x) {
                    world.func_175698_g(pos.func_177982_a(x, y, z));
                }
            }
        }
        if (rad1 >= 2 && rad2 >= 2 && rad1 <= 8 && rad2 <= 8 && rad3 >= 2 && rad3 <= 8) {
            Circle circleA = new Circle(pos, rad1);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleA, pos.func_177956_o(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            Circle circleB = CircleHelper.findSecondCircle(circleA, rad2, angle);
            TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleB, pos.func_177956_o(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            CircleHelper.maskCircles(circleA, circleB);
            Circle circleC = CircleHelper.findThirdCircle(circleA, circleB, rad3);
            if (circleC != null) {
                TreeGenerator.getTreeGenerator().makeWoolCircle(world, circleC, pos.func_177956_o(), TreeGenerator.EnumGeneratorResult.NOTREE, 3);
            } else {
                System.out.println("Angle:" + angle);
                world.func_175656_a(new BlockPos(circleA.x, pos.func_177984_a().func_177956_o(), circleA.z), Blocks.field_150451_bX.func_176223_P());
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDendroCoil();
    }

    public IPeripheral getPeripheral(World world, BlockPos pos, EnumFacing facing) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDendroCoil) {
            return (TileEntityDendroCoil)te;
        }
        return null;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add("\u00a76ComputerCraft Peripheral");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

