/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.IAgeable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamicLeaves
extends BlockLeaves
implements ITreePart,
IAgeable {
    public static final PropertyInteger HYDRO = PropertyInteger.func_177719_a((String)"hydro", (int)1, (int)4);
    public static final PropertyInteger TREE = PropertyInteger.func_177719_a((String)"tree", (int)0, (int)3);
    private DynamicTree[] trees = new DynamicTree[4];

    public BlockDynamicLeaves() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HYDRO, TREE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(meta >> 2 & 3)).func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf((meta & 3) + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)HYDRO) - 1 | (Integer)state.func_177229_b((IProperty)TREE) << 2;
    }

    public void setTree(int treeNum, DynamicTree tree) {
        this.trees[treeNum & 3] = tree;
    }

    @Override
    public DynamicTree getTree(IBlockAccess blockAccess, BlockPos pos) {
        return this.getTree(blockAccess.func_180495_p(pos));
    }

    public DynamicTree getTree(IBlockState blockState) {
        return this.getTree((Integer)blockState.func_177229_b((IProperty)TREE));
    }

    public DynamicTree getTree(int treeNum) {
        return this.trees[treeNum & 3];
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return (int)((float)this.getTree(world, pos).getPrimitiveLeaves().func_177230_c().getFlammability(world, pos, face) * 0.75f);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTree(world, pos).getPrimitiveLeaves().func_177230_c().getFireSpreadSpeed(world, pos, face);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.age(worldIn, pos, state, rand, false);
    }

    @Override
    public boolean age(World world, BlockPos pos, IBlockState state, Random rand, boolean rapid) {
        DynamicTree tree = this.getTree(state);
        int preHydro = this.getHydrationLevel(state);
        int hydro = this.getHydrationLevelFromNeighbors((IBlockAccess)world, pos, tree);
        if (hydro == 0 || !rapid && !this.hasAdequateLight(world, tree, pos)) {
            BlockDynamicLeaves.removeLeaves(world, pos);
            return true;
        }
        if (preHydro != hydro && BlockDynamicLeaves.setHydrationLevel(world, pos, hydro, state)) {
            return true;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (hydro <= 1 && rand.nextInt(4) != 0) continue;
            this.growLeaves(world, tree, pos.func_177972_a(dir));
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing dir = facing.func_176734_d();
        BlockPos deltaPos = pos.func_177972_a(dir);
        DynamicTree tree = TreeHelper.getSafeTreePart((IBlockAccess)world, deltaPos).getTree((IBlockAccess)world, deltaPos);
        if (tree != null && tree.getDynamicLeaves() == this) {
            return this.func_176223_P().func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(tree.getDynamicLeavesSub()));
        }
        return this.func_176223_P();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        AxisAlignedBB aabb = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
        BlockDynamicLeaves.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity instanceof EntityLivingBase) {
            entity.field_70143_R -= 1.0f;
            AxisAlignedBB aabb = entity.func_174813_aQ();
            int minX = MathHelper.floor(aabb.field_72340_a + 0.001);
            int minZ = MathHelper.floor(aabb.field_72339_c + 0.001);
            int maxX = MathHelper.floor(aabb.field_72336_d - 0.001);
            int maxZ = MathHelper.floor(aabb.field_72334_f - 0.001);
            boolean crushing = true;
            boolean hasLeaves = true;
            SoundType stepSound = this.func_185467_w();
            float volume = MathHelper.clamp(stepSound.func_185843_a() / 16.0f * fallDistance, 0.0f, 3.0f);
            world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stepSound.func_185845_c(), SoundCategory.BLOCKS, volume, stepSound.func_185847_b(), false);
            int iy = 0;
            while (entity.field_70143_R > 3.0f && crushing && pos.func_177956_o() - iy > 0) {
                if (hasLeaves) {
                    entity.field_70143_R *= 0.66f;
                    hasLeaves = false;
                }
                for (int ix = minX; ix <= maxX; ++ix) {
                    for (int iz = minZ; iz <= maxZ; ++iz) {
                        BlockPos iPos = new BlockPos(ix, pos.func_177956_o() - iy, iz);
                        IBlockState state = world.func_180495_p(iPos);
                        if (TreeHelper.isLeaves(state)) {
                            hasLeaves = true;
                            DynamicTrees.proxy.crushLeavesBlock(world, iPos, state, entity);
                            world.func_175698_g(iPos);
                            continue;
                        }
                        if (world.func_175623_d(iPos)) continue;
                        crushing = false;
                    }
                }
                ++iy;
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity.field_70181_x < 0.0 && entity.field_70143_R < 2.0f) {
            entity.field_70143_R = 0.0f;
            entity.field_70181_x *= 0.5;
        } else if (entity.field_70181_x > 0.0 && entity.field_70181_x < 0.25) {
            entity.field_70181_x += 0.025;
        }
        entity.func_70031_b(false);
        entity.field_70159_w *= 0.25;
        entity.field_70179_y *= 0.25;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
    }

    public void growLeaves(World world, DynamicTree tree, BlockPos pos) {
        if (this.isLocationSuitableForNewLeaves(world, tree, pos)) {
            int hydro = this.getHydrationLevelFromNeighbors((IBlockAccess)world, pos, tree);
            this.setBlockToLeaves(world, tree, pos, hydro);
        }
    }

    public boolean growLeaves(World world, DynamicTree tree, BlockPos pos, int hydro) {
        int n = hydro = hydro == 0 ? (int)tree.getDefaultHydration() : hydro;
        if (this.isLocationSuitableForNewLeaves(world, tree, pos)) {
            return this.setBlockToLeaves(world, tree, pos, hydro);
        }
        return false;
    }

    public boolean isLocationSuitableForNewLeaves(World world, DynamicTree tree, BlockPos pos) {
        BlockDoublePlant.EnumPlantType type;
        IBlockState bs;
        BlockDoublePlant.EnumBlockHalf half;
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockDynamicLeaves) {
            return false;
        }
        IBlockState belowBlockState = world.func_180495_p(pos.func_177977_b());
        if (belowBlockState.func_185917_h() && !(belowBlockState.func_177230_c() instanceof BlockLeaves) || belowBlockState.func_177230_c() instanceof BlockLiquid) {
            return false;
        }
        if (block == Blocks.field_150398_cm && (half = (BlockDoublePlant.EnumBlockHalf)(bs = world.func_180495_p(pos)).func_177229_b((IProperty)BlockDoublePlant.field_176492_b)) == BlockDoublePlant.EnumBlockHalf.UPPER && belowBlockState.func_177230_c() == Blocks.field_150398_cm && ((type = (BlockDoublePlant.EnumPlantType)belowBlockState.func_177229_b((IProperty)BlockDoublePlant.field_176493_a)) == BlockDoublePlant.EnumPlantType.GRASS || type == BlockDoublePlant.EnumPlantType.FERN)) {
            world.func_175698_g(pos);
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)(type == BlockDoublePlant.EnumPlantType.GRASS ? BlockTallGrass.EnumType.GRASS : BlockTallGrass.EnumType.FERN)), 3);
        }
        return world.func_175623_d(pos) && this.hasAdequateLight(world, tree, pos);
    }

    public boolean setBlockToLeaves(World world, DynamicTree tree, BlockPos pos, int hydro) {
        if ((hydro = MathHelper.clamp(hydro, 0, 4)) != 0) {
            world.func_180501_a(pos, tree.getDynamicLeavesState().func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(hydro)), 2);
            return true;
        }
        BlockDynamicLeaves.removeLeaves(world, pos);
        return false;
    }

    public boolean hasAdequateLight(World world, DynamicTree tree, BlockPos pos) {
        if (world.func_175710_j(pos)) {
            return true;
        }
        int smother = tree.getSmotherLeavesMax();
        if (smother != 0 && BlockDynamicLeaves.isBottom(world, pos, world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            int smotherLeaves = 0;
            for (int i = 0; i < smother; ++i) {
                smotherLeaves += TreeHelper.isTreePart((IBlockAccess)world, pos.func_177981_b(i + 1)) ? 1 : 0;
            }
            if (smotherLeaves >= smother) {
                return false;
            }
        }
        return world.func_175642_b(EnumSkyBlock.SKY, pos) >= (TreeHelper.isLeaves((IBlockAccess)world, pos) ? tree.getLightRequirement() - 2 : tree.getLightRequirement());
    }

    public static boolean isBottom(World world, BlockPos pos) {
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return BlockDynamicLeaves.isBottom(world, pos, belowBlock);
    }

    public static boolean isBottom(World world, BlockPos pos, Block belowBlock) {
        if (TreeHelper.isTreePart(belowBlock)) {
            ITreePart belowTreepart = (ITreePart)belowBlock;
            return belowTreepart.getRadius((IBlockAccess)world, pos.func_177977_b()) > 1;
        }
        return true;
    }

    public int getHydrationLevelFromNeighbors(IBlockAccess world, BlockPos pos, DynamicTree tree) {
        ICell[] cells = new ICell[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            IBlockState state = world.func_180495_p(deltaPos);
            cells[dir.ordinal()] = TreeHelper.getSafeTreePart(state).getHydrationCell(world, deltaPos, state, dir, tree);
        }
        return tree.getCellSolver().solve(cells);
    }

    public int getHydrationLevel(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockDynamicLeaves) {
            return (Integer)blockState.func_177229_b((IProperty)HYDRO);
        }
        return 0;
    }

    public int getHydrationLevel(IBlockAccess blockAccess, BlockPos pos) {
        return this.getHydrationLevel(blockAccess.func_180495_p(pos));
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, DynamicTree leavesTree) {
        int hydro = this.getHydrationLevel(blockState);
        DynamicTree tree = this.getTree(blockState);
        if (dir != null && tree != null) {
            return tree.getCellForLeaves(hydro);
        }
        return Cells.normalCells[hydro];
    }

    public static void removeLeaves(World world, BlockPos pos) {
        world.func_175698_g(pos);
        world.func_175685_c(pos, Blocks.field_150350_a);
    }

    public static boolean setHydrationLevel(World world, BlockPos pos, int hydro, IBlockState currentBlockState) {
        if ((hydro = MathHelper.clamp(hydro, 0, 4)) == 0) {
            BlockDynamicLeaves.removeLeaves(world, pos);
            return true;
        }
        world.func_180501_a(pos, currentBlockState.func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(hydro)), 4);
        return false;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            this.branchOut(world, pos, signal);
        }
        return signal;
    }

    public boolean needLeaves(World world, BlockPos pos, DynamicTree tree) {
        if (world.func_175623_d(pos)) {
            return this.growLeaves(world, tree, pos, tree.getDefaultHydration());
        }
        IBlockState blockState = world.func_180495_p(pos);
        ITreePart treepart = TreeHelper.getSafeTreePart(blockState);
        return treepart == this && tree == this.getTree(blockState);
    }

    public GrowSignal branchOut(World world, BlockPos pos, GrowSignal signal) {
        DynamicTree tree = signal.getSpecies().getTree();
        if (tree == null || !this.needLeaves(world, pos, tree)) {
            signal.success = false;
            return signal;
        }
        EnumFacing originDir = signal.dir.func_176734_d();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir.equals((Object)originDir) || !TreeHelper.isBranch((IBlockAccess)world, pos.func_177972_a(dir))) continue;
            signal.success = false;
            return signal;
        }
        boolean hasLeaves = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.needLeaves(world, pos.func_177972_a(dir), tree)) continue;
            hasLeaves = true;
            break;
        }
        if (hasLeaves) {
            world.func_180501_a(pos, tree.getDynamicBranch().func_176223_P(), 2);
            signal.radius = signal.getSpecies().getSecondaryThickness();
        }
        signal.success = hasLeaves;
        return signal;
    }

    @Override
    public int probabilityForBlock(IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return from.getTree().isCompatibleDynamicLeaves(blockAccess, pos) ? 2 : 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Species species = this.getExactSpecies(world, pos, this.getTree(state));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (species != null) {
            Random rand;
            int chance = this.func_176232_d(state);
            if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                chance = 10;
            }
            Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            if (rand.nextInt(chance) == 0) {
                ret.add(species.getSeedStack(1));
            }
            chance = 200;
            if (fortune > 0 && (chance -= 10 << fortune) < 40) {
                chance = 40;
            }
            ret = species.getDrops(world, pos, chance, ret);
        }
        return ret;
    }

    Species getExactSpecies(IBlockAccess access, BlockPos pos, DynamicTree tree) {
        if (access instanceof World) {
            World world = (World)access;
            ArrayList<BlockPos> branchList = new ArrayList<BlockPos>();
            for (BlockPos dPos : tree.getLeafCluster().getAllNonZero()) {
                BlockBranch branch;
                IBlockState state = access.func_180495_p(dPos = pos.func_177971_a((Vec3i)BlockPos.field_177992_a.func_177973_b((Vec3i)dPos)));
                if (!TreeHelper.isBranch(state) || (branch = TreeHelper.getBranch(state)).getTree() != tree || branch.getRadius(state) != 1) continue;
                branchList.add(dPos);
            }
            if (!branchList.isEmpty()) {
                BlockPos closest = (BlockPos)branchList.get(0);
                double minDist = 999.0;
                for (BlockPos dPos : branchList) {
                    double d = pos.func_177951_i((Vec3i)dPos);
                    if (!(d < minDist)) continue;
                    minDist = d;
                    closest = dPos;
                }
                return DynamicTree.getExactSpecies(world, closest);
            }
        }
        return null;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess blockAccess, BlockPos pos, int fortune) {
        DynamicTree tree = this.getTree(blockAccess, pos);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(tree.getPrimitiveLeavesItemStack(1));
        return ret;
    }

    @Override
    public int getRadiusForConnection(IBlockAccess blockAccess, BlockPos pos, BlockBranch from, int fromRadius) {
        return fromRadius == 1 && from.getTree().isCompatibleDynamicLeaves(blockAccess, pos) ? 1 : 0;
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public int getRadius(IBlockAccess blockAccess, BlockPos pos) {
        return 0;
    }

    @Override
    public MapSignal analyse(World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public boolean isRootNode() {
        return false;
    }

    @Override
    public boolean isBranch() {
        return false;
    }

    @Override
    public int branchSupport(IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return radius == 1 && branch.getTree() == this.getTree(blockAccess, pos) ? 1 : 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        this.func_150122_b(Minecraft.func_71375_t());
        return super.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        this.func_150122_b(Minecraft.func_71375_t());
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

