/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamicSapling
extends Block
implements IGrowable {
    public Species tree;

    public BlockDynamicSapling(String name) {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.func_176474_b(world, rand, pos, state);
    }

    public static boolean canSaplingStay(World world, Species species, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            IBlockState blockState = world.func_180495_p(pos.func_177972_a(dir));
            Block block = blockState.func_177230_c();
            if (!TreeHelper.isBranch(block) && !(block instanceof BlockDynamicSapling)) continue;
            return false;
        }
        return world.func_175623_d(pos.func_177984_a()) && species.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return BlockDynamicSapling.canSaplingStay(world, this.getSpecies(state), pos);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        Species species = this.getSpecies(state);
        if (this.canBlockStay(world, pos, state)) {
            DynamicTree tree = species.getTree();
            if (world.func_175623_d(pos.func_177984_a()) && species.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
                world.func_175656_a(pos, tree.getDynamicBranch().func_176223_P());
                world.func_175656_a(pos.func_177984_a(), tree.getDynamicLeavesState());
                world.func_175656_a(pos.func_177977_b(), species.getRootyDirtBlock().func_176223_P());
            }
        } else {
            this.dropBlock(world, species, state, pos);
        }
    }

    public Species getSpecies(IBlockState state) {
        return this.tree;
    }

    public BlockDynamicSapling setSpecies(IBlockState state, Species species) {
        this.tree = species;
        return this;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlock(world, this.getSpecies(state), state, pos);
        }
    }

    private void dropBlock(World world, Species tree, IBlockState state, BlockPos pos) {
        world.func_175698_g(pos);
        this.func_176226_b(world, pos, state, 0);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List dropped = super.getDrops(world, pos, state, fortune);
        dropped.add(this.getSpecies(state).getSeedStack(1));
        return dropped;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getSpecies(state).getSeedStack(1);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return this.getSpecies(state).canGrowWithBoneMeal(world, pos);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.getSpecies(state).canUseBoneMealNow(world, rand, pos);
    }
}

